/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script;

import io.warp10.WarpURLDecoder;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebAccessController {
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private final BitSet exclusion = new BitSet();

    public WebAccessController(String patternConf) {
        if (null != patternConf) {
            String[] subpatterns = patternConf.split(",");
            int idx = 0;
            for (String pattern : subpatterns) {
                try {
                    pattern = WarpURLDecoder.decode(pattern, StandardCharsets.UTF_8);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new RuntimeException(uee);
                }
                boolean exclude = false;
                if (pattern.startsWith("!")) {
                    exclude = true;
                    pattern = pattern.substring(1);
                }
                Pattern p = Pattern.compile(pattern);
                this.patterns.add(p);
                this.exclusion.set(idx, exclude);
                ++idx;
            }
            if (this.exclusion.cardinality() == idx) {
                int n;
                for (int i = n = this.exclusion.length(); i >= 1; --i) {
                    this.exclusion.set(i, this.exclusion.get(i - 1));
                }
                this.exclusion.set(0, false);
                this.patterns.add(0, Pattern.compile(".*"));
            }
        } else {
            this.patterns.add(Pattern.compile(".*"));
            this.exclusion.set(0, false);
        }
    }

    public boolean checkURL(URL url) {
        String protocol = url.getProtocol();
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            return false;
        }
        String host = url.getHost();
        boolean accept = false;
        for (int i = 0; i < this.patterns.size(); ++i) {
            Matcher m = this.patterns.get(i).matcher(host);
            if (!m.matches()) continue;
            accept = !this.exclusion.get(i);
        }
        return accept;
    }
}

