/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;

public class ResetCounter
extends NamedWarpScriptFunction
implements WarpScriptAggregatorFunction,
WarpScriptMapperFunction,
WarpScriptBucketizerFunction {
    private final boolean resetHigher;

    public ResetCounter(String name, boolean resetHigher) {
        super(name);
        this.resetHigher = resetHigher;
    }

    public ResetCounter(String name) {
        super(name);
        this.resetHigher = false;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        int[] indices = GTSHelper.sortIndices(ticks, false);
        GeoTimeSerie.TYPE type = GTSHelper.getValueType(values[0]);
        int resets = 0;
        Object lastvalue = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (this.resetHigher) {
                switch (type) {
                    case LONG: {
                        if (((Number)values[indices[i]]).longValue() <= (Long)lastvalue) break;
                        ++resets;
                        break;
                    }
                    case DOUBLE: {
                        if (!(((Number)values[indices[i]]).doubleValue() > (Double)lastvalue)) break;
                        ++resets;
                        break;
                    }
                    case STRING: {
                        if (((String)values[indices[i]]).compareTo((String)lastvalue) <= 0) break;
                        ++resets;
                        break;
                    }
                    case BOOLEAN: {
                        if (!Boolean.FALSE.equals(lastvalue) || !Boolean.TRUE.equals(values[indices[i]])) break;
                        ++resets;
                    }
                }
            } else {
                switch (type) {
                    case LONG: {
                        if (((Number)values[indices[i]]).longValue() >= (Long)lastvalue) break;
                        ++resets;
                        break;
                    }
                    case DOUBLE: {
                        if (!(((Number)values[indices[i]]).doubleValue() < (Double)lastvalue)) break;
                        ++resets;
                        break;
                    }
                    case STRING: {
                        if (((String)values[indices[i]]).compareTo((String)lastvalue) >= 0) break;
                        ++resets;
                        break;
                    }
                    case BOOLEAN: {
                        if (!Boolean.TRUE.equals(lastvalue) || !Boolean.FALSE.equals(values[indices[i]])) break;
                        ++resets;
                    }
                }
            }
            lastvalue = values[indices[i]];
        }
        return new Object[]{ticks[indices[indices.length - 1]], locations[indices[indices.length - 1]], elevations[indices[indices.length - 1]], resets};
    }
}

