/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.aggregator;

import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptReducerFunction;

public class Sum
extends NamedWarpScriptFunction
implements WarpScriptAggregatorFunction,
WarpScriptMapperFunction,
WarpScriptBucketizerFunction,
WarpScriptReducerFunction {
    private final boolean ignoreNulls;

    public Sum(String name, boolean ignoreNulls) {
        super(name);
        this.ignoreNulls = ignoreNulls;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (0 == ticks.length) {
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        long suml = 0L;
        double sumd = 0.0;
        GeoTimeSerie.TYPE sumType = GeoTimeSerie.TYPE.UNDEFINED;
        long location = 91480763316633925L;
        long elevation = Long.MIN_VALUE;
        long timestamp = Long.MIN_VALUE;
        boolean hasNulls = false;
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (ticks[i] > timestamp) {
                location = locations[i];
                elevation = elevations[i];
                timestamp = ticks[i];
            }
            if (null == value) {
                hasNulls = true;
                continue;
            }
            if (GeoTimeSerie.TYPE.LONG == sumType) {
                suml += ((Number)value).longValue();
                continue;
            }
            if (GeoTimeSerie.TYPE.DOUBLE == sumType) {
                sumd += ((Number)value).doubleValue();
                continue;
            }
            if (value instanceof Long) {
                suml = ((Number)value).longValue();
                sumType = GeoTimeSerie.TYPE.LONG;
                continue;
            }
            if (value instanceof Double) {
                sumd = ((Number)value).doubleValue();
                sumType = GeoTimeSerie.TYPE.DOUBLE;
                continue;
            }
            return new Object[]{Long.MAX_VALUE, 91480763316633925L, Long.MIN_VALUE, null};
        }
        Number sum = null;
        if (GeoTimeSerie.TYPE.LONG == sumType) {
            sum = suml;
        } else if (GeoTimeSerie.TYPE.DOUBLE == sumType) {
            sum = sumd;
        }
        if (hasNulls && !this.ignoreNulls) {
            sum = null;
        }
        return new Object[]{0L, location, elevation, sum};
    }
}

