/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.ext.stackps;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.WarpScriptStackRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WSINFO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public static final String[] EXPOSED_ATTRIBUTES = new String[]{"creation.time", "fetch.count", "gts.count", "macro.name", "stack.name", "section.name", "stackps.session"};

    public WSINFO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a session id.");
        }
        ArrayList<Map<Object, Object>> infos = new ArrayList<Map<Object, Object>>();
        String session = top.toString();
        for (WarpScriptStack stck : WarpScriptStackRegistry.stacks()) {
            if (!session.equals(stck.getAttribute("stackps.session"))) continue;
            infos.add(WSINFO.getInfos(stck));
        }
        stack.push(infos);
        return stack;
    }

    public static Map<Object, Object> getInfos(WarpScriptStack stck) {
        HashMap<Object, Object> infos = new HashMap<Object, Object>();
        infos.put("uuid", stck.getUUID());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        infos.put("attributes", attributes);
        for (String attr : EXPOSED_ATTRIBUTES) {
            attributes.put(attr, stck.getAttribute(attr));
        }
        return infos;
    }
}

