/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filter;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilterAny
extends NamedWarpScriptFunction
implements WarpScriptFilterFunction {
    private final GeoTimeSerie.TYPE type;
    private final Object threshold;
    private final boolean complementSet;
    private final Comparator comparator;

    public FilterAny(String name, Object threshold, Comparator comparator, boolean complementSet) throws WarpScriptException {
        super(name);
        boolean allowBooleanThreshold;
        this.comparator = comparator;
        this.complementSet = complementSet;
        boolean bl = allowBooleanThreshold = comparator == Comparator.EQ || comparator == Comparator.NE;
        if (threshold instanceof Long) {
            this.type = GeoTimeSerie.TYPE.LONG;
            this.threshold = threshold;
        } else if (threshold instanceof Double) {
            this.type = GeoTimeSerie.TYPE.DOUBLE;
            this.threshold = threshold;
        } else if (threshold instanceof String) {
            this.type = GeoTimeSerie.TYPE.STRING;
            this.threshold = threshold;
        } else if (allowBooleanThreshold && threshold instanceof Boolean) {
            this.type = GeoTimeSerie.TYPE.BOOLEAN;
            this.threshold = threshold;
        } else {
            throw new WarpScriptException(this.getName() + " threshold type is invalid.");
        }
    }

    private boolean verify(int i) throws WarpScriptException {
        switch (this.comparator) {
            case EQ: {
                return i == 0;
            }
            case GE: {
                return i <= 0;
            }
            case GT: {
                return i < 0;
            }
            case LE: {
                return i >= 0;
            }
            case LT: {
                return i > 0;
            }
            case NE: {
                return i != 0;
            }
        }
        throw new WarpScriptException(this.getName() + " has been implemented with an unknown comparator.");
    }

    @Override
    public List<GeoTimeSerie> filter(Map<String, String> labels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> retained = new ArrayList<GeoTimeSerie>();
        for (List<GeoTimeSerie> gtsinstances : series) {
            for (GeoTimeSerie serie : gtsinstances) {
                boolean found = false;
                int i = 0;
                while (!found && i < serie.size()) {
                    Object val = GTSHelper.valueAtIndex(serie, i++);
                    switch (this.type) {
                        case LONG: {
                            found = this.verify(((Long)this.threshold).compareTo(((Number)val).longValue()));
                            break;
                        }
                        case DOUBLE: {
                            found = this.verify(((Double)this.threshold).compareTo(((Number)val).doubleValue()));
                            break;
                        }
                        case STRING: {
                            found = this.verify(((String)this.threshold).compareTo(val.toString()));
                            break;
                        }
                        case BOOLEAN: {
                            found = ((Boolean)this.threshold).equals(val) ^ this.comparator == Comparator.NE;
                        }
                    }
                }
                if (!(found ^ this.complementSet)) continue;
                retained.add(serie);
            }
        }
        return retained;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.threshold));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        private final boolean complementSet;
        private final Comparator comparator;

        public Builder(String name, Comparator comparator, boolean complement) {
            super(name);
            this.comparator = comparator;
            this.complementSet = complement;
        }

        public Builder(String name, Comparator comparator) {
            super(name);
            this.comparator = comparator;
            this.complementSet = false;
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object threshold = stack.pop();
            stack.push(new FilterAny(this.getName(), threshold, this.comparator, this.complementSet));
            return stack;
        }
    }

    public static enum Comparator {
        EQ,
        GE,
        GT,
        LE,
        LT,
        NE;

    }
}

