/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filter;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LatencyFilter
extends NamedWarpScriptFunction
implements WarpScriptFilterFunction {
    private final long maxLatency;
    private final long minLatency;
    private final boolean uplinkLatencyMin;
    private final boolean uplinkLatencyMax;
    private final boolean downlinkLatencyMin;
    private final boolean downlinkLatencyMax;
    private final boolean downlinkMatches;
    private final boolean downlinksTotalMatches;
    private final boolean downlinksWithMatches;
    private final boolean downlinksBitset;
    private final List<String> options = new ArrayList<String>();

    public LatencyFilter(String name, long minLatency, long maxLatency, List<Object> options) {
        super(name);
        for (Object o : options) {
            this.options.add(o.toString());
        }
        this.minLatency = minLatency;
        this.maxLatency = maxLatency;
        this.uplinkLatencyMin = options.contains("uplink.latency.min");
        this.uplinkLatencyMax = options.contains("uplink.latency.max");
        this.downlinkLatencyMin = options.contains("downlink.latency.min");
        this.downlinkLatencyMax = options.contains("downlink.latency.max");
        this.downlinkMatches = options.contains("downlink.matches");
        this.downlinksBitset = options.contains("downlinks.bitset");
        this.downlinksTotalMatches = options.contains("downlinks.totalmatches");
        this.downlinksWithMatches = options.contains("downlinks.withmatches");
    }

    @Override
    public List<GeoTimeSerie> filter(Map<String, String> labels, List<GeoTimeSerie>[] series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> allseries = new ArrayList<GeoTimeSerie>();
        if (0 == series[0].size() || series[0].size() > 1) {
            return null;
        }
        for (List<GeoTimeSerie> lserie : series) {
            allseries.addAll(lserie);
        }
        for (GeoTimeSerie gts : allseries) {
            GTSHelper.valueSort(gts, false);
        }
        int[] indices = new int[allseries.size()];
        ArrayList<GeoTimeSerie> result = new ArrayList<GeoTimeSerie>();
        GeoTimeSerie inGTS = (GeoTimeSerie)allseries.get(0);
        GeoTimeSerie uplinkLatencyMinGTS = inGTS.cloneEmpty();
        uplinkLatencyMinGTS.getMetadata().setName(inGTS.getName() + ":uplink.latency.min");
        if (this.uplinkLatencyMin) {
            result.add(uplinkLatencyMinGTS);
        }
        GeoTimeSerie uplinkLatencyMax = inGTS.cloneEmpty();
        uplinkLatencyMax.getMetadata().setName(inGTS.getName() + ":uplink.latency.max");
        if (this.uplinkLatencyMax) {
            result.add(uplinkLatencyMax);
        }
        ArrayList<GeoTimeSerie> downlinkLatencyMinGTS = new ArrayList<GeoTimeSerie>();
        ArrayList<GeoTimeSerie> downlinkLatencyMaxGTS = new ArrayList<GeoTimeSerie>();
        ArrayList<GeoTimeSerie> downlinkMatchesGTS = new ArrayList<GeoTimeSerie>();
        int n = allseries.size();
        for (int i = 1; i < n; ++i) {
            GeoTimeSerie gts;
            if (this.downlinkLatencyMin) {
                gts = ((GeoTimeSerie)allseries.get(i)).cloneEmpty();
                gts.setName(gts.getName() + ":downlink.latency.min");
                downlinkLatencyMinGTS.add(gts);
            }
            if (this.downlinkLatencyMax) {
                gts = ((GeoTimeSerie)allseries.get(i)).cloneEmpty();
                gts.setName(gts.getName() + ":downlink.latency.max");
                downlinkLatencyMaxGTS.add(gts);
            }
            if (!this.downlinkMatches) continue;
            gts = ((GeoTimeSerie)allseries.get(i)).cloneEmpty();
            gts.setName(gts.getName() + ":downlink.matches");
            downlinkMatchesGTS.add(gts);
        }
        if (this.downlinkLatencyMin) {
            result.addAll(downlinkLatencyMinGTS);
        }
        if (this.downlinkLatencyMax) {
            result.addAll(downlinkLatencyMaxGTS);
        }
        if (this.downlinkMatches) {
            result.addAll(downlinkMatchesGTS);
        }
        GeoTimeSerie downlinksBitsetGTS = inGTS.cloneEmpty();
        downlinksBitsetGTS.setName(inGTS.getName() + ":downlinks.bitset");
        if (this.downlinksBitset) {
            result.add(downlinksBitsetGTS);
        }
        GeoTimeSerie downlinksTotalMatchesGTS = inGTS.cloneEmpty();
        downlinksTotalMatchesGTS.setName(inGTS.getName() + ":downlinks.totalmatches");
        if (this.downlinksTotalMatches) {
            result.add(downlinksTotalMatchesGTS);
        }
        GeoTimeSerie downlinksWithMatchesGTS = inGTS.cloneEmpty();
        downlinksWithMatchesGTS.setName(inGTS.getName() + ":downlinks.withmatches");
        if (this.downlinksWithMatches) {
            result.add(downlinksWithMatchesGTS);
        }
        long maxinidx = inGTS.size();
        while ((long)indices[0] < maxinidx) {
            long uplinkHash = ((Number)GTSHelper.valueAtIndex(inGTS, indices[0])).longValue();
            long uplinkTimestamp = GTSHelper.tickAtIndex(inGTS, indices[0]);
            long minLatency = Long.MAX_VALUE;
            long maxLatency = Long.MIN_VALUE;
            long totalLatency = 0L;
            int matchingDownlinkHashes = 0;
            int downlinksWithMatches = 0;
            long downlinksMask = 0L;
            for (int i = 1; i < allseries.size(); ++i) {
                GeoTimeSerie gts = (GeoTimeSerie)allseries.get(i);
                int startidx = indices[i];
                long downlink_minLatency = Long.MAX_VALUE;
                long downlink_maxLatency = Long.MIN_VALUE;
                int downlinkMatches = 0;
                while (indices[i] < gts.size()) {
                    long downlinkHash = ((Number)GTSHelper.valueAtIndex(gts, indices[i])).longValue();
                    if (downlinkHash < uplinkHash) {
                        int n2 = i;
                        indices[n2] = indices[n2] + 1;
                        startidx = indices[i];
                        continue;
                    }
                    if (downlinkHash > uplinkHash) break;
                    long downlinkTimestamp = GTSHelper.tickAtIndex(gts, indices[i]);
                    if (downlinkTimestamp < uplinkTimestamp + this.minLatency) {
                        int n3 = i;
                        indices[n3] = indices[n3] + 1;
                        startidx = indices[i];
                        continue;
                    }
                    long latency = downlinkTimestamp - uplinkTimestamp;
                    if (latency > this.maxLatency) break;
                    if (latency > maxLatency) {
                        maxLatency = latency;
                    }
                    if (latency < minLatency) {
                        minLatency = latency;
                    }
                    if (latency > downlink_maxLatency) {
                        downlink_maxLatency = latency;
                    }
                    if (latency < downlink_minLatency) {
                        downlink_minLatency = latency;
                    }
                    ++downlinkMatches;
                    totalLatency += latency;
                    ++matchingDownlinkHashes;
                    if (startidx == indices[i]) {
                        ++downlinksWithMatches;
                        downlinksMask |= 1L << i - 1;
                    }
                    int n4 = i;
                    indices[n4] = indices[n4] + 1;
                }
                if (this.downlinkLatencyMax) {
                    if (Long.MIN_VALUE == downlink_maxLatency) {
                        GTSHelper.setValue((GeoTimeSerie)downlinkLatencyMaxGTS.get(i - 1), uplinkTimestamp, -1L);
                    } else {
                        GTSHelper.setValue((GeoTimeSerie)downlinkLatencyMaxGTS.get(i - 1), uplinkTimestamp, downlink_maxLatency);
                    }
                }
                if (this.downlinkLatencyMin) {
                    if (Long.MAX_VALUE == downlink_minLatency) {
                        GTSHelper.setValue((GeoTimeSerie)downlinkLatencyMinGTS.get(i - 1), uplinkTimestamp, -1L);
                    } else {
                        GTSHelper.setValue((GeoTimeSerie)downlinkLatencyMinGTS.get(i - 1), uplinkTimestamp, downlink_minLatency);
                    }
                }
                if (!this.downlinkMatches) continue;
                GTSHelper.setValue((GeoTimeSerie)downlinkMatchesGTS.get(i - 1), uplinkTimestamp, downlinkMatches);
            }
            if (this.downlinksBitset) {
                GTSHelper.setValue(downlinksBitsetGTS, uplinkTimestamp, downlinksMask);
            }
            if (this.downlinksTotalMatches) {
                GTSHelper.setValue(downlinksTotalMatchesGTS, uplinkTimestamp, matchingDownlinkHashes);
            }
            if (this.downlinksWithMatches) {
                GTSHelper.setValue(downlinksWithMatchesGTS, uplinkTimestamp, downlinksWithMatches);
            }
            if (this.uplinkLatencyMin) {
                if (Long.MAX_VALUE == minLatency) {
                    GTSHelper.setValue(uplinkLatencyMinGTS, uplinkTimestamp, -1L);
                } else {
                    GTSHelper.setValue(uplinkLatencyMinGTS, uplinkTimestamp, minLatency);
                }
            }
            if (this.uplinkLatencyMax) {
                if (Long.MIN_VALUE == maxLatency) {
                    GTSHelper.setValue(uplinkLatencyMax, uplinkTimestamp, -1L);
                } else {
                    GTSHelper.setValue(uplinkLatencyMax, uplinkTimestamp, maxLatency);
                }
            }
            indices[0] = indices[0] + 1;
        }
        return result;
    }

    public List<GeoTimeSerie> filterOLD(Map<String, String> labels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> allseries = new ArrayList<GeoTimeSerie>();
        for (List<GeoTimeSerie> lserie : series) {
            allseries.addAll(lserie);
        }
        for (GeoTimeSerie gts : allseries) {
            GTSHelper.sort(gts, false);
        }
        int[] indices = new int[allseries.size()];
        int n = ((GeoTimeSerie)allseries.get(0)).size();
        GeoTimeSerie inGTS = (GeoTimeSerie)allseries.get(0);
        ArrayList<GeoTimeSerie> outGTS = new ArrayList<GeoTimeSerie>();
        for (int i = 0; i < n; ++i) {
            outGTS.add(((GeoTimeSerie)allseries.get(i)).cloneEmpty());
        }
        long[][] sortedHashes = new long[allseries.size()][];
        for (int i = 1; i < allseries.size(); ++i) {
            sortedHashes[i] = GTSHelper.longValues((GeoTimeSerie)allseries.get(i));
            Arrays.sort(sortedHashes[i]);
        }
        long maxlatency = 1000L;
        while (indices[0] < n) {
            long ints = GTSHelper.tickAtIndex(inGTS, indices[0]);
            long maxoutts = ints + this.maxLatency;
            long payloadHash = GTSHelper.tickAtIndex(inGTS, indices[0]);
            long minlatency = Long.MAX_VALUE;
            for (int i = 1; i < allseries.size(); ++i) {
                long outts;
                int k;
                GeoTimeSerie gts = (GeoTimeSerie)allseries.get(i);
                if (payloadHash != ((Number)GTSHelper.valueAtIndex(gts, indices[i])).longValue() && -1 == Arrays.binarySearch(sortedHashes[i], payloadHash)) continue;
                int nn = GTSHelper.nvalues(gts);
                for (k = indices[i]; k < nn && payloadHash != ((Number)GTSHelper.valueAtIndex(gts, k)).longValue() && GTSHelper.tickAtIndex(gts, k) <= maxoutts; ++k) {
                }
                if (k >= nn || (outts = GTSHelper.tickAtIndex(gts, k)) > maxoutts) continue;
                if (k == indices[i]) {
                    int n2 = i;
                    indices[n2] = indices[n2] + 1;
                }
                long latency = outts - ints;
                GTSHelper.setValue((GeoTimeSerie)outGTS.get(i), outts, latency);
                if (latency >= minlatency) continue;
                minlatency = latency;
            }
            if (Long.MAX_VALUE == minlatency) {
                GTSHelper.setValue((GeoTimeSerie)outGTS.get(0), ints, -1L);
            } else {
                GTSHelper.setValue((GeoTimeSerie)outGTS.get(0), ints, minlatency);
            }
            indices[0] = indices[0] + 1;
        }
        return outGTS;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.minLatency);
        sb.append(" ");
        sb.append(this.maxLatency);
        sb.append(" ");
        sb.append("[");
        sb.append(" ");
        for (String option : this.options) {
            sb.append(StackUtils.toString(option));
            sb.append(" ");
        }
        sb.append("]");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static final class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object o = stack.pop();
            if (!(o instanceof List)) {
                throw new WarpScriptException(this.getName() + " expects a list of options on top of the stack.");
            }
            List options = (List)o;
            o = stack.pop();
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a maximum latency under the list of options.");
            }
            long maxLatency = (Long)o;
            o = stack.pop();
            if (!(o instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a minimum latency under the list of options.");
            }
            long minLatency = (Long)o;
            stack.push(new LatencyFilter(this.getName(), minLatency, maxLatency, options));
            return stack;
        }
    }
}

