/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.formatted;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.formatted.ArgumentSpecification;
import io.warp10.script.formatted.ListSpecification;
import io.warp10.script.formatted.MapSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class FormattedWarpScriptFunction
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final StringBuilder docstring = new StringBuilder();
    private final List<String> unitTests = new ArrayList<String>();

    public FormattedWarpScriptFunction(String name) {
        super(name);
    }

    protected abstract Arguments getArguments();

    protected abstract WarpScriptStack apply(Map<String, Object> var1, WarpScriptStack var2) throws WarpScriptException;

    protected final StringBuilder getDocstring() {
        return this.docstring;
    }

    protected List<String> getUnitTests() {
        return this.unitTests;
    }

    @Override
    public final Object apply(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, Object> formattedArgs;
        List args = this.getArguments().args;
        List optArgs = this.getArguments().optArgs;
        if (null == args) {
            throw new WarpScriptException(this.getClass().getSimpleName() + "'s method getArguments() returned null. If no argument is expected, it should return an empty array instead.");
        }
        if (null == optArgs) {
            throw new WarpScriptException(this.getClass().getSimpleName() + "'s method getOptionalArguments() returned null. If no argument is expected, it should return an empty array instead.");
        }
        for (Object arg : args) {
            if (!((ArgumentSpecification)arg).isOptional()) continue;
            throw new WarpScriptException("Output of " + this.getClass().getSimpleName() + "'s method getArguments() must only contain arguments without a default value.");
        }
        for (Object arg : optArgs) {
            if (((ArgumentSpecification)arg).isOptional()) continue;
            throw new WarpScriptException("Output of " + this.getClass().getSimpleName() + "'s method getArguments() must only contain arguments with a default value.");
        }
        if (this.getArguments().isListExpandable() && ((ListSpecification)args.get(0)).getSubClazz() == List.class) {
            throw new WarpScriptException(this.getClass().getSimpleName() + " implementation error: a list argument can not be list-expandable.");
        }
        if (this.getArguments().isListExpandable() && args.size() == 0) {
            throw new WarpScriptException(this.getClass().getSimpleName() + " implementation error: a function with 0 argument can not be list-expandable.");
        }
        if (0 == args.size() && 0 == optArgs.size()) {
            return this.apply(new HashMap<String, Object>(), stack);
        }
        if (!(0 != args.size() || 0 != stack.depth() && stack.peek() instanceof Map)) {
            throw new WarpScriptException(this.getClass().getSimpleName() + " expects a MAP on top of the stack. To use default argument values, an empty MAP is expected.");
        }
        if (args.size() > 0 && Map.class.isAssignableFrom(((ArgumentSpecification)args.get(0)).getClazz())) {
            throw new WarpScriptException("The function " + this.getName() + " is a formatted WarpScript function. As such, it cannot expect a Map as its first mandatory argument or that could be confused for when using optional arguments. Its implementation must be modified.");
        }
        if (stack.peek() instanceof Map) {
            for (Object o : ((Map)stack.peek()).keySet()) {
                if (o instanceof String) continue;
                throw new WarpScriptException(this.getName() + "'s MAP of parameters contains a key that is not a STRING.");
            }
            formattedArgs = (HashMap<String, Object>)((HashMap)stack.peek()).clone();
            for (String key : formattedArgs.keySet()) {
                boolean found = false;
                for (ArgumentSpecification arg : args) {
                    if (!arg.getName().equals(key)) continue;
                    found = true;
                    break;
                }
                if (found) break;
                for (ArgumentSpecification arg : optArgs) {
                    if (!arg.getName().equals(key)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new WarpScriptException("Argument '" + key + "' is not recognized by " + this.getName());
            }
            for (Object arg : args) {
                Object value = formattedArgs.get(((ArgumentSpecification)arg).getName());
                if (null == value) {
                    throw new WarpScriptException("The MAP that is on top of the stack does not have the argument '" + ((ArgumentSpecification)arg).getName() + "' (of type " + ((ArgumentSpecification)arg).WarpScriptType() + ") that is required by " + this.getName());
                }
                if (this.getArguments().isListExpandable() && arg == args.get(0) && !List.class.isInstance(value)) {
                    Object v = value;
                    value = new ArrayList();
                    ((ArrayList)value).add(v);
                    Iterator firstArg = (ListSpecification)arg;
                    if (!((ListSpecification)((Object)firstArg)).getSubClazz().isInstance(v)) {
                        throw new WarpScriptException(this.getClass().getSimpleName() + " expects the argument '" + ((ArgumentSpecification)((Object)firstArg)).getName() + "' to be a " + ((ListSpecification)((Object)firstArg)).WarpScriptSubType() + " or a list of " + ((ListSpecification)((Object)firstArg)).WarpScriptSubType() + ".");
                    }
                    formattedArgs.put(((ArgumentSpecification)arg).getName(), value);
                }
                if (((ArgumentSpecification)arg).getClazz().isInstance(value)) continue;
                throw new WarpScriptException(this.getClass().getSimpleName() + " expects the argument '" + ((ArgumentSpecification)arg).getName() + "' to be a " + ((ArgumentSpecification)arg).WarpScriptType() + ".");
            }
            for (Object arg : optArgs) {
                Object value = formattedArgs.get(((ArgumentSpecification)arg).getName());
                if (null == value || ((ArgumentSpecification)arg).getClazz().isInstance(value)) continue;
                throw new WarpScriptException(this.getClass().getSimpleName() + " expects the argument '" + ((ArgumentSpecification)arg).getName() + "' to be a " + ((ArgumentSpecification)arg).WarpScriptType() + ".");
            }
            ArrayList both = new ArrayList();
            both.addAll(args);
            both.addAll(optArgs);
            for (ArgumentSpecification arg : both) {
                Object v = formattedArgs.get(arg.getName());
                if (null == v) continue;
                if (arg instanceof ListSpecification) {
                    for (Object elt : (List)v) {
                        if (((ListSpecification)arg).getSubClazz().isInstance(elt)) continue;
                        throw new WarpScriptException(this.getClass().getSimpleName() + " expects the argument '" + arg.getName() + "' to be a LIST of " + ((ListSpecification)arg).getSubClazz().getSimpleName() + ".");
                    }
                }
                if (!(arg instanceof MapSpecification)) continue;
                for (Object key : ((Map)v).keySet()) {
                    if (!((MapSpecification)arg).getClassOfKey().isInstance(key)) {
                        throw new WarpScriptException(this.getClass().getSimpleName() + " expects the argument '" + arg.getName() + "' to be a MAP with keys of type " + ((MapSpecification)arg).getClassOfKey().getSimpleName() + ".");
                    }
                    Object value = ((Map)v).get(key);
                    if (((MapSpecification)arg).getClassOfValue().isInstance(value)) continue;
                    throw new WarpScriptException(this.getClass().getSimpleName() + " expects the argument '" + arg.getName() + "' to be a MAP with values of type " + ((MapSpecification)arg).getClassOfValue().getSimpleName() + ".");
                }
            }
            stack.pop();
        } else {
            int i;
            Object first;
            Object arg;
            if (stack.depth() < args.size()) {
                throw new WarpScriptException(this.getClass().getSimpleName() + " expects to find " + args.size() + " arguments off the top of the stack, but the stack contains only " + stack.depth() + " levels.");
            }
            if (this.getArguments().isListExpandable() && !List.class.isInstance(first = stack.get(args.size() - 1))) {
                stack.push(args.size() - 1);
                Object[] cache = stack.popn();
                ArrayList<Object> arr = new ArrayList<Object>();
                arr.add(stack.pop());
                stack.push(arr);
                for (Object o : cache) {
                    stack.push(o);
                }
                ListSpecification listSpecification = (ListSpecification)args.get(0);
                if (!listSpecification.getSubClazz().isInstance(first)) {
                    System.out.println(first);
                    System.out.println(listSpecification.getSubClazz());
                    throw new WarpScriptException(this.getClass().getSimpleName() + " expects the first argument to be a " + listSpecification.WarpScriptSubType() + " or a list of " + listSpecification.WarpScriptSubType() + ".");
                }
            }
            for (i = 0; i < args.size(); ++i) {
                arg = (ArgumentSpecification)args.get(args.size() - 1 - i);
                Object candidate = stack.get(i);
                if (!((ArgumentSpecification)arg).getClazz().isInstance(candidate)) {
                    throw new WarpScriptException(this.getClass().getSimpleName() + " expects to find a '" + ((ArgumentSpecification)arg).getName() + "' (a " + ((ArgumentSpecification)arg).WarpScriptType() + ") " + this.leveldenomination(i));
                }
                if (arg instanceof ListSpecification) {
                    for (Object elt : (List)candidate) {
                        if (((ListSpecification)arg).getSubClazz().isInstance(elt)) continue;
                        throw new WarpScriptException(this.getClass().getSimpleName() + " expects to find a '" + ((ArgumentSpecification)arg).getName() + "' (a LIST of " + ((ListSpecification)arg).getSubClazz().getSimpleName() + ") " + this.leveldenomination(i));
                    }
                }
                if (!(arg instanceof MapSpecification)) continue;
                for (Object key : ((Map)candidate).keySet()) {
                    if (!((MapSpecification)arg).getClassOfKey().isInstance(key)) {
                        throw new WarpScriptException(this.getClass().getSimpleName() + " expects to find a '" + ((ArgumentSpecification)arg).getName() + "' (a MAP with keys of type " + ((MapSpecification)arg).getClassOfKey().getSimpleName() + ") " + this.leveldenomination(i));
                    }
                    Object value = ((Map)candidate).get(key);
                    if (((MapSpecification)arg).getClassOfValue().isInstance(value)) continue;
                    throw new WarpScriptException(this.getClass().getSimpleName() + " expects to find a '" + ((ArgumentSpecification)arg).getName() + "' (a MAP with values of type " + ((MapSpecification)arg).getClassOfValue().getSimpleName() + ") " + this.leveldenomination(i));
                }
            }
            formattedArgs = new HashMap<String, Object>();
            for (i = 0; i < args.size(); ++i) {
                arg = (ArgumentSpecification)args.get(args.size() - 1 - i);
                formattedArgs.put(((ArgumentSpecification)arg).getName(), stack.pop());
            }
        }
        for (Object arg : optArgs) {
            if (null != formattedArgs.get(((ArgumentSpecification)arg).getName())) continue;
            formattedArgs.put(((ArgumentSpecification)arg).getName(), ((ArgumentSpecification)arg).getDefaultValue());
        }
        if (this.getArguments().isListExpandable()) {
            List firstArg = (List)formattedArgs.get(((ArgumentSpecification)args.get(0)).getName());
            if (firstArg.size() > 1) {
                int initial_depth = stack.depth();
                for (Object e : firstArg) {
                    Map subFormattedArgs = (Map)formattedArgs.clone();
                    subFormattedArgs.put(((ArgumentSpecification)args.get(0)).getName(), e);
                    stack = this.apply(subFormattedArgs, stack);
                }
                stack.push(stack.depth() - initial_depth);
                Object[] elements = stack.popn();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.addAll(Arrays.asList(elements));
                stack.push(arrayList);
                return stack;
            }
            if (1 == firstArg.size()) {
                formattedArgs.put(((ArgumentSpecification)args.get(0)).getName(), firstArg.get(0));
                return this.apply(formattedArgs, stack);
            }
            stack.push(new ArrayList());
            return stack;
        }
        return this.apply(formattedArgs, stack);
    }

    private final String leveldenomination(int i) {
        if (i < 0) {
            throw new IllegalStateException("Can not be negative");
        }
        if (0 == i) {
            return "on top of the stack.";
        }
        if (1 == i) {
            return "below the top of the stack.";
        }
        if (2 == i) {
            return "on stack level 3.";
        }
        return "on stack level " + (i + 1) + ".";
    }

    public static class ArgumentsBuilder {
        private final List<ArgumentSpecification> args = new ArrayList<ArgumentSpecification>();
        private final List<ArgumentSpecification> optArgs = new ArrayList<ArgumentSpecification>();
        private boolean listExpandable = false;

        public ArgumentsBuilder addArgument(Class<?> clazz, String name, String doc) {
            this.args.add(new ArgumentSpecification(clazz, name, doc));
            return this;
        }

        public ArgumentsBuilder addListArgument(Class<?> subClazz, String name, String doc) {
            this.args.add(new ListSpecification(subClazz, name, doc));
            return this;
        }

        public ArgumentsBuilder addMapArgument(Class<?> keyClass, Class<?> valueClass, String name, String doc) {
            this.args.add(new MapSpecification(keyClass, valueClass, name, doc));
            return this;
        }

        public ArgumentsBuilder addOptionalArgument(Class<?> clazz, String name, String doc, Object defaultValue) {
            this.optArgs.add(new ArgumentSpecification(clazz, name, defaultValue, doc));
            return this;
        }

        public ArgumentsBuilder addOptionalListArgument(Class<?> subClazz, String name, String doc, Object defaultValue) {
            this.optArgs.add(new ListSpecification(subClazz, name, defaultValue, doc));
            return this;
        }

        public ArgumentsBuilder addOptionalMapArgument(Class<?> keyClass, Class<?> valueClass, String name, String doc, Object defaultValue) {
            this.args.add(new MapSpecification(keyClass, valueClass, name, defaultValue, doc));
            return this;
        }

        public ArgumentsBuilder addArgument(ArgumentSpecification spec) {
            this.args.add(spec);
            return this;
        }

        public ArgumentsBuilder addOptionalArgument(ArgumentSpecification spec) {
            if (!spec.isOptional()) {
                throw new IllegalStateException("Argument is added as an optional argument to the function but that is not coherent with its specification.");
            }
            this.optArgs.add(spec);
            return this;
        }

        public ArgumentsBuilder firstArgIsListExpandable() {
            this.listExpandable = true;
            ArgumentSpecification firstArgs = this.args.remove(0);
            this.args.add(0, new ListSpecification(firstArgs.getClazz(), firstArgs.getName(), firstArgs.getDoc()));
            return this;
        }

        public Arguments build() {
            return new Arguments(this.args, this.optArgs, this.listExpandable);
        }
    }

    public static class Arguments {
        private final List<ArgumentSpecification> args;
        private final List<ArgumentSpecification> optArgs;
        private final boolean listExpandable;

        private Arguments(List<ArgumentSpecification> args, List<ArgumentSpecification> optArgs, boolean listExpandable) {
            this.args = args;
            this.optArgs = optArgs;
            this.listExpandable = listExpandable;
        }

        public List<ArgumentSpecification> getArgsCopy() {
            return new ArrayList<ArgumentSpecification>(this.args);
        }

        public List<ArgumentSpecification> getOptArgsCopy() {
            return new ArrayList<ArgumentSpecification>(this.optArgs);
        }

        public boolean isListExpandable() {
            return this.listExpandable;
        }
    }
}

