/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.CSTORE;
import io.warp10.script.functions.ENDLIST;
import io.warp10.script.functions.LOAD;
import io.warp10.script.functions.MARK;
import io.warp10.script.functions.NOOP;
import io.warp10.script.functions.NULL;
import io.warp10.script.functions.POPR;
import io.warp10.script.functions.PUSHR;
import io.warp10.script.functions.STORE;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ASREGS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final NOOP NOOP = new NOOP("NOOP");

    public ASREGS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of variable names on top of the stack.");
        }
        List vars = (List)top;
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a macro.");
        }
        Object[] regs = stack.getRegisters();
        int nregs = regs.length;
        BitSet inuse = new BitSet(nregs);
        ArrayList<WarpScriptStack.Macro> allmacros = new ArrayList<WarpScriptStack.Macro>();
        allmacros.add((WarpScriptStack.Macro)top);
        boolean abort = false;
        block0: while (!abort && !allmacros.isEmpty()) {
            WarpScriptStack.Macro m = (WarpScriptStack.Macro)allmacros.remove(0);
            ArrayList<Object> statements = new ArrayList<Object>(m.statements());
            block1: for (int i = 0; i < statements.size(); ++i) {
                Iterator symbol;
                if (statements.get(i) instanceof PUSHR) {
                    inuse.set(((PUSHR)statements.get(i)).getRegister());
                    continue;
                }
                if (statements.get(i) instanceof POPR) {
                    inuse.set(((POPR)statements.get(i)).getRegister());
                    continue;
                }
                if (statements.get(i) instanceof LOAD || statements.get(i) instanceof CSTORE) {
                    if (0 == i) {
                        abort = true;
                        continue block0;
                    }
                    symbol = statements.get(i - 1);
                    if (symbol instanceof Long) {
                        inuse.set(((Long)((Object)symbol)).intValue());
                        continue;
                    }
                    if (symbol instanceof String) continue;
                    abort = true;
                    continue;
                }
                if (statements.get(i) instanceof STORE) {
                    if (0 == i) {
                        abort = true;
                        continue block0;
                    }
                    symbol = statements.get(i - 1);
                    if (symbol instanceof Long) {
                        inuse.set(((Long)((Object)symbol)).intValue());
                        continue;
                    }
                    if (symbol instanceof List) {
                        for (Object elt : (List)((Object)symbol)) {
                            if (!(elt instanceof Long)) continue;
                            inuse.set(((Long)elt).intValue());
                        }
                        continue;
                    }
                    if (symbol instanceof ENDLIST) {
                        int idx = i - 2;
                        while (idx >= 0 && !(statements.get(idx) instanceof MARK)) {
                            Object stmt;
                            if ((stmt = statements.get(idx--)) instanceof Long) {
                                inuse.set(((Long)stmt).intValue());
                                continue;
                            }
                            if (null == stmt || stmt instanceof String || stmt instanceof NULL) continue;
                            abort = true;
                            continue block1;
                        }
                        continue;
                    }
                    if (symbol instanceof String) continue;
                    abort = true;
                    continue;
                }
                if (!(statements.get(i) instanceof WarpScriptStack.Macro)) continue;
                allmacros.add((WarpScriptStack.Macro)statements.get(i));
            }
        }
        if (abort) {
            throw new WarpScriptException(this.getName() + " was unable to convert variables to registers.");
        }
        HashMap<String, Integer> varregs = new HashMap<String, Integer>();
        int regidx = 0;
        int numregs = 0;
        for (Object v : vars) {
            if (v instanceof Long) continue;
            if (inuse.cardinality() == nregs) break;
            if (!(v instanceof String)) {
                throw new WarpScriptException(this.getName() + " expects a list of variable names on top of the stack.");
            }
            if (null != varregs.get(v.toString())) continue;
            regidx = inuse.nextClearBit(0);
            inuse.set(regidx);
            varregs.put(v.toString(), regidx);
        }
        numregs = regidx + 1;
        WarpScriptStackFunction[] regfuncs = new WarpScriptStackFunction[numregs * 3];
        for (int i = 0; i < numregs; ++i) {
            regfuncs[i] = new PUSHR("PUSHR" + i, i);
            regfuncs[numregs + i] = new POPR("POPR" + i, i);
            regfuncs[numregs + numregs + i] = new POPR("POPR" + i, i, true);
        }
        allmacros.clear();
        allmacros.add((WarpScriptStack.Macro)top);
        while (!abort && !allmacros.isEmpty()) {
            WarpScriptStack.Macro m = (WarpScriptStack.Macro)allmacros.remove(0);
            ArrayList<Object> statements = new ArrayList<Object>(m.statements());
            for (int i = 0; i < statements.size(); ++i) {
                Integer regno;
                Object symbol;
                if (statements.get(i) instanceof WarpScriptStack.Macro) {
                    allmacros.add((WarpScriptStack.Macro)statements.get(i));
                    continue;
                }
                if (i > 0 && statements.get(i) instanceof LOAD) {
                    symbol = statements.get(i - 1);
                    if (symbol instanceof String) {
                        regno = (Integer)varregs.get(symbol.toString());
                        if (null == regno) continue;
                        statements.set(i - 1, NOOP);
                        statements.set(i, regfuncs[regno]);
                        continue;
                    }
                    if (symbol instanceof Long) continue;
                    abort = true;
                    break;
                }
                if (i > 0 && statements.get(i) instanceof STORE) {
                    symbol = statements.get(i - 1);
                    if (symbol instanceof String) {
                        regno = (Integer)varregs.get(symbol.toString());
                        if (null == regno) continue;
                        statements.set(i - 1, NOOP);
                        statements.set(i, regfuncs[regno + numregs]);
                        continue;
                    }
                    if (symbol instanceof List) {
                        for (int k = 0; k < ((List)symbol).size(); ++k) {
                            Integer regno2;
                            if (!(((List)symbol).get(k) instanceof String) || null == (regno2 = (Integer)varregs.get(((List)symbol).get(k).toString()))) continue;
                            ((List)symbol).set(k, Long.valueOf(regno2.intValue()));
                        }
                        continue;
                    }
                    if (symbol instanceof ENDLIST) {
                        for (int idx = i - 2; idx >= 0 && !(statements.get(idx) instanceof MARK); --idx) {
                            Integer regno3;
                            Object stmt = statements.get(idx);
                            if (!(stmt instanceof String) || null == (regno3 = (Integer)varregs.get(statements.get(idx)))) continue;
                            statements.set(idx, regno3);
                        }
                        continue;
                    }
                    if (symbol instanceof Long) continue;
                    abort = true;
                    break;
                }
                if (i <= 0 || !(statements.get(i) instanceof CSTORE)) continue;
                symbol = statements.get(i - 1);
                if (symbol instanceof String) {
                    regno = (Integer)varregs.get(symbol.toString());
                    if (null == regno) continue;
                    statements.set(i - 1, NOOP);
                    statements.set(i, regfuncs[regno + numregs + numregs]);
                    continue;
                }
                if (symbol instanceof Long) continue;
                abort = true;
                break;
            }
            if (abort) continue;
            List<Object> macstmt = m.statements();
            int noops = 0;
            for (int i = 0; i < statements.size(); ++i) {
                if (statements.get(i) instanceof NOOP) {
                    ++noops;
                    continue;
                }
                macstmt.set(i - noops, statements.get(i));
            }
            m.setSize(statements.size() - noops);
        }
        if (abort) {
            throw new WarpScriptException(this.getName() + " was unable to convert variables to registers.");
        }
        stack.push(top);
        return stack;
    }
}

