/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptBucketizerFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;

public class BUCKETIZE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public BUCKETIZE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list as input.");
        }
        List params = (List)top;
        if (5 > params.size()) {
            throw new WarpScriptException(this.getName() + " needs a list of at least 5 parameters as input.");
        }
        for (int i = 0; i < params.size() - 4; ++i) {
            if (params.get(i) instanceof GeoTimeSerie || params.get(i) instanceof List) continue;
            throw new WarpScriptException(this.getName() + " expects a list of Geo Time Series as first parameter.");
        }
        if (!(params.get(params.size() - 4) instanceof WarpScriptBucketizerFunction) && !(params.get(params.size() - 4) instanceof WarpScriptStack.Macro) && null != params.get(params.size() - 4)) {
            throw new WarpScriptException(this.getName() + " expects a bucketizer function, a macro, or NULL as fourth to last parameter.");
        }
        if (!(params.get(params.size() - 3) instanceof Long && params.get(params.size() - 2) instanceof Long && params.get(params.size() - 1) instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects lastbucket, bucketspan and bucketcount as last 3 parameters.");
        }
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        for (int i = 0; i < params.size() - 4; ++i) {
            if (params.get(i) instanceof GeoTimeSerie) {
                series.add((GeoTimeSerie)params.get(i));
                continue;
            }
            if (!(params.get(i) instanceof List)) continue;
            for (Object o : (List)params.get(i)) {
                if (!(o instanceof GeoTimeSerie)) {
                    throw new WarpScriptException(this.getName() + " expects a list of Geo Time Series as first parameter.");
                }
                series.add((GeoTimeSerie)o);
            }
        }
        Object bucketizer = params.get(params.size() - 4);
        long lastbucket = (Long)params.get(params.size() - 3);
        long bucketspan = (Long)params.get(params.size() - 2);
        int bucketcount = (int)((Long)params.get(params.size() - 1)).longValue();
        ArrayList<GeoTimeSerie> bucketized = new ArrayList<GeoTimeSerie>();
        long maxbuckets = (Long)stack.getAttribute("stack.maxbuckets");
        for (GeoTimeSerie gts : series) {
            GeoTimeSerie b = GTSHelper.bucketize(gts, bucketspan, bucketcount, lastbucket, bucketizer, maxbuckets, bucketizer instanceof WarpScriptStack.Macro ? stack : null);
            bucketized.add(b);
        }
        stack.push(bucketized);
        return stack;
    }
}

