/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CLIP
extends ElementOrListStackFunction {
    public CLIP(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of limit pairs on top of the stack.");
        }
        final List limits = (List)top;
        for (Object o : limits) {
            long upper;
            if (!(o instanceof List)) {
                throw new WarpScriptException(this.getName() + " expects a list of limit pairs on top of the stack.");
            }
            List pair = (List)o;
            if (2 != pair.size()) {
                throw new WarpScriptException(this.getName() + " expects a list of limit pairs on top of the stack.");
            }
            if (!(pair.get(0) instanceof Number) || !(pair.get(1) instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects the limits to be numeric.");
            }
            long lower = ((Number)pair.get(0)).longValue();
            if (lower <= (upper = ((Number)pair.get(1)).longValue())) continue;
            Collections.swap(pair, 0, 1);
        }
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                ArrayList<Cloneable> clipped = new ArrayList<Cloneable>();
                if (element instanceof GeoTimeSerie) {
                    for (Object o : limits) {
                        List pair = (List)o;
                        long lower = ((Number)pair.get(0)).longValue();
                        long upper = ((Number)pair.get(1)).longValue();
                        clipped.add(GTSHelper.timeclip((GeoTimeSerie)element, lower, upper));
                    }
                } else if (element instanceof GTSEncoder) {
                    for (Object o : limits) {
                        List pair = (List)o;
                        long lower = ((Number)pair.get(0)).longValue();
                        long upper = ((Number)pair.get(1)).longValue();
                        clipped.add(GTSHelper.timeclip((GTSEncoder)element, lower, upper));
                    }
                } else {
                    throw new WarpScriptException(CLIP.this.getName() + " expects a GeoTimeSeries, a GTSEncoder or a list thereof under the list of limit.");
                }
                return clipped;
            }
        };
    }
}

