/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpConfig;
import io.warp10.WarpURLEncoder;
import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class DELETE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private URL url = null;

    public DELETE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a count on top of the stack.");
        }
        long expected = (Long)o;
        o = stack.pop();
        if (!(o instanceof Long) && !(o instanceof String) && null != o) {
            throw new WarpScriptException(this.getName() + " expects the end timestamp to be a Long, a String or NULL.");
        }
        Object end = o;
        o = stack.pop();
        if (!(o instanceof Long) && !(o instanceof String) && null != o) {
            throw new WarpScriptException(this.getName() + " expects the start timestamp to be a Long, a String or NULL.");
        }
        Object start = o;
        if (null == start && null != end || null != start && null == end) {
            throw new WarpScriptException(this.getName() + " expects both start and end timestamps MUST be NULL if one of them is.");
        }
        o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a Geo Time Series selector below the time parameters.");
        }
        String selector = o.toString();
        o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a token below the selector.");
        }
        String token = (String)o;
        HttpURLConnection conn = null;
        try {
            Object line;
            if (null == this.url) {
                String url_property = WarpConfig.getProperty("warpscript.delete.endpoint");
                if (null != url_property) {
                    try {
                        this.url = new URL(url_property);
                    }
                    catch (MalformedURLException mue) {
                        throw new WarpScriptException(this.getName() + " configuration parameter '" + "warpscript.delete.endpoint" + "' does not define a valid URL.");
                    }
                } else {
                    throw new WarpScriptException(this.getName() + " configuration parameter '" + "warpscript.delete.endpoint" + "' not set.");
                }
            }
            StringBuilder qsurl = new StringBuilder(this.url.toString());
            if (null == this.url.getQuery()) {
                qsurl.append("?");
            } else {
                qsurl.append("&");
            }
            if (null != start && null != end) {
                qsurl.append("end");
                qsurl.append("=");
                qsurl.append(end);
                qsurl.append("&");
                qsurl.append("start");
                qsurl.append("=");
                qsurl.append(start);
            } else {
                qsurl.append("deleteall");
                qsurl.append("=");
                qsurl.append("true");
            }
            qsurl.append("&");
            qsurl.append("selector");
            qsurl.append("=");
            qsurl.append(WarpURLEncoder.encode(selector, StandardCharsets.UTF_8));
            boolean nocache = Boolean.TRUE.equals(stack.getAttribute("accel.nocache"));
            boolean nopersist = Boolean.TRUE.equals(stack.getAttribute("accel.nopersist"));
            if (nocache) {
                qsurl.append("&");
                qsurl.append("nocache");
            }
            if (nopersist) {
                qsurl.append("&");
                qsurl.append("nopersist");
            }
            URL requrl = new URL(qsurl.toString() + "&" + "dryrun" + "=true");
            conn = (HttpURLConnection)requrl.openConnection();
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty(Constants.getHeader("http.header.token.DELETE"), token);
            conn.connect();
            if (200 != conn.getResponseCode()) {
                throw new WarpScriptException(this.getName() + " failed to complete dryrun request successfully (" + conn.getResponseMessage() + ")");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            long actualCount = 0L;
            while (null != (line = br.readLine())) {
                if (expected >= ++actualCount) continue;
                throw new WarpScriptException(this.getName() + " expected at most " + expected + " Geo Time Series to be deleted but " + actualCount + " would have been deleted instead.");
            }
            br.close();
            conn.disconnect();
            conn = null;
            if (0L == actualCount) {
                stack.push(0);
                line = stack;
                return line;
            }
            requrl = new URL(qsurl.toString());
            conn = (HttpURLConnection)requrl.openConnection();
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty(Constants.getHeader("http.header.token.DELETE"), token);
            conn.connect();
            if (200 != conn.getResponseCode()) {
                throw new WarpScriptException(this.getName() + " failed to complete actual request successfully (" + conn.getResponseMessage() + ")");
            }
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            actualCount = 0L;
            while (null != (line = br.readLine())) {
                ++actualCount;
            }
            br.close();
            conn.disconnect();
            conn = null;
            stack.push(actualCount);
        }
        catch (IOException ioe) {
            throw new WarpScriptException(this.getName() + " failed.", ioe);
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return stack;
    }
}

