/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.Tokens;
import io.warp10.continuum.store.DirectoryClient;
import io.warp10.continuum.store.thrift.data.DirectoryRequest;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.LISTTO;
import io.warp10.script.functions.TOLIST;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FINDSTATS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private WarpScriptStackFunction toList = new TOLIST("");
    private WarpScriptStackFunction listTo = new LISTTO("");

    public FINDSTATS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object oLabelsSelector;
        Object top = stack.peek();
        if (top instanceof List) {
            if (3 != ((List)top).size()) {
                stack.drop();
                throw new WarpScriptException(this.getName() + " expects 3 parameters.");
            }
            this.listTo.apply(stack);
            stack.drop();
        }
        if (!((oLabelsSelector = stack.pop()) instanceof Map)) {
            throw new WarpScriptException("Label selectors must be a map.");
        }
        Map labelSelectors = (Map)oLabelsSelector;
        Object oClassSelector = stack.pop();
        if (!(oClassSelector instanceof String)) {
            throw new WarpScriptException("Class selector must be a string.");
        }
        String classSelector = (String)oClassSelector;
        Object oToken = stack.pop();
        if (!(oToken instanceof String)) {
            throw new WarpScriptException("Token must be a string.");
        }
        String token = (String)oToken;
        DirectoryClient directoryClient = stack.getDirectoryClient();
        ReadToken rtoken = Tokens.extractReadToken(token);
        labelSelectors.remove(".producer");
        labelSelectors.remove(".owner");
        labelSelectors.remove(".app");
        labelSelectors.putAll(Tokens.labelSelectorsFromReadToken(rtoken));
        ArrayList<String> clsSels = new ArrayList<String>();
        ArrayList<Map<String, String>> lblsSels = new ArrayList<Map<String, String>>();
        clsSels.add(classSelector);
        lblsSels.add(labelSelectors);
        Map<String, Object> stats = null;
        try {
            DirectoryRequest drequest = new DirectoryRequest();
            drequest.setClassSelectors(clsSels);
            drequest.setLabelsSelectors(lblsSels);
            stats = directoryClient.stats(drequest);
        }
        catch (IOException ioe) {
            throw new WarpScriptException(ioe);
        }
        stack.push(stats);
        return stack;
    }
}

