/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.charset.StandardCharsets;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class GEOUNPACK
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GEOUNPACK(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        byte[] serialized;
        Object o = stack.pop();
        if (o instanceof String) {
            serialized = OrderPreservingBase64.decode(o.toString().getBytes(StandardCharsets.US_ASCII));
        } else if (o instanceof byte[]) {
            serialized = (byte[])o;
        } else {
            throw new WarpScriptException(this.getName() + " expects a packed shape on top of the stack.");
        }
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
        GTSWrapper wrapper = new GTSWrapper();
        try {
            deserializer.deserialize((TBase)wrapper, serialized);
        }
        catch (TException te) {
            throw new WarpScriptException(te);
        }
        GTSDecoder decoder = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(wrapper);
        long[] cells = new long[(int)wrapper.getCount()];
        int idx = 0;
        while (idx < cells.length && decoder.next()) {
            long cell = decoder.getTimestamp();
            Object value = decoder.getValue();
            if (!Boolean.TRUE.equals(value)) {
                throw new WarpScriptException(this.getName() + " invalid GeoXPShape.");
            }
            cells[idx++] = cell;
        }
        if (idx != cells.length) {
            throw new WarpScriptException(this.getName() + " invalid GeoXPShape.");
        }
        GeoXPLib.GeoXPShape shape = GeoXPLib.fromCells((long[])cells, (boolean)false);
        stack.push(shape);
        return stack;
    }
}

