/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.geo.HHCodeHelper;
import com.google.common.primitives.Longs;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class HHCODEFUNC
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final HHCodeAction action;

    public HHCODEFUNC(String name, HHCodeAction action) {
        super(name);
        this.action = action;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long hh;
        Object o = stack.pop();
        if (!(o instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a resolution which is an even long between 0 and 32.");
        }
        int res = ((Number)o).intValue();
        if (res < 0 || res > 32 || 0 != (res & 1)) {
            throw new WarpScriptException(this.getName() + " expects a resolution which is an even long between 0 and 32.");
        }
        Object hhcode = stack.pop();
        if (hhcode instanceof Long) {
            hh = (Long)hhcode;
        } else if (hhcode instanceof String) {
            String hhstr = hhcode.toString();
            if (hhstr.length() > 16) {
                throw new WarpScriptException(this.getName() + " expects an hexadecimal HHCode string of length <= 16");
            }
            if (hhstr.length() < 16) {
                hhcode = (hhstr + "0000000000000000").substring(0, 16);
            }
            hh = Long.parseUnsignedLong(hhcode.toString(), 16);
        } else if (hhcode instanceof byte[]) {
            hh = Longs.fromByteArray((byte[])((byte[])hhcode));
        } else {
            throw new WarpScriptException(this.getName() + " expects a long, a string or a byte array.");
        }
        switch (this.action) {
            case NORTH: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.northHHCode((long)hh, (int)res), res, hhcode));
                break;
            }
            case SOUTH: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.southHHCode((long)hh, (int)res), res, hhcode));
                break;
            }
            case EAST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.eastHHCode((long)hh, (int)res), res, hhcode));
                break;
            }
            case WEST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.westHHCode((long)hh, (int)res), res, hhcode));
                break;
            }
            case NORTH_EAST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.northEastHHCode((long)hh, (int)res), res, hhcode));
                break;
            }
            case NORTH_WEST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.northWestHHCode((long)hh, (int)res), res, hhcode));
                break;
            }
            case SOUTH_EAST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.southEastHHCode((long)hh, (int)res), res, hhcode));
                break;
            }
            case SOUTH_WEST: {
                stack.push(HHCODEFUNC.manageFormat(HHCodeHelper.southWestHHCode((long)hh, (int)res), res, hhcode));
                break;
            }
            case BBOX: {
                double[] bbox = HHCodeHelper.getHHCodeBBox((long)hh, (int)res);
                stack.push(bbox[0]);
                stack.push(bbox[1]);
                stack.push(bbox[2]);
                stack.push(bbox[3]);
                break;
            }
            case CENTER: {
                double[] latlon = HHCodeHelper.getCenterLatLon((long)hh, (int)res);
                stack.push(latlon[0]);
                stack.push(latlon[1]);
                break;
            }
            default: {
                throw new WarpScriptException("Unknown HHCODE action.");
            }
        }
        return stack;
    }

    private static Object manageFormat(long hh, int res, Object input) {
        Object o = input instanceof byte[] ? Longs.toByteArray((long)hh) : (input instanceof String ? (Object)HHCodeHelper.toString((long)hh, (int)res) : (Object)hh);
        return o;
    }

    public static enum HHCodeAction {
        NORTH,
        SOUTH,
        EAST,
        WEST,
        NORTH_EAST,
        NORTH_WEST,
        SOUTH_EAST,
        SOUTH_WEST,
        BBOX,
        CENTER;

    }
}

