/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class KURTOSIS
extends GTSStackFunction {
    private static final String APPLYBESSEL = "applyBessel";

    public KURTOSIS(String name) {
        super(name);
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        int n = GTSHelper.nvalues(gts);
        if (0 == n) {
            throw new WarpScriptException(this.getName() + " can only compute kurtosis for non empty series.");
        }
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType() && GeoTimeSerie.TYPE.LONG != gts.getType()) {
            throw new WarpScriptException(this.getName() + " can only compute kurtosis for numerical series.");
        }
        return GTSHelper.kurtosis(gts, (Boolean)params.get(APPLYBESSEL));
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object o = stack.pop();
        if (!(o instanceof Boolean)) {
            throw new WarpScriptException(this.getName() + " expects a boolean on top of the stack to determine if Bessel's correction should be applied or not.");
        }
        boolean applyBessel = Boolean.TRUE.equals(o);
        params.put(APPLYBESSEL, applyBessel);
        return params;
    }
}

