/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigDecimal;

public class MUSIGMA
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public MUSIGMA(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Boolean)) {
            throw new WarpScriptException(this.getName() + " expects a boolean on top of the stack to determine if Bessel's correction should be applied or not.");
        }
        boolean applyBessel = Boolean.TRUE.equals(o);
        o = stack.pop();
        if (!(o instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " expects a Geo Time Series instance below the top of the stack.");
        }
        GeoTimeSerie gts = (GeoTimeSerie)o;
        int n = GTSHelper.nvalues(gts);
        if (0 == n) {
            throw new WarpScriptException(this.getName() + " can only compute mu and sigma for non empty series.");
        }
        if (GeoTimeSerie.TYPE.DOUBLE != gts.getType() && GeoTimeSerie.TYPE.LONG != gts.getType()) {
            throw new WarpScriptException(this.getName() + " can only compute mu and sigma for numerical series.");
        }
        BigDecimal sum = BigDecimal.valueOf(0.0);
        BigDecimal sumsq = BigDecimal.valueOf(0.0);
        for (int i = 0; i < n; ++i) {
            BigDecimal bd = GeoTimeSerie.TYPE.DOUBLE == gts.getType() ? BigDecimal.valueOf(((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue()) : BigDecimal.valueOf(((Number)GTSHelper.valueAtIndex(gts, i)).longValue());
            sum = sum.add(BigDecimal.valueOf(((Number)GTSHelper.valueAtIndex(gts, i)).doubleValue()));
            sumsq = sumsq.add(bd.multiply(bd));
        }
        stack.push(sum.divide(BigDecimal.valueOf(n), 4).doubleValue());
        BigDecimal bdn = BigDecimal.valueOf(n);
        double variance = sumsq.divide(bdn, 4).subtract(sum.multiply(sum).divide(bdn.multiply(bdn), 4)).doubleValue();
        if (applyBessel && n > 1) {
            variance *= (double)n / ((double)n - 1.0);
        }
        stack.push(Math.sqrt(variance));
        return stack;
    }
}

