/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.TimeSource;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.unary.TOTIMESTAMP;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class NOTBEFORE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private DateTimeFormatter fmt = ISODateTimeFormat.dateTimeParser();

    public NOTBEFORE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long instant;
        Object top = stack.pop();
        if (top instanceof String) {
            instant = TOTIMESTAMP.parseTimestamp(top.toString());
        } else {
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a timestamp or ISO8601 datetime string on top of the stack.");
            }
            instant = ((Number)top).longValue();
        }
        long now = TimeSource.getTime();
        if (now < instant) {
            throw new WarpScriptException("Current time is before '" + top + "'");
        }
        return stack;
    }
}

