/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.DoubleUtils;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.DTW;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.math3.util.Pair;

public class OPTDTW
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final DTW dtw = new DTW("", false, false);

    public OPTDTW(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a count of best results to return on top of the stack.");
        }
        int count = ((Number)o).intValue();
        o = stack.pop();
        if (!(o instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a numeric list to use as query below the count.");
        }
        double[] query = new double[((List)o).size()];
        int i = 0;
        for (Object oo : (List)o) {
            query[i++] = ((Number)oo).doubleValue();
        }
        double[] musigma = DoubleUtils.musigma(query, true);
        for (i = 0; i < query.length; ++i) {
            query[i] = (query[i] - musigma[0]) / musigma[1];
        }
        o = stack.pop();
        if (!(o instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a numeric list as the sequence in which to find best matches below the 'query' list.");
        }
        double[] sequence = new double[((List)o).size()];
        i = 0;
        for (Object oo : (List)o) {
            sequence[i++] = ((Number)oo).doubleValue();
        }
        if (sequence.length <= query.length) {
            throw new WarpScriptException(this.getName() + " expects the query list to be shorter than the sequence list.");
        }
        double mindist = 0.0;
        PriorityQueue<Pair<Integer, Double>> distances = new PriorityQueue<Pair<Integer, Double>>(new Comparator<Pair<Integer, Double>>(){

            @Override
            public int compare(Pair<Integer, Double> o1, Pair<Integer, Double> o2) {
                return ((Double)o1.getValue()).compareTo((Double)o2.getValue());
            }
        });
        double[] subsequence = new double[query.length];
        for (i = 0; i <= sequence.length - query.length; ++i) {
            System.arraycopy(sequence, i, subsequence, 0, query.length);
            musigma = DoubleUtils.musigma(subsequence, true);
            for (int j = 0; j < subsequence.length; ++j) {
                subsequence[j] = (subsequence[j] - musigma[0]) / musigma[1];
            }
            double dist = this.dtw.compute(query, 0, query.length, subsequence, 0, query.length, mindist);
            if (dist < 0.0) continue;
            distances.add((Pair<Integer, Double>)new Pair((Object)i, (Object)dist));
            if (count <= 0 || distances.size() < count) continue;
            Object[] adist = distances.toArray();
            mindist = (Double)((Pair)adist[count - 1]).getValue();
        }
        ArrayList results = new ArrayList();
        while (!distances.isEmpty()) {
            Pair<Integer, Double> entry = distances.poll();
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(entry.getKey());
            result.add(entry.getValue());
            results.add(result);
            if (count <= 0 || count != results.size()) continue;
            break;
        }
        stack.push(results);
        return stack;
    }
}

