/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class PARSE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public PARSE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a String on top of the stack.");
        }
        GTSEncoder encoder = null;
        GTSEncoder lastencoder = null;
        StringReader reader = new StringReader(top.toString());
        BufferedReader br = new BufferedReader(reader);
        ArrayList<GeoTimeSerie> series = new ArrayList<GeoTimeSerie>();
        try {
            String line;
            AtomicBoolean hadAttributes = new AtomicBoolean(false);
            while (null != (line = br.readLine())) {
                if (0 == (line = line.trim()).length() || '#' == line.charAt(0)) continue;
                encoder = GTSHelper.parse(lastencoder, line, null, null, Long.MAX_VALUE, hadAttributes);
                if (null != lastencoder && lastencoder != encoder) {
                    series.add(lastencoder.getDecoder(true).decode());
                    lastencoder = encoder;
                    continue;
                }
                lastencoder = encoder;
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new WarpScriptException(ioe);
        }
        catch (ParseException pe) {
            throw new WarpScriptException(pe);
        }
        if (null != encoder) {
            series.add(encoder.getDecoder(true).decode());
        }
        stack.push(series);
        return stack;
    }
}

