/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.List;

public class QUANTIZE
extends ElementOrListStackFunction {
    public QUANTIZE(String name) {
        super(name);
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of target values on top of the stack.");
        }
        List rankToValue = (List)top;
        top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list of bounds under the top of the stack.");
        }
        final double[] bounds = new double[((List)top).size()];
        if (!rankToValue.isEmpty() && rankToValue.size() != bounds.length + 1) {
            throw new WarpScriptException(this.getName() + " expected " + (bounds.length + 1) + " values but got " + rankToValue.size());
        }
        for (int i = 0; i < bounds.length; ++i) {
            bounds[i] = ((Number)((List)top).get(i)).doubleValue();
            if (!Double.isFinite(bounds[i])) {
                throw new WarpScriptException(this.getName() + " expects the bounds to be finite.");
            }
            if (i <= 0 || !(bounds[i] <= bounds[i - 1])) continue;
            throw new WarpScriptException(this.getName() + " identified unordered or duplicate bounds.");
        }
        final Object[] rankToValueArray = rankToValue.isEmpty() ? null : rankToValue.toArray();
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                if (element instanceof GeoTimeSerie) {
                    GeoTimeSerie gts = (GeoTimeSerie)element;
                    return GTSHelper.quantize(gts, bounds, rankToValueArray);
                }
                throw new WarpScriptException(QUANTIZE.this.getName() + " expects a Geo Time Series instance or a list thereof.");
            }
        };
    }
}

