/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.GET;
import java.util.ArrayList;
import java.util.List;

public class SET
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SET(String name) {
        super(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object key = stack.pop();
        Object value = stack.pop();
        Object listOrByteArray = stack.peek();
        if (!(listOrByteArray instanceof List) && !(listOrByteArray instanceof byte[])) {
            throw new WarpScriptException(this.getName() + " operates on a list or byte array.");
        }
        if (key instanceof List) {
            Object container;
            for (Object o : (List)key) {
                if (o instanceof Long) continue;
                throw new WarpScriptException(this.getName() + " expects the key to be an integer or a list of integers when operating on a List.");
            }
            ArrayList<Long> copyIndices = new ArrayList<Long>((List)key);
            int lastIdx = ((Long)copyIndices.remove(copyIndices.size() - 1)).intValue();
            try {
                container = GET.nestedGet((List)listOrByteArray, copyIndices);
            }
            catch (WarpScriptException wse) {
                throw new WarpScriptException(this.getName() + " tried to set an element at a nested path that does not exist in the input list.");
            }
            if (!(container instanceof List)) throw new WarpScriptException(this.getName() + " tried to set an element at a nested path that does not exist in the input list.");
            ((List)container).set(lastIdx, value);
            return stack;
        }
        if (!(key instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a key which is an LONG or a list of LONG.");
        }
        if (listOrByteArray instanceof List) {
            int idx = GET.computeAndCheckIndex(((Long)key).intValue(), ((List)listOrByteArray).size());
            ((List)listOrByteArray).set(idx, value);
            return stack;
        } else {
            byte[] data = (byte[])listOrByteArray;
            if (!(value instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects the element to be a LONG in either [0,255] or [-128,127], when operating on a byte array.");
            }
            long l = (Long)value;
            if (l < -128L || l > 255L) {
                throw new WarpScriptException(this.getName() + " expects the element to be a LONG in either [0,255] or [-128,127], when operating on a byte array.");
            }
            byte elt = (byte)(l & 0xFFL);
            int idx = GET.computeAndCheckIndex(((Long)key).intValue(), data.length);
            data[idx] = elt;
        }
        return stack;
    }
}

