/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class TOENCODER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public TOENCODER(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof List)) {
            throw new WarpScriptException(this.getName() + " expects a list on top of the stack.");
        }
        List elements = (List)top;
        GTSEncoder encoder = new GTSEncoder(0L);
        for (Object element : elements) {
            Object lon;
            Object lat;
            if (element instanceof String) {
                element = OrderPreservingBase64.decode(element.toString().getBytes(StandardCharsets.US_ASCII));
            }
            if (element instanceof byte[]) {
                TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
                try {
                    GTSWrapper wrapper = new GTSWrapper();
                    deser.deserialize((TBase)wrapper, (byte[])element);
                    GTSDecoder decoder = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(wrapper);
                    decoder.next();
                    encoder.merge(decoder.getEncoder(true));
                    continue;
                }
                catch (TException te) {
                    throw new WarpScriptException(this.getName() + " failed to unwrap encoder.", te);
                }
                catch (IOException ioe) {
                    throw new WarpScriptException(this.getName() + " cannot get encoder from wrapper.", ioe);
                }
            }
            if (element instanceof GeoTimeSerie) {
                try {
                    encoder.encode((GeoTimeSerie)element);
                    continue;
                }
                catch (IOException ioe) {
                    throw new WarpScriptException(this.getName() + " was unable to add Geo Time Series\u2122", ioe);
                }
            }
            if (!(element instanceof List)) {
                throw new WarpScriptException(this.getName() + " encountered an invalid element.");
            }
            List elt = (List)element;
            if (elt.size() < 2 || elt.size() > 5) {
                throw new WarpScriptException(this.getName() + " encountered an invalid element.");
            }
            Object tick = elt.get(0);
            if (!(tick instanceof Long)) {
                throw new WarpScriptException(this.getName() + " encountered an invalid timestamp.");
            }
            Object value = null;
            long location = 91480763316633925L;
            long elevation = Long.MIN_VALUE;
            if (2 == elt.size()) {
                value = elt.get(1);
            } else if (3 == elt.size()) {
                Object elev = elt.get(1);
                if (elev instanceof Number) {
                    if (!Double.isNaN(((Number)elev).doubleValue())) {
                        elevation = ((Number)elev).longValue();
                    }
                } else {
                    throw new WarpScriptException(this.getName() + " encountered an invalid element.");
                }
                value = elt.get(2);
            } else if (4 == elt.size()) {
                lat = elt.get(1);
                lon = elt.get(2);
                if (lat instanceof Number && lon instanceof Number) {
                    if (!Double.isNaN(((Number)lat).doubleValue()) && !Double.isNaN(((Number)lon).doubleValue())) {
                        location = GeoXPLib.toGeoXPPoint((double)((Number)lat).doubleValue(), (double)((Number)lon).doubleValue());
                    }
                } else {
                    throw new WarpScriptException(this.getName() + " encountered an invalid element.");
                }
                value = elt.get(3);
            } else {
                lat = elt.get(1);
                lon = elt.get(2);
                if (lat instanceof Number && lon instanceof Number) {
                    if (!Double.isNaN(((Number)lat).doubleValue()) && !Double.isNaN(((Number)lon).doubleValue())) {
                        location = GeoXPLib.toGeoXPPoint((double)((Number)lat).doubleValue(), (double)((Number)lon).doubleValue());
                    }
                } else {
                    throw new WarpScriptException(this.getName() + " encountered an invalid element.");
                }
                Object elev = elt.get(3);
                if (elev instanceof Number) {
                    if (!Double.isNaN(((Number)elev).doubleValue())) {
                        elevation = ((Number)elev).longValue();
                    }
                } else {
                    throw new WarpScriptException(this.getName() + " encountered an invalid element.");
                }
                value = elt.get(4);
            }
            try {
                encoder.addValue((Long)tick, location, elevation, value);
            }
            catch (IOException ioe) {
                throw new WarpScriptException(this.getName() + " was unable to add value.", ioe);
            }
        }
        stack.push(encoder);
        return stack;
    }
}

