/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.gts.MetadataSelectorMatcher;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class TOGTS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final String TYPE_LABEL_NAME_PARAMETER = "label.type";
    private static final String DEFAULT_TYPE_LABEL_NAME = ".type";

    public TOGTS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Cloneable result;
        LinkedHashMap typeMap = null;
        Object top = stack.pop();
        String extraLabel = DEFAULT_TYPE_LABEL_NAME;
        if (top instanceof Map) {
            typeMap = new LinkedHashMap();
            for (Map.Entry entry : ((Map)top).entrySet()) {
                if (entry.getKey() instanceof String) {
                    String t = (String)entry.getKey();
                    if ("LONG".equals(t) || "DOUBLE".equals(t) || "BOOLEAN".equals(t) || "STRING".equals(t) || "BINARY".equals(t)) {
                        ArrayList<MetadataSelectorMatcher> l;
                        if (entry.getValue() instanceof String) {
                            l = new ArrayList<MetadataSelectorMatcher>();
                            l.add(new MetadataSelectorMatcher((String)entry.getValue()));
                            typeMap.put((String)entry.getKey(), l);
                            continue;
                        }
                        if (entry.getValue() instanceof List) {
                            l = new ArrayList();
                            for (Object sel : (List)entry.getValue()) {
                                if (sel instanceof String) {
                                    l.add(new MetadataSelectorMatcher((String)sel));
                                    continue;
                                }
                                throw new WarpScriptException(this.getName() + " type MAP input must contains selector or list of thereof for each type.");
                            }
                            typeMap.put((String)entry.getKey(), l);
                            continue;
                        }
                        throw new WarpScriptException(this.getName() + " type MAP input must contains selector or list of thereof for each type.");
                    }
                    if (TYPE_LABEL_NAME_PARAMETER.equals(t)) {
                        if (null == entry.getValue()) {
                            extraLabel = null;
                            continue;
                        }
                        if (entry.getValue() instanceof String) {
                            extraLabel = (String)entry.getValue();
                            continue;
                        }
                        throw new WarpScriptException(this.getName() + " extra 'label' input in the MAP must be either null or a string.");
                    }
                    throw new WarpScriptException(this.getName() + " type MAP input must contains valid types as key (LONG, DOUBLE, BOOLEAN, STRING or BINARY) or '" + TYPE_LABEL_NAME_PARAMETER + "' to override '" + DEFAULT_TYPE_LABEL_NAME + "' label.");
                }
                throw new WarpScriptException(this.getName() + " type MAP input must contains valid types as key (LONG, DOUBLE, BOOLEAN, STRING or BINARY) or '" + TYPE_LABEL_NAME_PARAMETER + "' to override '" + DEFAULT_TYPE_LABEL_NAME + "' label.");
            }
            top = stack.pop();
        }
        ArrayList<GTSDecoder> decodersInput = new ArrayList<GTSDecoder>();
        boolean listInput = false;
        if (top instanceof List) {
            for (Object o : (List)top) {
                if (!(o instanceof String || o instanceof byte[] || o instanceof GTSEncoder)) {
                    throw new WarpScriptException(this.getName() + " operates on a string, a byte array, an encoder, or list thereof.");
                }
                decodersInput.add(this.getDecoderFromObject(o));
            }
            listInput = true;
        } else if (top instanceof String || top instanceof byte[] || top instanceof GTSEncoder) {
            decodersInput.add(this.getDecoderFromObject(top));
        } else {
            throw new WarpScriptException(this.getName() + " operates on a string, a byte array, an encoder, or list thereof.");
        }
        if (null == typeMap) {
            result = new HashMap();
            for (GTSDecoder decoder : decodersInput) {
                HashMap<String, GeoTimeSerie> series = new HashMap<String, GeoTimeSerie>();
                while (decoder.next()) {
                    Iterator value = decoder.getBinaryValue();
                    String type = "DOUBLE";
                    if (value instanceof String) {
                        type = "STRING";
                    } else if (value instanceof Boolean) {
                        type = "BOOLEAN";
                    } else if (value instanceof Long) {
                        type = "LONG";
                    } else if (value instanceof Double || value instanceof BigDecimal) {
                        type = "DOUBLE";
                    } else if (value instanceof byte[]) {
                        type = "BINARY";
                    }
                    GeoTimeSerie gts = (GeoTimeSerie)series.get(type);
                    if (null == gts) {
                        gts = new GeoTimeSerie();
                        gts.setMetadata(decoder.getMetadata());
                        series.put(type, gts);
                    }
                    GTSHelper.setValue(gts, decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), value, false);
                }
                if (!listInput) {
                    stack.push(series);
                    return stack;
                }
                for (Map.Entry entry : series.entrySet()) {
                    if (!result.containsKey(entry.getKey())) {
                        result.put(entry.getKey(), new ArrayList());
                    }
                    ((ArrayList)result.get(entry.getKey())).add(entry.getValue());
                }
            }
            stack.push(result);
            return stack;
        }
        result = new ArrayList();
        for (GTSDecoder decoder : decodersInput) {
            GeoTimeSerie gts = new GeoTimeSerie((int)Math.min(Integer.MAX_VALUE, decoder.getCount()));
            gts.setMetadata(decoder.getMetadata());
            String enforcedType = null;
            boolean mustGuessTypeFromFirstValue = true;
            for (Map.Entry entry : typeMap.entrySet()) {
                for (MetadataSelectorMatcher m : (ArrayList)entry.getValue()) {
                    if (m.matches(decoder.getMetadata())) {
                        enforcedType = (String)entry.getKey();
                        mustGuessTypeFromFirstValue = false;
                    }
                    if (null == enforcedType) continue;
                    break;
                }
                if (null == enforcedType) continue;
                break;
            }
            if (!mustGuessTypeFromFirstValue) {
                if ("DOUBLE".equals(enforcedType)) {
                    gts.setType(GeoTimeSerie.TYPE.DOUBLE);
                } else if ("LONG".equals(enforcedType)) {
                    gts.setType(GeoTimeSerie.TYPE.LONG);
                } else if ("STRING".equals(enforcedType) || "BINARY".equals(enforcedType)) {
                    gts.setType(GeoTimeSerie.TYPE.STRING);
                } else if ("BOOLEAN".equals(enforcedType)) {
                    gts.setType(GeoTimeSerie.TYPE.BOOLEAN);
                }
            }
            while (decoder.next()) {
                Object value = decoder.getBinaryValue();
                GTSHelper.setValue(gts, decoder.getTimestamp(), decoder.getLocation(), decoder.getElevation(), value, false);
                if (!mustGuessTypeFromFirstValue) continue;
                if (value instanceof String) {
                    enforcedType = "STRING";
                } else if (value instanceof Boolean) {
                    enforcedType = "BOOLEAN";
                } else if (value instanceof Long) {
                    enforcedType = "LONG";
                } else if (value instanceof Double || value instanceof BigDecimal) {
                    enforcedType = "DOUBLE";
                } else if (value instanceof byte[]) {
                    enforcedType = "BINARY";
                }
                mustGuessTypeFromFirstValue = false;
            }
            if (null != extraLabel) {
                if (null != gts.getLabel(extraLabel)) {
                    throw new WarpScriptException(this.getName() + " the input already has label " + extraLabel);
                }
                if (null == enforcedType) {
                    gts.setLabel(extraLabel, "UNDEFINED");
                } else {
                    gts.setLabel(extraLabel, enforcedType);
                }
            }
            if (!listInput) {
                stack.push(gts);
                return stack;
            }
            ((ArrayList)result).add(gts);
        }
        stack.push(result);
        return stack;
    }

    private GTSDecoder getDecoderFromObject(Object o) throws WarpScriptException {
        GTSDecoder decoder;
        if (o instanceof GTSEncoder) {
            decoder = ((GTSEncoder)o).getUnsafeDecoder(false);
        } else {
            try {
                byte[] bytes = o instanceof String ? OrderPreservingBase64.decode(o.toString().getBytes(StandardCharsets.US_ASCII)) : (byte[])o;
                TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
                GTSWrapper wrapper = new GTSWrapper();
                deser.deserialize((TBase)wrapper, bytes);
                decoder = GTSWrapperHelper.fromGTSWrapperToGTSDecoder(wrapper);
            }
            catch (TException te) {
                throw new WarpScriptException(this.getName() + " failed to unwrap encoder.", te);
            }
        }
        return decoder;
    }
}

