/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class UNWRAP
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean empty;

    public UNWRAP(String name, boolean empty) {
        super(name);
        this.empty = empty;
    }

    public UNWRAP(String name) {
        super(name);
        this.empty = false;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof String || top instanceof byte[] || top instanceof List)) {
            throw new WarpScriptException(this.getName() + " operates on a string or byte array or a list thereof.");
        }
        ArrayList<Object> inputs = new ArrayList<Object>();
        if (top instanceof String || top instanceof byte[]) {
            inputs.add(top);
        } else {
            for (Object o : (List)top) {
                if (!(o instanceof String) && !(o instanceof byte[])) {
                    throw new WarpScriptException(this.getName() + " operates on a string or byte array or a list thereof.");
                }
                inputs.add(o);
            }
        }
        ArrayList<GeoTimeSerie> outputs = new ArrayList<GeoTimeSerie>();
        for (Object e : inputs) {
            byte[] bytes = e instanceof String ? OrderPreservingBase64.decode(e.toString().getBytes(StandardCharsets.US_ASCII)) : (byte[])e;
            TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
            try {
                GTSWrapper wrapper = new GTSWrapper();
                deser.deserialize((TBase)wrapper, bytes);
                GeoTimeSerie gts = GTSWrapperHelper.fromGTSWrapperToGTS(wrapper, this.empty);
                outputs.add(gts);
            }
            catch (TException te) {
                throw new WarpScriptException(this.getName() + " failed to unwrap GTS.", te);
            }
        }
        if (!(top instanceof List)) {
            stack.push(outputs.get(0));
        } else {
            stack.push(outputs);
        }
        return stack;
    }
}

