/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.CSTORE;
import io.warp10.script.functions.ENDLIST;
import io.warp10.script.functions.LOAD;
import io.warp10.script.functions.MARK;
import io.warp10.script.functions.NULL;
import io.warp10.script.functions.POPR;
import io.warp10.script.functions.PUSHR;
import io.warp10.script.functions.STORE;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class VARS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public VARS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a macro.");
        }
        LinkedHashSet<Long> symbols = new LinkedHashSet<Long>();
        final HashMap<Long, AtomicInteger> occurrences = new HashMap<Long, AtomicInteger>();
        ArrayList<WarpScriptStack.Macro> allmacros = new ArrayList<WarpScriptStack.Macro>();
        allmacros.add((WarpScriptStack.Macro)top);
        boolean abort = false;
        block0: while (!abort && !allmacros.isEmpty()) {
            WarpScriptStack.Macro m = (WarpScriptStack.Macro)allmacros.remove(0);
            ArrayList<Object> statements = new ArrayList<Object>(m.statements());
            block1: for (int i = 0; i < statements.size(); ++i) {
                AtomicInteger occ;
                Object symbol;
                AtomicInteger occ2;
                if (statements.get(i) instanceof WarpScriptStack.Macro) {
                    allmacros.add((WarpScriptStack.Macro)statements.get(i));
                    continue;
                }
                if (statements.get(i) instanceof POPR) {
                    symbols.add(Long.valueOf(((POPR)statements.get(i)).getRegister()));
                    occ2 = (AtomicInteger)occurrences.get(((POPR)statements.get(i)).getRegister());
                    if (null == occ2) {
                        occ2 = new AtomicInteger();
                        occurrences.put(Long.valueOf(((POPR)statements.get(i)).getRegister()), occ2);
                    }
                    occ2.incrementAndGet();
                    continue;
                }
                if (statements.get(i) instanceof PUSHR) {
                    symbols.add(Long.valueOf(((PUSHR)statements.get(i)).getRegister()));
                    occ2 = (AtomicInteger)occurrences.get(((PUSHR)statements.get(i)).getRegister());
                    if (null == occ2) {
                        occ2 = new AtomicInteger();
                        occurrences.put(Long.valueOf(((PUSHR)statements.get(i)).getRegister()), occ2);
                    }
                    occ2.incrementAndGet();
                    continue;
                }
                if (statements.get(i) instanceof LOAD || statements.get(i) instanceof CSTORE) {
                    symbol = statements.get(i - 1);
                    if (symbol instanceof String || symbol instanceof Long) {
                        symbols.add((Long)symbol);
                        AtomicInteger occ3 = (AtomicInteger)occurrences.get(symbol);
                        if (null == occ3) {
                            occ3 = new AtomicInteger();
                            occurrences.put((Long)symbol, occ3);
                        }
                        occ3.incrementAndGet();
                        continue;
                    }
                    abort = true;
                    continue block0;
                }
                if (!(statements.get(i) instanceof STORE)) continue;
                if (0 == i) {
                    abort = true;
                    continue block0;
                }
                symbol = statements.get(i - 1);
                if (symbol instanceof List) {
                    for (Object elt : (List)symbol) {
                        if (elt instanceof String || elt instanceof Long) {
                            symbols.add((Long)elt);
                            occ = (AtomicInteger)occurrences.get(elt);
                            if (null == occ) {
                                occ = new AtomicInteger();
                                occurrences.put((Long)elt, occ);
                            }
                            occ.incrementAndGet();
                            continue;
                        }
                        if (null == elt) continue;
                        abort = true;
                        continue block1;
                    }
                    continue;
                }
                if (symbol instanceof ENDLIST) {
                    int idx = i - 2;
                    while (idx >= 0 && !(statements.get(idx) instanceof MARK)) {
                        Object stmt;
                        if ((stmt = statements.get(idx--)) instanceof String || stmt instanceof Long) {
                            symbols.add((Long)stmt);
                            occ = (AtomicInteger)occurrences.get(stmt);
                            if (null == occ) {
                                occ = new AtomicInteger();
                                occurrences.put((Long)stmt, occ);
                            }
                            occ.incrementAndGet();
                            continue;
                        }
                        if (null == stmt || stmt instanceof NULL) continue;
                        abort = true;
                        continue block1;
                    }
                    continue;
                }
                if (symbol instanceof String || symbol instanceof Long) continue;
                abort = true;
            }
        }
        if (abort) {
            throw new WarpScriptException(this.getName() + " encountered a LOAD/STORE or CSTORE operation with a non explicit symbol name.");
        }
        ArrayList<Object> vars = new ArrayList<Object>(symbols);
        vars.sort(new Comparator<Object>(){

            @Override
            public int compare(Object s1, Object s2) {
                AtomicInteger occ1 = (AtomicInteger)occurrences.get(s1);
                AtomicInteger occ2 = (AtomicInteger)occurrences.get(s2);
                if (occ1.get() < occ2.get()) {
                    return 1;
                }
                if (occ1.get() > occ2.get()) {
                    return -1;
                }
                return s1.toString().compareTo(s2.toString());
            }
        });
        stack.push(vars);
        return stack;
    }
}

