/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions.shape;

import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.formatted.FormattedWarpScriptFunction;
import io.warp10.script.functions.shape.CHECKSHAPE;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SHAPE
extends FormattedWarpScriptFunction {
    public static final String LIST = "list";
    public static final String FAST = "fast";
    public static final String SHAPE = "shape";
    private final FormattedWarpScriptFunction.Arguments args;
    private final FormattedWarpScriptFunction.Arguments output;

    @Override
    protected FormattedWarpScriptFunction.Arguments getArguments() {
        return this.args;
    }

    protected FormattedWarpScriptFunction.Arguments getOutput() {
        return this.output;
    }

    public SHAPE(String name) {
        super(name);
        this.getDocstring().append("Return the shape of an input list if it could be a tensor (or multidimensional array), or raise an Exception.");
        this.args = new FormattedWarpScriptFunction.ArgumentsBuilder().addArgument(List.class, LIST, "The input list.").addOptionalArgument(Boolean.class, FAST, "If true, it does not check if the sizes of the nested lists are coherent and it returns a shape based on the first nested lists at each level. Default to false.", false).build();
        this.output = new FormattedWarpScriptFunction.ArgumentsBuilder().addListArgument(Long.class, SHAPE, "The shape of the input list.").build();
    }

    @Override
    protected WarpScriptStack apply(Map<String, Object> formattedArgs, WarpScriptStack stack) throws WarpScriptException {
        List list = (List)formattedArgs.get(LIST);
        boolean fast = Boolean.TRUE.equals(formattedArgs.get(FAST));
        List<Long> candidateShape = io.warp10.script.functions.shape.SHAPE.candidate_shape(list);
        if (!fast && !CHECKSHAPE.recValidateShape(list, candidateShape).booleanValue()) {
            throw new WarpScriptException(this.getName() + " expects that the sizes of the nested lists are coherent together to form a tensor (or multidimensional array).");
        }
        stack.push(candidateShape);
        return stack;
    }

    static List<Long> candidate_shape(List list) {
        ArrayList<Long> shape = new ArrayList<Long>();
        List l = list;
        while (l instanceof List) {
            shape.add(Long.valueOf(l.size()));
            l = l.get(0);
        }
        return shape;
    }
}

