/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class MapperHourOfDay
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction,
WarpScriptAggregatorFunction {
    private final DateTimeZone dtz;

    public MapperHourOfDay(String name) {
        super(name);
        this.dtz = DateTimeZone.UTC;
    }

    public MapperHourOfDay(String name, Object timezone) {
        super(name);
        this.dtz = timezone instanceof String ? DateTimeZone.forID((String)timezone.toString()) : (timezone instanceof Number ? DateTimeZone.forOffsetMillis((int)((Number)timezone).intValue()) : DateTimeZone.UTC);
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        long tick = (Long)args[0];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        long location = locations[0];
        long elevation = elevations[0];
        DateTime dt = new DateTime(tick / Constants.TIME_UNITS_PER_MS, this.dtz);
        return new Object[]{tick, location, elevation, dt.getHourOfDay()};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.dtz.getID()));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object timezone = stack.pop();
            stack.push(new MapperHourOfDay(this.getName(), timezone));
            return stack;
        }
    }
}

