/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptAggregatorFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class STRICTMAPPER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public STRICTMAPPER(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a maximum (inclusive) number of values or a minimum timespan on top of the stack.");
        }
        long max = ((Number)o).longValue();
        o = stack.pop();
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a minimum (inclusive) number of values or a minimum timespan below the top of the stack.");
        }
        long min = ((Number)o).longValue();
        if (Long.MIN_VALUE == min) {
            ++min;
        }
        if (Long.MIN_VALUE == max) {
            ++max;
        }
        if ((min > 0L && max >= 0L || min < 0L && max <= 0L) && Math.abs(min) > Math.abs(max)) {
            throw new WarpScriptException(this.getName() + " expects abs(min) <= abs(max) when min and max both express a count or both express a duration");
        }
        o = stack.pop();
        if (!(o instanceof WarpScriptMapperFunction)) {
            throw new WarpScriptException(this.getName() + " expects a mapper below the extrema defining the value count range or timespan.");
        }
        WarpScriptMapperFunction mapper = (WarpScriptMapperFunction)o;
        stack.push(new StringentMapper(this.getName(), min, max, mapper));
        return stack;
    }

    private static final class StringentMapper
    extends NamedWarpScriptFunction
    implements WarpScriptMapperFunction,
    WarpScriptAggregatorFunction {
        private final long min;
        private final long max;
        private final WarpScriptMapperFunction mapper;

        public StringentMapper(String name, long min, long max, WarpScriptMapperFunction mapper) {
            super(name);
            this.min = min;
            this.max = max;
            this.mapper = mapper;
        }

        @Override
        public Object apply(Object[] args) throws WarpScriptException {
            long[] ticks = (long[])args[3];
            long timespan = 0 == ticks.length ? 0L : ticks[ticks.length - 1] - ticks[0] + 1L;
            if (this.min > 0L && (long)ticks.length < this.min || this.max > 0L && (long)ticks.length > this.max || this.min < 0L && timespan < -this.min || this.max < 0L && timespan > -this.max) {
                return new Object[]{args[0], 91480763316633925L, Long.MIN_VALUE, null};
            }
            return this.mapper.apply(args);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<%");
            sb.append(" ");
            sb.append(this.mapper.toString());
            sb.append(" ");
            sb.append(this.min);
            sb.append(" ");
            sb.append(this.max);
            sb.append(" ");
            sb.append(this.getName());
            sb.append(" ");
            sb.append("%>");
            sb.append(" ");
            sb.append("EVAL");
            return sb.toString();
        }
    }
}

