/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.warpscript;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRow;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.plugin.BackendClient;
import com.dataiku.dip.plugin.CustomRecipe;
import com.dataiku.dip.plugin.ExecutionContext;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.warp10.WarpConfig;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.MemoryWarpScriptStack;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class WarpScriptRecipe
implements CustomRecipe {
    private static final String WARP_TIMEUNITS_DEFAULT_VALUE = "=us";
    private JsonObject warpScriptProperties;
    private String warpScriptCode;
    private String timestampColumnName;
    private final List<String> valueColumnNames = new ArrayList<String>();
    private static final DKULogger logger = DKULogger.getLogger((String)"warpscript.recipe");

    public void init(String projectKey, JsonObject config, JsonObject pluginConfig, String resourceFolder) {
        this.warpScriptProperties = config.getAsJsonObject("properties");
        this.warpScriptCode = config.getAsJsonPrimitive("code").getAsString();
        this.timestampColumnName = config.getAsJsonPrimitive("timestampColumn").getAsString();
        for (JsonElement jsonElement : config.getAsJsonArray("valueColumns")) {
            this.valueColumnNames.add(jsonElement.getAsString());
        }
    }

    public void run(ExecutionContext context, BackendClient client) throws Exception {
        ArrayList<GeoTimeSerie> resultGts;
        WarpConfig.setProperties((Reader)new StringReader("warp.timeunits=us"));
        for (Map.Entry property : this.warpScriptProperties.entrySet()) {
            WarpConfig.setProperty((String)((String)property.getKey()), (String)((JsonElement)property.getValue()).getAsString());
        }
        MemoryWarpScriptStack stack = new MemoryWarpScriptStack(null, null);
        stack.maxLimits();
        List<GeoTimeSerie> gtsFromDataset = this.createGtsFromDataset(context);
        if (gtsFromDataset.size() == 1) {
            stack.push((Object)gtsFromDataset.get(0));
        } else {
            stack.push(gtsFromDataset);
        }
        logger.info((Object)"Executing WarpScript");
        stack.execMulti(this.warpScriptCode);
        if (stack.depth() != 1) {
            throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "WarpScript stack does not contain exactly 1 element after execution, but it contains " + stack.depth());
        }
        Object poppedObject = stack.pop();
        if (poppedObject instanceof List) {
            resultGts = new ArrayList();
            List resultList = (List)poppedObject;
            for (Object item : resultList) {
                if (!(item instanceof GeoTimeSerie)) {
                    throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Found a " + item.getClass().getName() + " in the resulting List, only GeoTimeSeries objects are allowed");
                }
                resultGts.add((GeoTimeSerie)item);
            }
        } else if (poppedObject instanceof GeoTimeSerie) {
            resultGts = Collections.singletonList((GeoTimeSerie)poppedObject);
        } else {
            String objectClassName = poppedObject == null ? "null" : "a " + poppedObject.getClass().getName();
            throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Element on the stack is " + objectClassName + ", it must be either a List or a GeoTimeSeries object");
        }
        this.writeGtsToDataset(resultGts, context);
    }

    private List<GeoTimeSerie> createGtsFromDataset(ExecutionContext context) throws Exception {
        ExecutionContext.InputInfo inputInfo = (ExecutionContext.InputInfo)context.getInputs().get(0);
        Schema schema = inputInfo.getSchema();
        if (schema.getColumn(this.timestampColumnName) == null) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_SCHEMA_TO_DATA_MISMATCH, "Input dataset schema must contain a timestamp column named " + this.timestampColumnName);
        }
        StreamColumnFactory columnFactory = new StreamColumnFactory();
        Column timestampColumn = columnFactory.column(this.timestampColumnName);
        HashMap<Column, Type> valuesColumnTypes = new HashMap<Column, Type>();
        for (String string : this.valueColumnNames) {
            if (schema.getColumn(string) == null) {
                throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_SCHEMA_TO_DATA_MISMATCH, "Input dataset schema must contain a column named " + string);
            }
            Type type = schema.getColumn(string).getType();
            Column valueColumn = columnFactory.column(string);
            valuesColumnTypes.put(valueColumn, type);
        }
        ArrayList<Column> labels = new ArrayList<Column>();
        for (SchemaColumn column : schema.getColumns()) {
            String columnName = column.getName();
            if (this.timestampColumnName.equals(columnName) || this.valueColumnNames.contains(columnName)) continue;
            logger.infoV("Detected column %s as a label", new Object[]{columnName});
            labels.add(columnFactory.column(columnName));
        }
        logger.infoV("Converting %s into a GeoTimeSeries and pushing on the stack", new Object[]{inputInfo.getId()});
        HashMap<Metadata, GeoTimeSerie> hashMap = new HashMap<Metadata, GeoTimeSerie>();
        inputInfo.pullFromDataset((ProcessorOutput)new GtsProcessorOutput(hashMap, timestampColumn, valuesColumnTypes, labels), (ColumnFactory)columnFactory, (RowFactory)new StreamRowFactory());
        return new ArrayList<GeoTimeSerie>(hashMap.values());
    }

    private void writeGtsToDataset(List<GeoTimeSerie> resultGts, ExecutionContext context) throws Exception {
        Schema schema = new Schema().withColumn(this.timestampColumnName, Type.BIGINT);
        StreamColumnFactory columnFactory = new StreamColumnFactory();
        Column timestampColumn = columnFactory.column(this.timestampColumnName);
        HashSet labelColumns = new HashSet();
        for (GeoTimeSerie gts : resultGts) {
            Type dssType;
            GeoTimeSerie.TYPE type = gts.getType();
            switch (type) {
                case LONG: {
                    dssType = Type.BIGINT;
                    break;
                }
                case DOUBLE: {
                    dssType = Type.DOUBLE;
                    break;
                }
                case BOOLEAN: {
                    dssType = Type.BOOLEAN;
                    break;
                }
                default: {
                    dssType = Type.STRING;
                }
            }
            schema.withColumn(gts.getName(), dssType);
            labelColumns.addAll(gts.getLabels().keySet());
        }
        for (String labelColumn : labelColumns) {
            schema.withColumn(labelColumn, Type.STRING);
        }
        ExecutionContext.OutputInfo outputInfo = (ExecutionContext.OutputInfo)context.getOutputs().get(0);
        if (outputInfo.getWriteMode() == Output.WriteMode.OVERWRITE) {
            outputInfo.clear();
        }
        outputInfo.setSchema(schema);
        logger.infoV("Writing resulting GeoTimeSeries to %s", new Object[]{outputInfo.getId()});
        OutputWriter outputWriter = outputInfo.pushToDataset();
        outputWriter.init((ColumnFactory)columnFactory);
        TreeSet ticks = new TreeSet();
        for (GeoTimeSerie gts : resultGts) {
            if (gts.size() <= 0) continue;
            Collections.addAll(ticks, ArrayUtils.toObject((long[])GTSHelper.getTicks((GeoTimeSerie)gts)));
        }
        Iterator<Object> iterator = ticks.iterator();
        while (iterator.hasNext()) {
            long tick = (Long)iterator.next();
            StreamRow row = new StreamRow().with(timestampColumn, tick);
            for (GeoTimeSerie gts : resultGts) {
                Object value = GTSHelper.valueAtTick((GeoTimeSerie)gts, (long)tick);
                if (value == null) continue;
                Column valueColumn = columnFactory.column(gts.getName());
                switch (gts.getType()) {
                    case LONG: {
                        row.with(valueColumn, ((Long)value).longValue());
                        break;
                    }
                    case DOUBLE: {
                        row.with(valueColumn, ((Double)value).doubleValue());
                        break;
                    }
                    case BOOLEAN: {
                        row.with(valueColumn, ((Boolean)value).booleanValue());
                        break;
                    }
                    default: {
                        row.with(valueColumn, (String)value);
                    }
                }
                for (Map.Entry label : gts.getLabels().entrySet()) {
                    Column labelColumn = columnFactory.column((String)label.getKey());
                    row.with(labelColumn, (String)label.getValue());
                }
            }
            outputWriter.emitRow((Row)row);
        }
        outputWriter.lastRowEmitted();
    }

    public void abort() {
    }

    private static class GtsProcessorOutput
    implements ProcessorOutput {
        private final Map<Metadata, GeoTimeSerie> geoTimeSeriesMap;
        private final Map<Column, Type> valueColumnTypes;
        private final Column timestampColumn;
        private final List<Column> labelColumns;

        GtsProcessorOutput(Map<Metadata, GeoTimeSerie> geoTimeSeriesMap, Column timestampColumn, Map<Column, Type> valueColumnTypes, List<Column> labelColumns) {
            this.geoTimeSeriesMap = geoTimeSeriesMap;
            this.valueColumnTypes = valueColumnTypes;
            this.timestampColumn = timestampColumn;
            this.labelColumns = labelColumns;
        }

        public void emitRow(Row row) {
            long ts = Long.parseLong(row.get(this.timestampColumn));
            HashMap<String, String> labels = new HashMap<String, String>();
            for (Column column : this.labelColumns) {
                String labelValue = row.get(column);
                if (!StringUtils.isNotBlank((String)labelValue)) continue;
                labels.put(column.getName(), labelValue);
            }
            for (Map.Entry entry : this.valueColumnTypes.entrySet()) {
                Column column = (Column)entry.getKey();
                Type type = (Type)entry.getValue();
                String valueString = row.get(column);
                if (StringUtils.isBlank((String)valueString)) continue;
                Object value = valueString;
                if (type.isInteger()) {
                    value = Long.valueOf(valueString);
                } else if (type.isFloatingPoint()) {
                    value = Double.valueOf(valueString);
                } else if (type == Type.BOOLEAN) {
                    value = Boolean.valueOf(valueString);
                }
                Metadata gtsMetadata = new Metadata().setName(column.getName()).setLabels(labels);
                GeoTimeSerie gts = this.geoTimeSeriesMap.get(gtsMetadata);
                if (gts == null) {
                    gts = new GeoTimeSerie();
                    gts.setMetadata(gtsMetadata);
                    this.geoTimeSeriesMap.put(gtsMetadata, gts);
                }
                GTSHelper.setValue((GeoTimeSerie)gts, (long)ts, (Object)value);
            }
        }

        public void lastRowEmitted() {
        }

        public void cancel() {
        }

        public void setMaxMemoryUsed(long l) {
        }
    }
}

