/*
 * Decompiled with CFR 0.152.
 */
package org.boon;

import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.IO;
import org.boon.Lists;
import org.boon.StringScanner;

public class Classpaths {
    public static List<URL> classpathResources(ClassLoader loader, String resource) {
        try {
            Enumeration<URL> resources = loader.getResources(resource);
            List<URL> list = Lists.list(resources);
            if (Lists.isEmpty(list) && resource.startsWith("/")) {
                resource = resource.substring(1);
                return Classpaths.classpathResources(loader, resource);
            }
            return list;
        }
        catch (Exception ex) {
            return Exceptions.handle(List.class, Boon.sputs("Unable to load listFromClassLoader for", resource), ex);
        }
    }

    public static List<URL> classpathResources(Class<?> clazz, String resource) {
        List<URL> list = Classpaths.classpathResources(Thread.currentThread().getContextClassLoader(), resource);
        if (Lists.isEmpty(list)) {
            list = Classpaths.classpathResources(clazz.getClassLoader(), resource);
        }
        if (Lists.isEmpty(list) && resource.startsWith("/")) {
            resource = resource.substring(1);
            return Classpaths.classpathResources(clazz, resource);
        }
        return list;
    }

    public static List<String> resources(Class<?> clazz, String resource) {
        List<String> list = Classpaths.listFromClassLoader(Thread.currentThread().getContextClassLoader(), resource);
        if (Lists.isEmpty(list)) {
            list = Classpaths.listFromClassLoader(clazz.getClassLoader(), resource);
        }
        if (Lists.isEmpty(list) && resource.startsWith("/")) {
            resource = resource.substring(1);
            return Classpaths.resources(clazz, resource);
        }
        return list;
    }

    public static List<Path> paths(Class<?> clazz, String resource) {
        List<Path> list = Classpaths.pathsFromClassLoader(Thread.currentThread().getContextClassLoader(), resource);
        if (Lists.isEmpty(list)) {
            list = Classpaths.pathsFromClassLoader(clazz.getClassLoader(), resource);
        }
        if (Lists.isEmpty(list) && resource.startsWith("/")) {
            resource = resource.substring(1);
            return Classpaths.paths(clazz, resource);
        }
        return list;
    }

    public static List<String> listFromClassLoader(ClassLoader loader, String resource) {
        List<URL> resourceURLs = Classpaths.classpathResources(loader, resource);
        List<String> resourcePaths = Lists.list(String.class);
        HashMap<URI, FileSystem> pathToZipFileSystems = new HashMap<URI, FileSystem>();
        for (URL resourceURL : resourceURLs) {
            if (resourceURL.getProtocol().equals("jar")) {
                Classpaths.resourcesFromJar(resourcePaths, resourceURL, pathToZipFileSystems);
                continue;
            }
            Classpaths.resourcesFromFileSystem(resourcePaths, resourceURL);
        }
        return resourcePaths;
    }

    public static List<Path> pathsFromClassLoader(ClassLoader loader, String resource) {
        List<URL> resourceURLs = Classpaths.classpathResources(loader, resource);
        List<Path> resourcePaths = Lists.list(Path.class);
        HashMap<URI, FileSystem> pathToZipFileSystems = new HashMap<URI, FileSystem>();
        for (URL resourceURL : resourceURLs) {
            if (resourceURL.getProtocol().equals("jar")) {
                Classpaths.pathsFromJar(resourcePaths, resourceURL, pathToZipFileSystems);
                continue;
            }
            Classpaths.pathsFromFileSystem(resourcePaths, resourceURL);
        }
        return resourcePaths;
    }

    private static void resourcesFromFileSystem(List<String> resourcePaths, URL u) {
        URI fileURI = IO.createURI(u.toString());
        Lists.add(resourcePaths, IO.uriToPath(fileURI).toString());
    }

    private static void pathsFromFileSystem(List<Path> resourcePaths, URL u) {
        URI fileURI = IO.createURI(u.toString());
        Lists.add(resourcePaths, IO.uriToPath(fileURI));
    }

    private static void resourcesFromJar(List<String> resourcePaths, URL resourceURL, Map<URI, FileSystem> pathToZipFileSystems) {
        FileSystem fileSystem;
        Path path;
        String str = resourceURL.toString();
        String[] strings = StringScanner.split(str, '!');
        URI fileJarURI = URI.create(strings[0]);
        String resourcePath = strings[1];
        if (!pathToZipFileSystems.containsKey(fileJarURI)) {
            pathToZipFileSystems.put(fileJarURI, IO.zipFileSystem(fileJarURI));
        }
        if ((path = (fileSystem = pathToZipFileSystems.get(fileJarURI)).getPath(resourcePath, new String[0])) != null) {
            Lists.add(resourcePaths, str);
        }
    }

    private static void pathsFromJar(List<Path> resourcePaths, URL resourceURL, Map<URI, FileSystem> pathToZipFileSystems) {
        FileSystem fileSystem;
        Path path;
        String str = resourceURL.toString();
        String[] strings = StringScanner.split(str, '!');
        URI fileJarURI = URI.create(strings[0]);
        String resourcePath = strings[1];
        if (!pathToZipFileSystems.containsKey(fileJarURI)) {
            pathToZipFileSystems.put(fileJarURI, IO.zipFileSystem(fileJarURI));
        }
        if ((path = (fileSystem = pathToZipFileSystems.get(fileJarURI)).getPath(resourcePath, new String[0])) != null) {
            Lists.add(resourcePaths, path);
        }
    }

    private static void resourcePathsFromJar(List<Path> resourcePaths, URL resourceURL, Map<URI, FileSystem> pathToZipFileSystems) {
        FileSystem fileSystem;
        Path path;
        String str = resourceURL.toString();
        String[] strings = StringScanner.split(str, '!');
        URI fileJarURI = URI.create(strings[0]);
        String resourcePath = strings[1];
        if (!pathToZipFileSystems.containsKey(fileJarURI)) {
            pathToZipFileSystems.put(fileJarURI, IO.zipFileSystem(fileJarURI));
        }
        if ((path = (fileSystem = pathToZipFileSystems.get(fileJarURI)).getPath(resourcePath, new String[0])) != null) {
            Lists.add(resourcePaths, path);
        }
    }
}

