/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.boon.core.Sys;
import org.boon.core.timer.TimeKeeper;

public class SystemTimeKeeper
implements TimeKeeper {
    private static final AtomicLong time = new AtomicLong();
    private static final AtomicBoolean started = new AtomicBoolean();
    private static ScheduledExecutorService executorService;

    @Override
    public long time() {
        return time.get();
    }

    public static void start() {
        if (!started.getAndSet(true)) {
            executorService = Executors.newSingleThreadScheduledExecutor();
            executorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    time.set(System.nanoTime() / 1000000L);
                }
            }, 5L, 5L, TimeUnit.MILLISECONDS);
        }
        Sys.timer.set(new SystemTimeKeeper());
    }

    public static void shutDown() {
        executorService.shutdown();
    }
}

