/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.Lists;
import org.boon.core.Conversions;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.MapObjectConversion;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.Selector;
import org.boon.criteria.internal.Criteria;
import org.boon.criteria.internal.QueryFactory;
import org.boon.datarepo.DataRepoException;
import org.boon.datarepo.PlanStep;
import org.boon.datarepo.ResultSet;
import org.boon.datarepo.spi.ResultSetInternal;
import org.boon.sort.Sort;

public class ResultSetImpl<T>
implements ResultSetInternal<T> {
    private List<T> results;
    private List<List<T>> allResults;
    private int totalSize;
    private List<T> lastList;
    private Map<String, FieldAccess> fields;

    public ResultSetImpl(Map<String, FieldAccess> fields) {
        this.fields = fields;
        this.allResults = new ArrayList<List<T>>();
    }

    public ResultSetImpl(List<T> results, Map<String, FieldAccess> fields) {
        this.fields = fields;
        this.allResults = new ArrayList<List<T>>();
        this.addResults(results);
    }

    public ResultSetImpl(List<T> results) {
        this.fields = results.size() > 0 ? BeanUtils.getFieldsFromObject(results.get(0)) : Collections.EMPTY_MAP;
        this.allResults = new ArrayList<List<T>>();
        this.addResults(results);
    }

    private void prepareResults() {
        if (this.results == null && this.allResults.size() == 1) {
            this.results = this.allResults.get(0);
        } else if (this.results == null) {
            this.results = new ArrayList<T>(this.totalSize);
            for (List<T> list : this.allResults) {
                for (T item : list) {
                    this.results.add(item);
                }
            }
        }
        this.allResults.clear();
        this.totalSize = 0;
    }

    @Override
    public void addResults(List<T> results) {
        this.lastList = results;
        this.totalSize += results.size();
        this.allResults.add(results);
    }

    @Override
    public ResultSet expectOne() {
        this.prepareResults();
        if (this.results.size() == 0) {
            throw new DataRepoException("Expected one result, no results");
        }
        if (this.results.size() > 1) {
            throw new DataRepoException("Expected one result, but have many");
        }
        return this;
    }

    @Override
    public <EXPECT> ResultSet<EXPECT> expectOne(Class<EXPECT> clz) {
        return this.expectOne();
    }

    @Override
    public ResultSet expectMany() {
        this.prepareResults();
        if (this.results.size() <= 1) {
            throw new DataRepoException("Expected many");
        }
        return this;
    }

    @Override
    public ResultSet expectNone() {
        this.prepareResults();
        if (this.results.size() != 0) {
            throw new DataRepoException("Expected none");
        }
        return this;
    }

    @Override
    public ResultSet expectOneOrMany() {
        this.prepareResults();
        if (this.results.size() >= 1) {
            throw new DataRepoException("Expected one or many");
        }
        return this;
    }

    @Override
    public ResultSet removeDuplication() {
        this.prepareResults();
        this.results = new ArrayList<T>(this.asSet());
        return this;
    }

    @Override
    public ResultSet sort(Sort sort) {
        this.prepareResults();
        sort.sort(this.results);
        return this;
    }

    @Override
    public Collection<T> filter(Criteria criteria) {
        this.prepareResults();
        return QueryFactory.filter(this.results, criteria);
    }

    @Override
    public void filterAndPrune(Criteria criteria) {
        this.prepareResults();
        this.results = QueryFactory.filter(this.results, criteria);
    }

    @Override
    public ResultSet<List<Map<String, Object>>> select(Selector ... selectors) {
        this.prepareResults();
        return new ResultSetImpl<Map<String, Object>>(Selector.selectFrom(Arrays.asList(selectors), this.results, this.fields), this.fields);
    }

    @Override
    public int[] selectInts(Selector selector) {
        this.prepareResults();
        int[] values = new int[this.results.size()];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toInt(map.get(keyName));
        }
        return values;
    }

    @Override
    public float[] selectFloats(Selector selector) {
        this.prepareResults();
        float[] values = new float[this.results.size()];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toFloat(map.get(keyName));
        }
        return values;
    }

    @Override
    public short[] selectShorts(Selector selector) {
        this.prepareResults();
        short[] values = new short[this.results.size()];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toShort(map.get(keyName));
        }
        return values;
    }

    @Override
    public double[] selectDoubles(Selector selector) {
        this.prepareResults();
        double[] values = new double[this.results.size()];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toDouble(map.get(keyName));
        }
        return values;
    }

    @Override
    public byte[] selectBytes(Selector selector) {
        this.prepareResults();
        byte[] values = new byte[this.results.size()];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toByte(map.get(keyName));
        }
        return values;
    }

    @Override
    public char[] selectChars(Selector selector) {
        this.prepareResults();
        char[] values = new char[this.results.size()];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toChar(map.get(keyName));
        }
        return values;
    }

    @Override
    public Object[] selectObjects(Selector selector) {
        this.prepareResults();
        Object[] values = new Object[this.results.size()];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = map.get(keyName);
        }
        return values;
    }

    @Override
    public <OBJ> OBJ[] selectObjects(Class<OBJ> cls, Selector selector) {
        this.prepareResults();
        Object values = Array.newInstance(cls, this.results.size());
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < this.results.size(); ++index) {
            Map<String, Object> map = maps.get(index);
            BeanUtils.idx(values, index, map.get(keyName));
        }
        return (Object[])values;
    }

    @Override
    public <OBJ> ResultSet<OBJ> selectObjectsAsResultSet(Class<OBJ> cls, Selector selector) {
        this.prepareResults();
        Object values = Array.newInstance(cls, this.results.size());
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < this.results.size(); ++index) {
            Map<String, Object> map = maps.get(index);
            BeanUtils.idx(values, index, map.get(keyName));
        }
        Object[] array = (Object[])values;
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(array));
        return new ResultSetImpl<Object>(list);
    }

    @Override
    public Collection<T> asCollection() {
        this.prepareResults();
        return this.results;
    }

    @Override
    public String asJSONString() {
        this.prepareResults();
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public List<Map<String, Object>> asListOfMaps() {
        this.prepareResults();
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(this.results.size());
        for (T item : this.results) {
            items.add(MapObjectConversion.toMap(item));
        }
        return items;
    }

    @Override
    public List<T> asList() {
        this.prepareResults();
        return this.results;
    }

    @Override
    public Set<T> asSet() {
        this.prepareResults();
        return new HashSet<T>(this.results);
    }

    @Override
    public List<PlanStep> queryPlan() {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public T firstItem() {
        this.prepareResults();
        return this.results.get(0);
    }

    @Override
    public Map<String, Object> firstMap() {
        this.prepareResults();
        return MapObjectConversion.toMap(this.firstItem());
    }

    @Override
    public String firstJSON() {
        return Boon.toJson(this.firstItem());
    }

    @Override
    public int firstInt(Selector selector) {
        this.prepareResults();
        int[] values = new int[1];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getAlias();
        for (int index = 0; index < values.length && index < maps.size(); ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toInt(map.get(keyName));
            if (index == 1) break;
        }
        return values[0];
    }

    @Override
    public float firstFloat(Selector selector) {
        this.prepareResults();
        float[] values = new float[1];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toFloat(map.get(keyName));
            if (index == 1) break;
        }
        return values[1];
    }

    @Override
    public short firstShort(Selector selector) {
        this.prepareResults();
        short[] values = new short[1];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toShort(map.get(keyName));
            if (index == 1) break;
        }
        return values[1];
    }

    @Override
    public double firstDouble(Selector selector) {
        this.prepareResults();
        double[] values = new double[1];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toDouble(map.get(keyName));
            if (index == 1) break;
        }
        return values[1];
    }

    @Override
    public byte firstByte(Selector selector) {
        this.prepareResults();
        byte[] values = new byte[1];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toByte(map.get(keyName));
            if (index == 1) break;
        }
        return values[1];
    }

    @Override
    public char firstChar(Selector selector) {
        this.prepareResults();
        char[] values = new char[1];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = Conversions.toChar(map.get(keyName));
            if (index == 1) break;
        }
        return values[1];
    }

    @Override
    public Object firstObject(Selector selector) {
        this.prepareResults();
        Object[] values = new Object[1];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = map.get(keyName);
            if (index == 1) break;
        }
        return values[1];
    }

    @Override
    public <OBJ> OBJ firstObject(Class<OBJ> cls, Selector selector) {
        this.prepareResults();
        Object[] values = new Object[1];
        List<Map<String, Object>> maps = Selector.selectFrom(Lists.list(selector), this.results, this.fields);
        String keyName = selector.getName();
        for (int index = 0; index < values.length; ++index) {
            Map<String, Object> map = maps.get(index);
            values[index] = map.get(keyName);
            if (index == 1) break;
        }
        return (OBJ)values[1];
    }

    @Override
    public List<T> paginate(int start, int size) {
        this.prepareResults();
        return this.results.subList(start, start + size);
    }

    @Override
    public List<Map<String, Object>> paginateMaps(int start, int size) {
        this.prepareResults();
        ArrayList<Map<String, Object>> mapResults = new ArrayList<Map<String, Object>>();
        List<T> list = this.paginate(start, size);
        for (T item : list) {
            mapResults.add(MapObjectConversion.toMap(item));
        }
        return mapResults;
    }

    @Override
    public String paginateJSON(int start, int size) {
        this.prepareResults();
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public int size() {
        if (this.results != null) {
            return this.results.size();
        }
        return this.totalSize;
    }

    @Override
    public Iterator<T> iterator() {
        this.prepareResults();
        return this.results.iterator();
    }

    @Override
    public void andResults() {
        if (this.allResults.size() == 0) {
            return;
        }
        if (this.allResults.size() == 1) {
            this.prepareResults();
            return;
        }
        boolean foundEmpty = false;
        for (List<T> list : this.allResults) {
            if (list.size() != 0) continue;
            foundEmpty = true;
            break;
        }
        if (foundEmpty) {
            this.results = Collections.EMPTY_LIST;
            this.allResults.clear();
            this.totalSize = 0;
            return;
        }
        List<T> shortestList = null;
        int min = Integer.MAX_VALUE;
        for (List<T> list : this.allResults) {
            int size = list.size();
            if (size >= min) continue;
            min = size;
            shortestList = list;
        }
        if (shortestList == null) {
            return;
        }
        this.allResults.remove(shortestList);
        HashSet set = new HashSet(shortestList);
        for (List<T> list : this.allResults) {
            set.retainAll(list);
        }
        this.results = new ArrayList<T>(set);
        this.allResults.clear();
        this.totalSize = 0;
    }

    @Override
    public int lastSize() {
        if (this.lastList == null) {
            return 0;
        }
        return this.lastList.size();
    }
}

