/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.boon.core.reflection.fields.FieldAccessMode;
import org.boon.core.reflection.fields.FieldFieldsAccessor;
import org.boon.core.reflection.fields.FieldsAccessor;
import org.boon.core.reflection.fields.FieldsAccessorFieldThenProp;
import org.boon.core.reflection.fields.FieldsAccessorsPropertyThenField;
import org.boon.core.reflection.fields.PropertyFieldAccessor;
import org.boon.json.JsonSerializer;
import org.boon.json.serializers.ArraySerializer;
import org.boon.json.serializers.CustomFieldSerializer;
import org.boon.json.serializers.CustomObjectSerializer;
import org.boon.json.serializers.DateSerializer;
import org.boon.json.serializers.FieldFilter;
import org.boon.json.serializers.FieldSerializer;
import org.boon.json.serializers.ObjectSerializer;
import org.boon.json.serializers.impl.BasicObjectSerializerImpl;
import org.boon.json.serializers.impl.CollectionSerializerImpl;
import org.boon.json.serializers.impl.DateSerializerImpl;
import org.boon.json.serializers.impl.FieldSerializerImpl;
import org.boon.json.serializers.impl.FieldSerializerUseAnnotationsImpl;
import org.boon.json.serializers.impl.InstanceSerializerImpl;
import org.boon.json.serializers.impl.JsonDateSerializer;
import org.boon.json.serializers.impl.JsonSerializerImpl;
import org.boon.json.serializers.impl.JsonSimpleSerializerImpl;
import org.boon.json.serializers.impl.MapSerializerImpl;
import org.boon.json.serializers.impl.ObjectSerializationWithTypeInfo;
import org.boon.json.serializers.impl.StringSerializerImpl;
import org.boon.json.serializers.impl.UnknownSerializerImpl;

public class JsonSerializerFactory {
    private boolean outputType = false;
    private FieldAccessMode fieldAccessType = FieldAccessMode.FIELD;
    private boolean includeNulls = false;
    private boolean useAnnotations = false;
    private boolean includeEmpty = false;
    private boolean jsonFormatForDates = false;
    private boolean handleSimpleBackReference = true;
    private boolean handleComplexBackReference = false;
    private boolean includeDefault = false;
    private boolean cacheInstances = true;
    private String view;
    private List<FieldFilter> filterProperties = null;
    private List<CustomFieldSerializer> customFieldSerializers = null;
    private Map<Class, CustomObjectSerializer> customObjectSerializers = null;

    public JsonSerializer create() {
        FieldsAccessor fieldsAccessor;
        if (!(this.outputType || this.includeEmpty || this.includeNulls || this.useAnnotations || this.jsonFormatForDates || !this.handleSimpleBackReference || this.handleComplexBackReference || this.includeDefault || this.filterProperties != null || this.customFieldSerializers != null || this.customObjectSerializers != null || this.fieldAccessType != FieldAccessMode.FIELD)) {
            return new JsonSimpleSerializerImpl(this.view);
        }
        InstanceSerializerImpl instanceSerializer = new InstanceSerializerImpl();
        ObjectSerializer objectSerializer = !this.outputType ? new BasicObjectSerializerImpl() : new ObjectSerializationWithTypeInfo();
        StringSerializerImpl stringSerializer = new StringSerializerImpl();
        MapSerializerImpl mapSerializer = new MapSerializerImpl();
        FieldSerializer fieldSerializer = this.useAnnotations || this.includeNulls || this.includeEmpty || this.handleComplexBackReference || !this.includeDefault || this.view != null ? new FieldSerializerUseAnnotationsImpl(this.includeNulls, this.includeDefault, this.useAnnotations, this.includeEmpty, this.handleSimpleBackReference, this.handleComplexBackReference, this.customObjectSerializers, this.filterProperties, null, this.customFieldSerializers, this.view) : new FieldSerializerImpl();
        CollectionSerializerImpl collectionSerializer = new CollectionSerializerImpl();
        ArraySerializer arraySerializer = collectionSerializer;
        UnknownSerializerImpl unknownSerializer = new UnknownSerializerImpl();
        DateSerializer dateSerializer = this.jsonFormatForDates ? new JsonDateSerializer() : new DateSerializerImpl();
        switch (this.fieldAccessType) {
            case FIELD: {
                fieldsAccessor = new FieldFieldsAccessor(this.useAnnotations);
                break;
            }
            case PROPERTY: {
                fieldsAccessor = new PropertyFieldAccessor(this.useAnnotations);
                break;
            }
            case FIELD_THEN_PROPERTY: {
                fieldsAccessor = new FieldsAccessorFieldThenProp(this.useAnnotations);
                break;
            }
            case PROPERTY_THEN_FIELD: {
                fieldsAccessor = new FieldsAccessorsPropertyThenField(this.useAnnotations);
                break;
            }
            default: {
                fieldsAccessor = new FieldFieldsAccessor(this.useAnnotations);
            }
        }
        return new JsonSerializerImpl(objectSerializer, stringSerializer, mapSerializer, fieldSerializer, instanceSerializer, collectionSerializer, arraySerializer, unknownSerializer, dateSerializer, fieldsAccessor);
    }

    public JsonSerializerFactory addFilter(FieldFilter filter) {
        if (this.filterProperties == null) {
            this.filterProperties = new CopyOnWriteArrayList<FieldFilter>();
        }
        this.filterProperties.add(filter);
        return this;
    }

    public JsonSerializerFactory addPropertySerializer(CustomFieldSerializer serializer) {
        if (this.customFieldSerializers == null) {
            this.customFieldSerializers = new CopyOnWriteArrayList<CustomFieldSerializer>();
        }
        this.customFieldSerializers.add(serializer);
        return this;
    }

    public JsonSerializerFactory addTypeSerializer(Class<?> type, CustomObjectSerializer serializer) {
        if (this.customObjectSerializers == null) {
            this.customObjectSerializers = new ConcurrentHashMap<Class, CustomObjectSerializer>();
        }
        this.customObjectSerializers.put(type, serializer);
        return this;
    }

    public boolean isOutputType() {
        return this.outputType;
    }

    public JsonSerializerFactory setOutputType(boolean outputType) {
        this.outputType = outputType;
        return this;
    }

    public JsonSerializerFactory outputType() {
        this.outputType = true;
        return this;
    }

    public boolean isUsePropertiesFirst() {
        return this.fieldAccessType == FieldAccessMode.PROPERTY_THEN_FIELD;
    }

    public JsonSerializerFactory usePropertiesFirst() {
        this.fieldAccessType = FieldAccessMode.PROPERTY_THEN_FIELD;
        return this;
    }

    public boolean isUseFieldsFirst() {
        return this.fieldAccessType == FieldAccessMode.FIELD_THEN_PROPERTY;
    }

    public JsonSerializerFactory useFieldsFirst() {
        this.fieldAccessType = FieldAccessMode.FIELD_THEN_PROPERTY;
        return this;
    }

    public JsonSerializerFactory useFieldsOnly() {
        this.fieldAccessType = FieldAccessMode.FIELD;
        return this;
    }

    public JsonSerializerFactory usePropertyOnly() {
        this.fieldAccessType = FieldAccessMode.PROPERTY;
        return this;
    }

    public boolean isIncludeNulls() {
        return this.includeNulls;
    }

    public JsonSerializerFactory setIncludeNulls(boolean includeNulls) {
        this.includeNulls = includeNulls;
        return this;
    }

    public JsonSerializerFactory includeNulls() {
        this.includeNulls = true;
        return this;
    }

    public boolean isUseAnnotations() {
        return this.useAnnotations;
    }

    public JsonSerializerFactory setUseAnnotations(boolean useAnnotations) {
        this.useAnnotations = useAnnotations;
        return this;
    }

    public JsonSerializerFactory useAnnotations() {
        this.useAnnotations = true;
        return this;
    }

    public boolean isIncludeEmpty() {
        return this.includeEmpty;
    }

    public JsonSerializerFactory setIncludeEmpty(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
        return this;
    }

    public JsonSerializerFactory includeEmpty() {
        this.includeEmpty = true;
        return this;
    }

    public boolean isHandleSimpleBackReference() {
        return this.handleSimpleBackReference;
    }

    public JsonSerializerFactory setHandleSimpleBackReference(boolean handleSimpleBackReference) {
        this.handleSimpleBackReference = handleSimpleBackReference;
        return this;
    }

    public boolean isHandleComplexBackReference() {
        return this.handleComplexBackReference;
    }

    public JsonSerializerFactory setHandleComplexBackReference(boolean handleComplexBackReference) {
        this.handleComplexBackReference = handleComplexBackReference;
        return this;
    }

    public JsonSerializerFactory handleComplexBackReference() {
        this.handleComplexBackReference = true;
        return this;
    }

    public boolean isJsonFormatForDates() {
        return this.jsonFormatForDates;
    }

    public JsonSerializerFactory setJsonFormatForDates(boolean jsonFormatForDates) {
        this.jsonFormatForDates = jsonFormatForDates;
        return this;
    }

    public JsonSerializerFactory useJsonFormatForDates() {
        this.jsonFormatForDates = true;
        return this;
    }

    public boolean isIncludeDefault() {
        return this.includeDefault;
    }

    public JsonSerializerFactory setIncludeDefault(boolean includeDefault) {
        this.includeDefault = includeDefault;
        return this;
    }

    public JsonSerializerFactory includeDefaultValues() {
        this.includeDefault = true;
        return this;
    }

    public boolean isCacheInstances() {
        return this.cacheInstances;
    }

    public JsonSerializerFactory setCacheInstances(boolean cacheInstances) {
        this.cacheInstances = cacheInstances;
        return this;
    }

    public JsonSerializerFactory usedCacheInstances() {
        this.cacheInstances = true;
        return this;
    }

    public String getView() {
        return this.view;
    }

    public JsonSerializerFactory setView(String view) {
        this.view = view;
        return this;
    }
}

