/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.util.Arrays;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.Universal;
import org.boon.core.reflection.FastStringUtils;
import org.boon.primitive.CharBuf;
import org.boon.primitive.CharScanner;

public class Chr {
    public static final char[] DEFAULT_SPLIT = new char[]{' ', '\t', ',', ':', ';'};
    public static final char[] NEWLINE_CHARS = new char[]{'\n', '\r'};
    private static final char[] EMPTY_CHARS = new char[0];

    public static char[] arrayOfChar(int size) {
        return new char[size];
    }

    @Universal
    public static char[] array(char ... array) {
        return array;
    }

    @Universal
    public static char[] chars(String array) {
        return FastStringUtils.toCharArray(array);
    }

    @Universal
    public static int lengthOf(char[] array) {
        return Chr.len(array);
    }

    @Universal
    public static int len(char[] array) {
        return array.length;
    }

    @Universal
    public static char atIndex(char[] array, int index) {
        return Chr.idx(array, index);
    }

    @Universal
    public static char idx(char[] array, int index) {
        int i = Chr.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void atIndex(char[] array, int index, char value) {
        Chr.idx(array, index, value);
    }

    @Universal
    public static void idx(char[] array, int index, char value) {
        int i = Chr.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static void atIndex(char[] array, int index, char[] input) {
        Chr.idx(array, index, input);
    }

    @Universal
    public static void idx(char[] array, int index, char[] input) {
        int i = Chr.calculateIndex(array, index);
        Chr._idx(array, i, input);
    }

    @Universal
    public static char[] sliceOf(char[] array, int startIndex, int endIndex) {
        return Chr.slc(array, startIndex, endIndex);
    }

    @Universal
    public static char[] slc(char[] array, int startIndex, int endIndex) {
        int start = Chr.calculateIndex(array, startIndex);
        int end = Chr.calculateEndIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            return EMPTY_CHARS;
        }
        char[] newArray = new char[newLength];
        Chr.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static char[] sliceOf(char[] array, int startIndex) {
        return Chr.slc(array, startIndex);
    }

    @Universal
    public static char[] slc(char[] array, int startIndex) {
        int start = Chr.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        char[] newArray = new char[newLength];
        Chr.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static char[] endSliceOf(char[] array, int endIndex) {
        return Chr.slcEnd(array, endIndex);
    }

    @Universal
    public static char[] slcEnd(char[] array, int endIndex) {
        int end = Chr.calculateEndIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        char[] newArray = new char[newLength];
        Chr.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(char value, char[] array) {
        for (char currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static boolean in(char[] values, char[] array) {
        for (char currentValue : array) {
            for (char value : values) {
                if (currentValue != value) continue;
                return true;
            }
        }
        return false;
    }

    @Universal
    public static boolean in(int value, char[] array) {
        for (char currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static boolean in(char value, int offset, char[] array) {
        for (int index = offset; index < array.length; ++index) {
            char currentValue = array[index];
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static boolean in(char value, int offset, int end, char[] array) {
        for (int index = offset; index < end; ++index) {
            char currentValue = array[index];
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    public static char[] grow(char[] array, int size) {
        char[] newArray = new char[array.length + size];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static char[] grow(char[] array) {
        char[] newArray = new char[(array.length + 1) * 2];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static char[] shrink(char[] array, int size) {
        char[] newArray = new char[array.length - size];
        Chr.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static char[] compact(char[] array) {
        int nullCount = 0;
        for (char ch : array) {
            if (ch != '\u0000') continue;
            ++nullCount;
        }
        char[] newArray = new char[array.length - nullCount];
        int j = 0;
        for (char ch : array) {
            if (ch == '\u0000') continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static char[] remove(char c, char[] array) {
        int removeCount = 0;
        for (char ch : array) {
            if (ch != c) continue;
            ++removeCount;
        }
        char[] newArray = new char[array.length - removeCount];
        int j = 0;
        for (char ch : array) {
            if (ch == c) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static char[] remove(char c, char[] array, int start, int to) {
        int removeCount = 0;
        for (int index = start; index < to; ++index) {
            char ch = array[index];
            if (ch != c) continue;
            ++removeCount;
        }
        char[] newArray = new char[array.length - removeCount];
        int j = 0;
        for (int index = start; index < to; ++index) {
            char ch = array[index];
            if (ch == c) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static char[][] split(char[] chars) {
        return CharScanner.splitByChars(chars, DEFAULT_SPLIT);
    }

    public static char[][] splitLine(char[] chars) {
        return CharScanner.splitByChars(chars, NEWLINE_CHARS);
    }

    @Universal
    public static char[] copy(char[] array) {
        Exceptions.requireNonNull(array);
        char[] newArray = new char[array.length];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static char[] copy(char[] array, int offset, int length) {
        char[] newArray = new char[length];
        Chr.arraycopy(array, offset, newArray, 0, length);
        return newArray;
    }

    @Universal
    public static char[] add(char[] array, char v) {
        Exceptions.requireNonNull(array);
        char[] newArray = new char[array.length + 1];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static char[] add(char[] array, String str) {
        return Chr.add(array, str.toCharArray());
    }

    @Universal
    public static char[] add(char[] array, StringBuilder stringBuilder) {
        return Chr.add(array, Chr.getCharsFromStringBuilder(stringBuilder));
    }

    @Universal
    public static char[] add(char[] array, char[] array2) {
        char[] newArray = new char[array.length + array2.length];
        Chr.arraycopy(array, 0, newArray, 0, array.length);
        Chr.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static char[] insert(char[] array, int idx, char v) {
        Exceptions.requireNonNull(array);
        if (idx >= array.length) {
            return Chr.add(array, v);
        }
        int index = Chr.calculateIndex(array, idx);
        char[] newArray = new char[array.length + 1];
        if (index != 0) {
            Chr.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            Chr.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            Chr.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static char[] insert(char[] array, int fromIndex, String values) {
        return Chr.insert(array, fromIndex, values.toCharArray());
    }

    @Universal
    public static char[] insert(char[] array, int fromIndex, StringBuilder values) {
        return Chr.insert(array, fromIndex, Chr.getCharsFromStringBuilder(values));
    }

    @Universal
    public static char[] insert(char[] array, int fromIndex, char[] values) {
        Exceptions.requireNonNull(array);
        if (fromIndex >= array.length) {
            return Chr.add(array, values);
        }
        int index = Chr.calculateIndex(array, fromIndex);
        char[] newArray = new char[array.length + values.length];
        if (index != 0) {
            Chr.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            Chr.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            Chr.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static char[] getCharsFromStringBuilder(StringBuilder sbuf) {
        int length = sbuf.length();
        char[] array2 = new char[sbuf.length()];
        sbuf.getChars(0, sbuf.length(), array2, 0);
        return array2;
    }

    private static int calculateIndex(char[] array, int originalIndex) {
        int length = array.length;
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    private static int calculateEndIndex(char[] array, int originalIndex) {
        int length = array.length;
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        return index;
    }

    public static char[] rpad(char[] in, int size, char pad) {
        if (in.length >= size) {
            return in;
        }
        int index = 0;
        char[] newArray = new char[size];
        for (index = 0; index < in.length; ++index) {
            newArray[index] = in[index];
        }
        while (index < size) {
            newArray[index] = pad;
            ++index;
        }
        return newArray;
    }

    public static char[] lpad(char[] in, int size, char pad) {
        int index;
        if (in.length >= size) {
            return in;
        }
        int delta = size - in.length;
        char[] newArray = new char[size];
        for (index = 0; index < delta; ++index) {
            newArray[index] = pad;
        }
        for (int index2 = 0; index2 < in.length; ++index2) {
            newArray[index] = in[index2];
            ++index;
        }
        return newArray;
    }

    public static char[] underBarCase(char[] in) {
        int index;
        if (in == null || in.length == 0 || in.length == 1) {
            return in;
        }
        char[] out = null;
        int count = 0;
        boolean wasLower = false;
        for (index = 0; index < in.length; ++index) {
            char ch = in[index];
            boolean isUpper = Character.isUpperCase(ch);
            if (wasLower && isUpper) {
                ++count;
            }
            wasLower = Character.isLowerCase(ch);
        }
        out = new char[in.length + count];
        wasLower = false;
        index = 0;
        int secondIndex = 0;
        while (index < in.length) {
            char ch = in[index];
            boolean isUpper = Character.isUpperCase(ch);
            if (wasLower && isUpper) {
                out[secondIndex] = 95;
                ++secondIndex;
            }
            out[secondIndex] = ch == ' ' || ch == '-' || ch == '\t' || ch == '.' ? 95 : Character.toUpperCase(ch);
            wasLower = Character.isLowerCase(ch);
            ++index;
            ++secondIndex;
        }
        return out;
    }

    public static char[] camelCase(char[] in, boolean upper) {
        if (in == null || in.length == 0 || in.length == 1) {
            return in;
        }
        char[] out = null;
        int count = 0;
        for (int index = 0; index < in.length; ++index) {
            char ch = in[index];
            if (ch != '_' && ch != ' ' && ch != '\t') continue;
            ++count;
        }
        out = new char[in.length - count];
        boolean upperNext = false;
        int secondIndex = 0;
        for (int index = 0; index < in.length; ++index) {
            char ch = in[index];
            if (ch == '_' || ch == ' ' || ch == '\t') {
                upperNext = true;
                continue;
            }
            out[secondIndex] = upperNext ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
            upperNext = false;
            ++secondIndex;
        }
        out[0] = upper ? Character.toUpperCase(out[0]) : Character.toLowerCase(out[0]);
        return out;
    }

    public static char[][] split(char[] inputArray, char split) {
        return CharScanner.split(inputArray, split);
    }

    public static boolean contains(char[] chars, char c) {
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (ch != c) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] chars, char c, int start, int length) {
        int to = length + start;
        for (int index = start; index < to; ++index) {
            char ch = chars[index];
            if (ch != c) continue;
            return true;
        }
        return false;
    }

    public static void _idx(char[] buffer, int location, byte[] chars) {
        int index2 = 0;
        int endLocation = location + chars.length;
        int index = location;
        while (index < endLocation) {
            buffer[index] = (char)chars[index2];
            ++index;
            ++index2;
        }
    }

    public static void _idx(char[] array, int startIndex, char[] input) {
        try {
            Chr.arraycopy(input, 0, array, startIndex, input.length);
        }
        catch (Exception ex) {
            Exceptions.handle(String.format("array size %d, startIndex %d, input length %d", array.length, startIndex, input.length), (Throwable)ex);
        }
    }

    private static void arraycopy(char[] src, int srcPos, char[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public static void _idx(char[] array, int startIndex, char[] input, int inputLength) {
        try {
            Chr.arraycopy(input, 0, array, startIndex, inputLength);
        }
        catch (Exception ex) {
            Exceptions.handle(String.format("array size %d, startIndex %d, input length %d", array.length, startIndex, input.length), (Throwable)ex);
        }
    }

    public static void _idx(char[] buffer, int location, byte[] chars, int start, int end) {
        int index2 = start;
        int endLocation = location + (end - start);
        int index = location;
        while (index < endLocation) {
            buffer[index] = (char)chars[index2];
            ++index;
            ++index2;
        }
    }

    public static char[] trim(char[] buffer, int start, int to) {
        while (start < to && buffer[start] <= ' ') {
            ++start;
        }
        while (start < to && buffer[to - 1] <= ' ') {
            --to;
        }
        return start > 0 || to < buffer.length ? Arrays.copyOfRange(buffer, start, to) : buffer;
    }

    public static boolean equals(char[] chars1, char[] chars2) {
        if (chars1 == null && chars2 == null) {
            return true;
        }
        if (chars1 == null || chars2 == null) {
            return false;
        }
        if (chars1.length != chars2.length) {
            return false;
        }
        for (int index = 0; index < chars1.length; ++index) {
            if (chars1[index] == chars2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsNoNullCheck(char[] chars1, char[] chars2) {
        if (chars1.length != chars2.length) {
            return false;
        }
        for (int index = 0; index < chars1.length; ++index) {
            if (chars1[index] == chars2[index]) continue;
            return false;
        }
        return true;
    }

    public static char[] add(char[] ... strings) {
        int length = 0;
        for (char[] str : strings) {
            if (str == null) continue;
            length += str.length;
        }
        CharBuf builder = CharBuf.createExact(length);
        for (char[] str : strings) {
            if (str == null) continue;
            builder.add(str);
        }
        return builder.toCharArray();
    }

    public static char[][] splitLines(char[] chars) {
        return CharScanner.splitLines(chars);
    }

    public static char[][] splitComma(char[] chars) {
        return CharScanner.splitComma(chars);
    }

    public static void equalsOrDie(char[] ac, char[] bc) {
        char a = '\u0000';
        char b = '\u0000';
        int indexOfDiff = -1;
        int indexOfLine = 0;
        for (int index = 0; index < ac.length && index < bc.length; ++index) {
            a = ac[index];
            b = bc[index];
            if (a == '\n' || b == '\n') {
                ++indexOfLine;
            }
            if (a == b) continue;
            indexOfDiff = index;
            break;
        }
        if (ac.length != bc.length) {
            int n = indexOfDiff = ac.length < bc.length ? ac.length : bc.length;
        }
        if (indexOfDiff != -1) {
            CharBuf charBuf = CharBuf.create(ac.length + bc.length + 128);
            charBuf.add("Strings are different. Problem at line ").add(indexOfLine).addLine(".");
            charBuf.add("String A length = ").add(ac.length).addLine().add("<START>").add(ac).add("<END>").addLine().addLine("--- end a ---");
            charBuf.add("String B length = ").add(bc.length).addLine().add("<START>").add(bc).add("<END>").addLine().addLine("--- end b ---");
            char[] ac1 = null;
            try {
                ac1 = Chr.sliceOf(ac, indexOfDiff - 20, ac.length - indexOfDiff > 40 ? indexOfDiff + 10 : ac.length + 1);
            }
            catch (Exception ex) {
                ac1 = ac;
            }
            char[] bc1 = null;
            try {
                bc1 = Chr.sliceOf(bc, indexOfDiff - 20, bc.length - indexOfDiff > 40 ? indexOfDiff + 10 : bc.length + 1);
            }
            catch (Exception ex) {
                ac1 = bc;
            }
            CharBuf charBufA = CharBuf.create(ac1.length + 20);
            CharBuf charBufB = CharBuf.create(bc1.length + 20);
            boolean found = false;
            indexOfDiff = 0;
            for (int index = 0; index < ac1.length || index < bc1.length; ++index) {
                if (index < ac1.length) {
                    a = ac1[index];
                    Chr.charDescription(a, charBufA);
                }
                if (index < bc1.length) {
                    b = bc1[index];
                    Chr.charDescription(b, charBufB);
                }
                if (a == b || found) continue;
                found = true;
                indexOfDiff = charBufA.len();
            }
            charBuf.puts(Chr.multiply('-', 10), "area of concern, line=", indexOfLine, Chr.multiply('-', 10));
            charBuf.addLine(charBufA);
            charBuf.multiply('-', indexOfDiff).addLine("^");
            charBuf.addLine(charBufB);
            charBuf.multiply('-', indexOfDiff).addLine("^");
            Boon.puts(charBuf);
            Exceptions.die(charBuf);
        }
    }

    private static void charDescription(char a, CharBuf charBufA) {
        if (a == '\n') {
            charBufA.add(" <NEWLINE> ");
        } else if (a == '\r') {
            charBufA.add(" <CARRIAGE_RETURN> ");
        } else if (a == '\t') {
            charBufA.add(" <TAB> ");
        } else {
            charBufA.add(a);
        }
    }

    public static char[] multiply(char c, int len) {
        char[] out = new char[len];
        for (int index = 0; index < len; ++index) {
            out[index] = c;
        }
        return out;
    }

    public static boolean insideOf(char[] startsWith, char[] chars, char[] endsWith) {
        if (startsWith.length + endsWith.length > chars.length) {
            return false;
        }
        int index = 0;
        if (startsWith.length > 0) {
            if (startsWith[startsWith.length - 1] != chars[startsWith.length - 1]) {
                return false;
            }
            if (startsWith[index] == chars[index]) {
                ++index;
            } else {
                return false;
            }
        }
        int endIndex = chars.length - 1;
        if (endsWith.length > 0) {
            if (endsWith[startsWith.length - 1] == chars[endIndex]) {
                --endIndex;
            } else {
                return false;
            }
        }
        while (index < startsWith.length - 2) {
            if (chars[index] != startsWith[index]) {
                return false;
            }
            ++index;
        }
        for (int i = endsWith.length - 2; i > 0; --i) {
            if (chars[endIndex] != endsWith[i]) {
                return false;
            }
            --endIndex;
        }
        return true;
    }
}

