/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.InvalidOpcodeException;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;
import net.razorvine.pickle.PythonException;
import net.razorvine.pickle.UnpickleStack;
import net.razorvine.pickle.objects.AnyClassConstructor;
import net.razorvine.pickle.objects.ArrayConstructor;
import net.razorvine.pickle.objects.ByteArrayConstructor;
import net.razorvine.pickle.objects.ClassDictConstructor;
import net.razorvine.pickle.objects.ComplexNumber;
import net.razorvine.pickle.objects.DateTimeConstructor;
import net.razorvine.pickle.objects.OperatorAttrGetterForCalendarTz;
import net.razorvine.pickle.objects.Reconstructor;
import net.razorvine.pickle.objects.SetConstructor;
import net.razorvine.pickle.objects.TimeZoneConstructor;

public class Unpickler {
    private static final Object NO_RETURN_VALUE = new Object();
    private final int HIGHEST_PROTOCOL = 4;
    private Map<Integer, Object> memo = new HashMap<Integer, Object>();
    protected UnpickleStack stack;
    private InputStream input;
    private static Map<String, IObjectConstructor> objectConstructors = new HashMap<String, IObjectConstructor>();

    public static void registerConstructor(String module, String classname, IObjectConstructor constructor) {
        objectConstructors.put(module + "." + classname, constructor);
    }

    public Object load(InputStream stream) throws PickleException, IOException {
        short key;
        Object value;
        this.stack = new UnpickleStack();
        this.input = stream;
        do {
            if ((key = PickleUtils.readbyte(this.input)) != -1) continue;
            throw new IOException("premature end of file");
        } while ((value = this.dispatch(key)) == NO_RETURN_VALUE);
        return value;
    }

    public Object loads(byte[] pickledata) throws PickleException, IOException {
        return this.load(new ByteArrayInputStream(pickledata));
    }

    public void close() {
        if (this.stack != null) {
            this.stack.clear();
        }
        if (this.memo != null) {
            this.memo.clear();
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Object dispatch(short key) throws PickleException, IOException {
        switch (key) {
            case 40: {
                this.load_mark();
                break;
            }
            case 46: {
                Object value = this.stack.pop();
                this.stack.clear();
                return value;
            }
            case 48: {
                this.load_pop();
                break;
            }
            case 49: {
                this.load_pop_mark();
                break;
            }
            case 50: {
                this.load_dup();
                break;
            }
            case 70: {
                this.load_float();
                break;
            }
            case 73: {
                this.load_int();
                break;
            }
            case 74: {
                this.load_binint();
                break;
            }
            case 75: {
                this.load_binint1();
                break;
            }
            case 76: {
                this.load_long();
                break;
            }
            case 77: {
                this.load_binint2();
                break;
            }
            case 78: {
                this.load_none();
                break;
            }
            case 80: {
                throw new InvalidOpcodeException("opcode not implemented: PERSID");
            }
            case 81: {
                throw new InvalidOpcodeException("opcode not implemented: BINPERSID");
            }
            case 82: {
                this.load_reduce();
                break;
            }
            case 83: {
                this.load_string();
                break;
            }
            case 84: {
                this.load_binstring();
                break;
            }
            case 85: {
                this.load_short_binstring();
                break;
            }
            case 86: {
                this.load_unicode();
                break;
            }
            case 88: {
                this.load_binunicode();
                break;
            }
            case 97: {
                this.load_append();
                break;
            }
            case 98: {
                this.load_build();
                break;
            }
            case 99: {
                this.load_global();
                break;
            }
            case 100: {
                this.load_dict();
                break;
            }
            case 125: {
                this.load_empty_dictionary();
                break;
            }
            case 101: {
                this.load_appends();
                break;
            }
            case 103: {
                this.load_get();
                break;
            }
            case 104: {
                this.load_binget();
                break;
            }
            case 105: {
                throw new InvalidOpcodeException("opcode not implemented: INST");
            }
            case 106: {
                this.load_long_binget();
                break;
            }
            case 108: {
                this.load_list();
                break;
            }
            case 93: {
                this.load_empty_list();
                break;
            }
            case 111: {
                throw new InvalidOpcodeException("opcode not implemented: OBJ");
            }
            case 112: {
                this.load_put();
                break;
            }
            case 113: {
                this.load_binput();
                break;
            }
            case 114: {
                this.load_long_binput();
                break;
            }
            case 115: {
                this.load_setitem();
                break;
            }
            case 116: {
                this.load_tuple();
                break;
            }
            case 41: {
                this.load_empty_tuple();
                break;
            }
            case 117: {
                this.load_setitems();
                break;
            }
            case 71: {
                this.load_binfloat();
                break;
            }
            case 128: {
                this.load_proto();
                break;
            }
            case 129: {
                this.load_newobj();
                break;
            }
            case 130: {
                throw new InvalidOpcodeException("opcode not implemented: EXT1");
            }
            case 131: {
                throw new InvalidOpcodeException("opcode not implemented: EXT2");
            }
            case 132: {
                throw new InvalidOpcodeException("opcode not implemented: EXT4");
            }
            case 133: {
                this.load_tuple1();
                break;
            }
            case 134: {
                this.load_tuple2();
                break;
            }
            case 135: {
                this.load_tuple3();
                break;
            }
            case 136: {
                this.load_true();
                break;
            }
            case 137: {
                this.load_false();
                break;
            }
            case 138: {
                this.load_long1();
                break;
            }
            case 139: {
                this.load_long4();
                break;
            }
            case 66: {
                this.load_binbytes();
                break;
            }
            case 67: {
                this.load_short_binbytes();
                break;
            }
            case 141: {
                this.load_binunicode8();
                break;
            }
            case 140: {
                this.load_short_binunicode();
                break;
            }
            case 142: {
                this.load_binbytes8();
                break;
            }
            case 143: {
                this.load_empty_set();
                break;
            }
            case 144: {
                this.load_additems();
                break;
            }
            case 145: {
                this.load_frozenset();
                break;
            }
            case 148: {
                this.load_memoize();
                break;
            }
            case 149: {
                this.load_frame();
                break;
            }
            case 146: {
                this.load_newobj_ex();
                break;
            }
            case 147: {
                this.load_stack_global();
                break;
            }
            default: {
                throw new InvalidOpcodeException("invalid pickle opcode: " + key);
            }
        }
        return NO_RETURN_VALUE;
    }

    void load_build() {
        Object args = this.stack.pop();
        Object target = this.stack.peek();
        try {
            Method setStateMethod = target.getClass().getMethod("__setstate__", args.getClass());
            setStateMethod.invoke(target, args);
        }
        catch (Exception e) {
            throw new PickleException("failed to __setstate__()", e);
        }
    }

    void load_proto() throws IOException {
        short proto = PickleUtils.readbyte(this.input);
        if (proto < 0 || proto > 4) {
            throw new PickleException("unsupported pickle protocol: " + proto);
        }
    }

    void load_none() {
        this.stack.add(null);
    }

    void load_false() {
        this.stack.add(false);
    }

    void load_true() {
        this.stack.add(true);
    }

    void load_int() throws IOException {
        Comparable<Boolean> val;
        String data = PickleUtils.readline(this.input, true);
        if (data.equals("I00\n".substring(1))) {
            val = false;
        } else if (data.equals("I01\n".substring(1))) {
            val = true;
        } else {
            String number = data.substring(0, data.length() - 1);
            try {
                val = Integer.parseInt(number, 10);
            }
            catch (NumberFormatException x) {
                val = Long.parseLong(number, 10);
            }
        }
        this.stack.add(val);
    }

    void load_binint() throws IOException {
        int integer = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        this.stack.add(integer);
    }

    void load_binint1() throws IOException {
        this.stack.add(PickleUtils.readbyte(this.input));
    }

    void load_binint2() throws IOException {
        int integer = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 2));
        this.stack.add(integer);
    }

    void load_long() throws IOException {
        String val = PickleUtils.readline(this.input);
        if (val != null && val.endsWith("L")) {
            val = val.substring(0, val.length() - 1);
        }
        BigInteger bi = new BigInteger(val);
        this.stack.add(PickleUtils.optimizeBigint(bi));
    }

    void load_long1() throws IOException {
        short n = PickleUtils.readbyte(this.input);
        byte[] data = PickleUtils.readbytes(this.input, n);
        this.stack.add(PickleUtils.decode_long(data));
    }

    void load_long4() throws IOException {
        int n = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        byte[] data = PickleUtils.readbytes(this.input, n);
        this.stack.add(PickleUtils.decode_long(data));
    }

    void load_float() throws IOException {
        String val = PickleUtils.readline(this.input, true);
        this.stack.add(Double.parseDouble(val));
    }

    void load_binfloat() throws IOException {
        double val = PickleUtils.bytes_to_double(PickleUtils.readbytes(this.input, 8), 0);
        this.stack.add(val);
    }

    void load_string() throws IOException {
        String rep = PickleUtils.readline(this.input);
        boolean quotesOk = false;
        for (String q : new String[]{"\"", "'"}) {
            if (!rep.startsWith(q)) continue;
            if (!rep.endsWith(q)) {
                throw new PickleException("insecure string pickle");
            }
            rep = rep.substring(1, rep.length() - 1);
            quotesOk = true;
            break;
        }
        if (!quotesOk) {
            throw new PickleException("insecure string pickle");
        }
        this.stack.add(PickleUtils.decode_escaped(rep));
    }

    void load_binstring() throws IOException {
        int len = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        byte[] data = PickleUtils.readbytes(this.input, len);
        this.stack.add(PickleUtils.rawStringFromBytes(data));
    }

    void load_binbytes() throws IOException {
        int len = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        this.stack.add(PickleUtils.readbytes(this.input, len));
    }

    void load_binbytes8() throws IOException {
        long len = PickleUtils.bytes_to_long(PickleUtils.readbytes(this.input, 8), 0);
        this.stack.add(PickleUtils.readbytes(this.input, len));
    }

    void load_unicode() throws IOException {
        String str = PickleUtils.decode_unicode_escaped(PickleUtils.readline(this.input));
        this.stack.add(str);
    }

    void load_binunicode() throws IOException {
        int len = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        byte[] data = PickleUtils.readbytes(this.input, len);
        this.stack.add(new String(data, "UTF-8"));
    }

    void load_binunicode8() throws IOException {
        long len = PickleUtils.bytes_to_long(PickleUtils.readbytes(this.input, 8), 0);
        byte[] data = PickleUtils.readbytes(this.input, len);
        this.stack.add(new String(data, "UTF-8"));
    }

    void load_short_binunicode() throws IOException {
        short len = PickleUtils.readbyte(this.input);
        byte[] data = PickleUtils.readbytes(this.input, len);
        this.stack.add(new String(data, "UTF-8"));
    }

    void load_short_binstring() throws IOException {
        short len = PickleUtils.readbyte(this.input);
        byte[] data = PickleUtils.readbytes(this.input, len);
        this.stack.add(PickleUtils.rawStringFromBytes(data));
    }

    void load_short_binbytes() throws IOException {
        short len = PickleUtils.readbyte(this.input);
        this.stack.add(PickleUtils.readbytes(this.input, len));
    }

    void load_tuple() {
        ArrayList<Object> top = this.stack.pop_all_since_marker();
        this.stack.add(top.toArray());
    }

    void load_empty_tuple() {
        this.stack.add(new Object[0]);
    }

    void load_tuple1() {
        this.stack.add(new Object[]{this.stack.pop()});
    }

    void load_tuple2() {
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        this.stack.add(new Object[]{o1, o2});
    }

    void load_tuple3() {
        Object o3 = this.stack.pop();
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        this.stack.add(new Object[]{o1, o2, o3});
    }

    void load_empty_list() {
        this.stack.add(new ArrayList(0));
    }

    void load_empty_dictionary() {
        this.stack.add(new HashMap(0));
    }

    void load_empty_set() {
        this.stack.add(new HashSet());
    }

    void load_list() {
        ArrayList<Object> top = this.stack.pop_all_since_marker();
        this.stack.add(top);
    }

    void load_dict() {
        ArrayList<Object> top = this.stack.pop_all_since_marker();
        HashMap<Object, Object> map = new HashMap<Object, Object>(top.size());
        for (int i = 0; i < top.size(); i += 2) {
            Object key = top.get(i);
            Object value = top.get(i + 1);
            map.put(key, value);
        }
        this.stack.add(map);
    }

    void load_frozenset() {
        ArrayList<Object> top = this.stack.pop_all_since_marker();
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(top);
        this.stack.add(set);
    }

    void load_additems() {
        ArrayList<Object> top = this.stack.pop_all_since_marker();
        HashSet set = (HashSet)this.stack.pop();
        set.addAll(top);
        this.stack.add(set);
    }

    void load_global() throws IOException {
        String module = PickleUtils.readline(this.input);
        String name = PickleUtils.readline(this.input);
        this.load_global_sub(module, name);
    }

    void load_stack_global() {
        String name = (String)this.stack.pop();
        String module = (String)this.stack.pop();
        this.load_global_sub(module, name);
    }

    void load_global_sub(String module, String name) {
        IObjectConstructor constructor = objectConstructors.get(module + "." + name);
        if (constructor == null) {
            constructor = module.equals("exceptions") ? new AnyClassConstructor(PythonException.class) : (module.equals("builtins") || module.equals("__builtin__") ? (name.endsWith("Error") || name.endsWith("Warning") || name.endsWith("Exception") || name.equals("GeneratorExit") || name.equals("KeyboardInterrupt") || name.equals("StopIteration") || name.equals("SystemExit") ? new AnyClassConstructor(PythonException.class) : new ClassDictConstructor(module, name)) : new ClassDictConstructor(module, name));
        }
        this.stack.add(constructor);
    }

    void load_pop() {
        this.stack.pop();
    }

    void load_pop_mark() {
        Object o = null;
        while ((o = this.stack.pop()) != this.stack.MARKER) {
        }
        this.stack.trim();
    }

    void load_dup() {
        this.stack.add(this.stack.peek());
    }

    void load_get() throws IOException {
        int i = Integer.parseInt(PickleUtils.readline(this.input), 10);
        if (!this.memo.containsKey(i)) {
            throw new PickleException("invalid memo key");
        }
        this.stack.add(this.memo.get(i));
    }

    void load_binget() throws IOException {
        short i = PickleUtils.readbyte(this.input);
        if (!this.memo.containsKey(i)) {
            throw new PickleException("invalid memo key");
        }
        this.stack.add(this.memo.get(i));
    }

    void load_long_binget() throws IOException {
        int i = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        if (!this.memo.containsKey(i)) {
            throw new PickleException("invalid memo key");
        }
        this.stack.add(this.memo.get(i));
    }

    void load_put() throws IOException {
        int i = Integer.parseInt(PickleUtils.readline(this.input), 10);
        this.memo.put(i, this.stack.peek());
    }

    void load_binput() throws IOException {
        short i = PickleUtils.readbyte(this.input);
        this.memo.put(Integer.valueOf(i), this.stack.peek());
    }

    void load_long_binput() throws IOException {
        int i = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        this.memo.put(i, this.stack.peek());
    }

    void load_memoize() {
        this.memo.put(this.memo.size(), this.stack.peek());
    }

    void load_append() {
        Object value = this.stack.pop();
        ArrayList list = (ArrayList)this.stack.peek();
        list.add(value);
    }

    void load_appends() {
        ArrayList<Object> top = this.stack.pop_all_since_marker();
        ArrayList list = (ArrayList)this.stack.peek();
        list.addAll(top);
        list.trimToSize();
    }

    void load_setitem() {
        Object value = this.stack.pop();
        Object key = this.stack.pop();
        Map dict = (Map)this.stack.peek();
        dict.put(key, value);
    }

    void load_setitems() {
        HashMap<Object, Object> newitems = new HashMap<Object, Object>();
        Object value = this.stack.pop();
        while (value != this.stack.MARKER) {
            Object key = this.stack.pop();
            newitems.put(key, value);
            value = this.stack.pop();
        }
        Map dict = (Map)this.stack.peek();
        dict.putAll(newitems);
    }

    void load_mark() {
        this.stack.add_mark();
    }

    void load_reduce() {
        Object[] args = (Object[])this.stack.pop();
        IObjectConstructor constructor = (IObjectConstructor)this.stack.pop();
        this.stack.add(constructor.construct(args));
    }

    void load_newobj() {
        this.load_reduce();
    }

    void load_newobj_ex() {
        HashMap kwargs = (HashMap)this.stack.pop();
        Object[] args = (Object[])this.stack.pop();
        IObjectConstructor constructor = (IObjectConstructor)this.stack.pop();
        if (kwargs.size() != 0) {
            throw new PickleException("newobj_ex with keyword arguments not supported");
        }
        this.stack.add(constructor.construct(args));
    }

    void load_frame() throws IOException {
        PickleUtils.readbytes(this.input, 8);
    }

    static {
        objectConstructors.put("__builtin__.complex", new AnyClassConstructor(ComplexNumber.class));
        objectConstructors.put("builtins.complex", new AnyClassConstructor(ComplexNumber.class));
        objectConstructors.put("array.array", new ArrayConstructor());
        objectConstructors.put("array._array_reconstructor", new ArrayConstructor());
        objectConstructors.put("__builtin__.bytearray", new ByteArrayConstructor());
        objectConstructors.put("builtins.bytearray", new ByteArrayConstructor());
        objectConstructors.put("__builtin__.bytes", new ByteArrayConstructor());
        objectConstructors.put("__builtin__.set", new SetConstructor());
        objectConstructors.put("builtins.set", new SetConstructor());
        objectConstructors.put("datetime.datetime", new DateTimeConstructor(DateTimeConstructor.DATETIME));
        objectConstructors.put("datetime.time", new DateTimeConstructor(DateTimeConstructor.TIME));
        objectConstructors.put("datetime.date", new DateTimeConstructor(DateTimeConstructor.DATE));
        objectConstructors.put("datetime.timedelta", new DateTimeConstructor(DateTimeConstructor.TIMEDELTA));
        objectConstructors.put("pytz._UTC", new TimeZoneConstructor(TimeZoneConstructor.UTC));
        objectConstructors.put("pytz._p", new TimeZoneConstructor(TimeZoneConstructor.PYTZ));
        objectConstructors.put("pytz.timezone", new TimeZoneConstructor(TimeZoneConstructor.PYTZ));
        objectConstructors.put("dateutil.tz.tzutc", new TimeZoneConstructor(TimeZoneConstructor.DATEUTIL_TZUTC));
        objectConstructors.put("dateutil.tz.tzfile", new TimeZoneConstructor(TimeZoneConstructor.DATEUTIL_TZFILE));
        objectConstructors.put("dateutil.zoneinfo.gettz", new TimeZoneConstructor(TimeZoneConstructor.DATEUTIL_GETTZ));
        objectConstructors.put("datetime.tzinfo", new TimeZoneConstructor(TimeZoneConstructor.TZINFO));
        objectConstructors.put("decimal.Decimal", new AnyClassConstructor(BigDecimal.class));
        objectConstructors.put("copy_reg._reconstructor", new Reconstructor());
        objectConstructors.put("operator.attrgetter", new OperatorAttrGetterForCalendarTz());
        objectConstructors.put("_codecs.encode", new ByteArrayConstructor());
    }
}

