/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss;

import com.etsy.net.UnixDomainSocketClient;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.ArmoredOutputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.InvalidCipherTextException;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.AESWrapEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.paddings.PKCS7Padding;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.KeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPKeyRing;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPLiteralData;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPObjectFactory;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPUtil;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CryptoHelper {
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256WithRSA";
    private static final String SSH_DSS_PREFIX = "ssh-dss";
    private static final String SSH_RSA_PREFIX = "ssh-rsa";
    private static SecureRandom sr = null;

    public static SecureRandom getSecureRandom() {
        return sr;
    }

    public static byte[] padPKCS7(int alignment, byte[] data, int offset, int len) {
        byte[] target = new byte[len + (alignment - len % alignment)];
        System.arraycopy(data, offset, target, 0, len);
        PKCS7Padding padding = new PKCS7Padding();
        padding.addPadding(target, len);
        return target;
    }

    public static byte[] padPKCS7(int alignment, byte[] data) {
        return CryptoHelper.padPKCS7(alignment, data, 0, data.length);
    }

    public static byte[] unpadPKCS7(byte[] padded) throws InvalidCipherTextException {
        PKCS7Padding padding = new PKCS7Padding();
        int pad = padding.padCount(padded);
        byte[] unpadded = new byte[padded.length - pad];
        System.arraycopy(padded, 0, unpadded, 0, padded.length - pad);
        return unpadded;
    }

    public static byte[] wrapAES(byte[] key, byte[] data, int offset, int len, boolean nonce) {
        AESWrapEngine aes = new AESWrapEngine();
        KeyParameter keyparam = new KeyParameter(key);
        aes.init(true, keyparam);
        if (nonce) {
            byte[] nonced = new byte[len + 8];
            byte[] noncebytes = new byte[8];
            CryptoHelper.getSecureRandom().nextBytes(noncebytes);
            System.arraycopy(noncebytes, 0, nonced, 0, 8);
            System.arraycopy(data, offset, nonced, 8, len);
            data = nonced;
            offset = 0;
            len = data.length;
        }
        byte[] padded = CryptoHelper.padPKCS7(8, data, offset, len);
        return aes.wrap(padded, 0, padded.length);
    }

    public static byte[] wrapAES(byte[] key, byte[] data) {
        return CryptoHelper.wrapAES(key, data, 0, data.length, false);
    }

    public static byte[] secureWrapAES(byte[] key, byte[] data) {
        byte[] wrapped = CryptoHelper.wrapAES(key, data);
        Arrays.fill(key, (byte)0);
        return wrapped;
    }

    public static byte[] wrapBlob(byte[] key, byte[] blob) {
        return CryptoHelper.wrapAES(key, blob, 0, blob.length, true);
    }

    public static byte[] secureWrapBlob(byte[] key, byte[] blob) {
        byte[] wrapped = CryptoHelper.wrapBlob(key, blob);
        Arrays.fill(key, (byte)0);
        return wrapped;
    }

    public static byte[] unwrapAES(byte[] key, byte[] data, boolean hasnonce) {
        AESWrapEngine aes = new AESWrapEngine();
        KeyParameter keyparam = new KeyParameter(key);
        aes.init(false, keyparam);
        try {
            byte[] unpadded = CryptoHelper.unpadPKCS7(aes.unwrap(data, 0, data.length));
            if (hasnonce) {
                return Arrays.copyOfRange(unpadded, 8, unpadded.length);
            }
            return unpadded;
        }
        catch (InvalidCipherTextException icte) {
            return null;
        }
    }

    public static byte[] unwrapAES(byte[] key, byte[] data) {
        return CryptoHelper.unwrapAES(key, data, false);
    }

    public static byte[] secureUnwrapAES(byte[] key, byte[] data) {
        byte[] unwrapped = CryptoHelper.unwrapAES(key, data);
        Arrays.fill(key, (byte)0);
        return unwrapped;
    }

    public static byte[] unwrapBlob(byte[] key, byte[] blob) {
        return CryptoHelper.unwrapAES(key, blob, true);
    }

    public static byte[] secureUnwrapBlob(byte[] key, byte[] blob) {
        byte[] unwrapped = CryptoHelper.unwrapBlob(key, blob);
        Arrays.fill(key, (byte)0);
        return unwrapped;
    }

    public static byte[] encryptRSA(Key key, byte[] data) {
        try {
            int len;
            PKCS1Encoding c = new PKCS1Encoding(new RSABlindedEngine());
            if (key instanceof RSAPublicKey) {
                c.init(true, new RSAKeyParameters(true, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent()));
            } else if (key instanceof RSAPrivateKey) {
                c.init(true, new RSAKeyParameters(true, ((RSAPrivateKey)key).getModulus(), ((RSAPrivateKey)key).getPrivateExponent()));
            } else {
                return null;
            }
            int insize = c.getInputBlockSize();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int offset = 0; offset < data.length; offset += len) {
                len = Math.min(insize, data.length - offset);
                baos.write(c.processBlock(data, offset, len));
            }
            return baos.toByteArray();
        }
        catch (InvalidCipherTextException icte) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static byte[] decryptRSA(Key key, byte[] data) {
        try {
            int len;
            PKCS1Encoding c = new PKCS1Encoding(new RSABlindedEngine());
            if (key instanceof RSAPublicKey) {
                c.init(false, new RSAKeyParameters(true, ((RSAPublicKey)key).getModulus(), ((RSAPublicKey)key).getPublicExponent()));
            } else if (key instanceof RSAPrivateKey) {
                c.init(false, new RSAKeyParameters(true, ((RSAPrivateKey)key).getModulus(), ((RSAPrivateKey)key).getPrivateExponent()));
            } else {
                return null;
            }
            int insize = c.getInputBlockSize();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int offset = 0; offset < data.length; offset += len) {
                len = Math.min(insize, data.length - offset);
                baos.write(c.processBlock(data, offset, len));
            }
            return baos.toByteArray();
        }
        catch (InvalidCipherTextException icte) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static byte[] sign(String algorithm, PrivateKey key, byte[] data) {
        try {
            Signature signature = Signature.getInstance(algorithm, "BC");
            signature.initSign(key, sr);
            signature.update(data);
            return signature.sign();
        }
        catch (SignatureException se) {
            return null;
        }
        catch (InvalidKeyException ike) {
            return null;
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
        catch (NoSuchProviderException nspe) {
            return null;
        }
    }

    public static boolean verify(String algorithm, PublicKey key, byte[] data, byte[] sig) {
        try {
            Signature signature = Signature.getInstance(algorithm, "BC");
            signature.initVerify(key);
            signature.update(data);
            return signature.verify(sig);
        }
        catch (SignatureException se) {
            return false;
        }
        catch (InvalidKeyException ike) {
            return false;
        }
        catch (NoSuchAlgorithmException nsae) {
            return false;
        }
        catch (NoSuchProviderException nspe) {
            return false;
        }
    }

    public static PublicKey sshKeyBlobToPublicKey(byte[] blob) {
        byte[] keyType = CryptoHelper.decodeNetworkString(blob, 0);
        int offset = 4 + keyType.length;
        String keyTypeStr = new String(keyType);
        try {
            if (SSH_DSS_PREFIX.equals(keyTypeStr)) {
                byte[] p = CryptoHelper.decodeNetworkString(blob, offset);
                offset += 4;
                byte[] q = CryptoHelper.decodeNetworkString(blob, offset += p.length);
                offset += 4;
                byte[] g = CryptoHelper.decodeNetworkString(blob, offset += q.length);
                offset += 4;
                byte[] y = CryptoHelper.decodeNetworkString(blob, offset += g.length);
                offset += 4;
                offset += y.length;
                DSAPublicKeySpec key = new DSAPublicKeySpec(new BigInteger(y), new BigInteger(p), new BigInteger(q), new BigInteger(g));
                return KeyFactory.getInstance("DSA").generatePublic(key);
            }
            if (SSH_RSA_PREFIX.equals(keyTypeStr)) {
                byte[] e = CryptoHelper.decodeNetworkString(blob, offset);
                offset += 4;
                byte[] n = CryptoHelper.decodeNetworkString(blob, offset += e.length);
                offset += 4;
                offset += n.length;
                RSAPublicKeySpec key = new RSAPublicKeySpec(new BigInteger(n), new BigInteger(e));
                return KeyFactory.getInstance("RSA").generatePublic(key);
            }
            return null;
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            return null;
        }
        catch (InvalidKeySpecException ikse) {
            ikse.printStackTrace();
            return null;
        }
    }

    public static byte[] sshKeyBlobFingerprint(byte[] blob) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(blob);
            return md5.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }

    public static byte[] sshPrivateKeyBlobFromKeyPair(KeyPair kp) {
        if (kp.getPrivate() instanceof RSAPrivateKey) {
            BigInteger n = ((RSAPublicKey)kp.getPublic()).getModulus();
            BigInteger e = ((RSAPublicKey)kp.getPublic()).getPublicExponent();
            BigInteger d = ((RSAPrivateKey)kp.getPrivate()).getPrivateExponent();
            BigInteger iqmp = BigInteger.ZERO;
            BigInteger p = BigInteger.ZERO;
            BigInteger q = BigInteger.ZERO;
            byte[] tns = null;
            try {
                tns = CryptoHelper.encodeNetworkString(SSH_RSA_PREFIX.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            byte[] nns = CryptoHelper.encodeNetworkString(n.toByteArray());
            byte[] ens = CryptoHelper.encodeNetworkString(e.toByteArray());
            byte[] dns = CryptoHelper.encodeNetworkString(d.toByteArray());
            byte[] iqmpns = CryptoHelper.encodeNetworkString(iqmp.toByteArray());
            byte[] pns = CryptoHelper.encodeNetworkString(p.toByteArray());
            byte[] qns = CryptoHelper.encodeNetworkString(q.toByteArray());
            byte[] blob = new byte[tns.length + nns.length + ens.length + dns.length + iqmpns.length + pns.length + qns.length];
            System.arraycopy(tns, 0, blob, 0, tns.length);
            System.arraycopy(nns, 0, blob, tns.length, nns.length);
            System.arraycopy(ens, 0, blob, tns.length + nns.length, ens.length);
            System.arraycopy(dns, 0, blob, tns.length + nns.length + ens.length, dns.length);
            System.arraycopy(iqmpns, 0, blob, tns.length + nns.length + ens.length + dns.length, iqmpns.length);
            System.arraycopy(pns, 0, blob, tns.length + nns.length + ens.length + dns.length + iqmpns.length, pns.length);
            System.arraycopy(qns, 0, blob, tns.length + nns.length + ens.length + dns.length + iqmpns.length + pns.length, qns.length);
            return blob;
        }
        if (kp.getPrivate() instanceof DSAPrivateKey) {
            BigInteger p = ((DSAPublicKey)kp.getPublic()).getParams().getP();
            BigInteger q = ((DSAPublicKey)kp.getPublic()).getParams().getQ();
            BigInteger g = ((DSAPublicKey)kp.getPublic()).getParams().getG();
            BigInteger y = ((DSAPublicKey)kp.getPublic()).getY();
            BigInteger x = ((DSAPrivateKey)kp.getPrivate()).getX();
            byte[] tns = null;
            try {
                tns = CryptoHelper.encodeNetworkString(SSH_DSS_PREFIX.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            byte[] pns = CryptoHelper.encodeNetworkString(p.toByteArray());
            byte[] qns = CryptoHelper.encodeNetworkString(q.toByteArray());
            byte[] gns = CryptoHelper.encodeNetworkString(g.toByteArray());
            byte[] yns = CryptoHelper.encodeNetworkString(y.toByteArray());
            byte[] xns = CryptoHelper.encodeNetworkString(x.toByteArray());
            byte[] blob = new byte[tns.length + pns.length + qns.length + gns.length + yns.length + xns.length];
            System.arraycopy(tns, 0, blob, 0, tns.length);
            System.arraycopy(pns, 0, blob, tns.length, pns.length);
            System.arraycopy(qns, 0, blob, tns.length + pns.length, qns.length);
            System.arraycopy(gns, 0, blob, tns.length + pns.length + qns.length, gns.length);
            System.arraycopy(yns, 0, blob, tns.length + pns.length + qns.length + gns.length, yns.length);
            System.arraycopy(xns, 0, blob, tns.length + pns.length + qns.length + gns.length + yns.length, xns.length);
            return blob;
        }
        return null;
    }

    public static byte[] sshKeyBlobFromPublicKey(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            BigInteger e = ((RSAPublicKey)key).getPublicExponent();
            BigInteger n = ((RSAPublicKey)key).getModulus();
            byte[] tns = null;
            try {
                tns = CryptoHelper.encodeNetworkString(SSH_RSA_PREFIX.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            byte[] ens = CryptoHelper.encodeNetworkString(e.toByteArray());
            byte[] nns = CryptoHelper.encodeNetworkString(n.toByteArray());
            byte[] blob = new byte[tns.length + nns.length + ens.length];
            System.arraycopy(tns, 0, blob, 0, tns.length);
            System.arraycopy(ens, 0, blob, tns.length, ens.length);
            System.arraycopy(nns, 0, blob, tns.length + ens.length, nns.length);
            return blob;
        }
        if (key instanceof DSAPublicKey) {
            BigInteger p = ((DSAPublicKey)key).getParams().getP();
            BigInteger q = ((DSAPublicKey)key).getParams().getQ();
            BigInteger g = ((DSAPublicKey)key).getParams().getG();
            BigInteger y = ((DSAPublicKey)key).getY();
            byte[] tns = null;
            try {
                tns = CryptoHelper.encodeNetworkString(SSH_DSS_PREFIX.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            byte[] pns = CryptoHelper.encodeNetworkString(p.toByteArray());
            byte[] qns = CryptoHelper.encodeNetworkString(q.toByteArray());
            byte[] gns = CryptoHelper.encodeNetworkString(g.toByteArray());
            byte[] yns = CryptoHelper.encodeNetworkString(y.toByteArray());
            byte[] blob = new byte[tns.length + pns.length + qns.length + gns.length + yns.length];
            System.arraycopy(tns, 0, blob, 0, tns.length);
            System.arraycopy(pns, 0, blob, tns.length, pns.length);
            System.arraycopy(qns, 0, blob, tns.length + pns.length, qns.length);
            System.arraycopy(gns, 0, blob, tns.length + pns.length + qns.length, gns.length);
            System.arraycopy(yns, 0, blob, tns.length + pns.length + qns.length + gns.length, yns.length);
            return blob;
        }
        return null;
    }

    public static byte[] sshSignatureBlobSign(byte[] data, PrivateKey key) {
        try {
            if (key instanceof RSAPrivateKey) {
                Signature signature = Signature.getInstance("SHA1withRSA");
                signature.initSign(key);
                signature.update(data);
                byte[] sig = signature.sign();
                byte[] tns = null;
                try {
                    tns = CryptoHelper.encodeNetworkString(SSH_RSA_PREFIX.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
                byte[] sns = CryptoHelper.encodeNetworkString(sig);
                byte[] blob = new byte[tns.length + sns.length];
                System.arraycopy(tns, 0, blob, 0, tns.length);
                System.arraycopy(sns, 0, blob, tns.length, sns.length);
                return blob;
            }
            if (key instanceof DSAPrivateKey) {
                Signature signature = Signature.getInstance("SHA1withDSA");
                signature.initSign(key);
                signature.update(data);
                byte[] asn1sig = signature.sign();
                int frst = asn1sig[3] - 20;
                int scnd = asn1sig[1] - 44 - frst;
                byte[] sshsig = new byte[asn1sig.length - frst - scnd - 6];
                System.arraycopy(asn1sig, 4 + frst, sshsig, 0, 20);
                System.arraycopy(asn1sig, 6 + asn1sig[3] + scnd, sshsig, 20, 20);
                byte[] tns = null;
                try {
                    tns = CryptoHelper.encodeNetworkString(SSH_DSS_PREFIX.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
                byte[] sns = CryptoHelper.encodeNetworkString(sshsig);
                byte[] blob = new byte[tns.length + sns.length];
                System.arraycopy(tns, 0, blob, 0, tns.length);
                System.arraycopy(sns, 0, blob, tns.length, sns.length);
                return blob;
            }
            return null;
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
        catch (InvalidKeyException ike) {
            return null;
        }
        catch (SignatureException se) {
            return null;
        }
    }

    public static boolean sshSignatureBlobVerify(byte[] data, int off, int len, byte[] sigBlob, PublicKey pubkey) {
        Signature signature = null;
        int offset = 0;
        byte[] sigType = CryptoHelper.decodeNetworkString(sigBlob, 0);
        offset += 4;
        offset += sigType.length;
        String sigTypeStr = new String(sigType);
        try {
            if (pubkey instanceof RSAPublicKey && SSH_RSA_PREFIX.equals(sigTypeStr)) {
                signature = Signature.getInstance("SHA1withRSA");
                signature.initVerify(pubkey);
                signature.update(data, off, len);
                byte[] sig = CryptoHelper.decodeNetworkString(sigBlob, offset);
                return signature.verify(sig);
            }
            if (pubkey instanceof DSAPublicKey && SSH_DSS_PREFIX.equals(sigTypeStr)) {
                signature = Signature.getInstance("SHA1withDSA");
                signature.initVerify(pubkey);
                signature.update(data, off, len);
                byte[] rs = CryptoHelper.decodeNetworkString(sigBlob, offset);
                int frst = (rs[0] & 0x80) != 0 ? 1 : 0;
                int scnd = (rs[20] & 0x80) != 0 ? 1 : 0;
                int length = rs.length + 6 + frst + scnd;
                byte[] asn1sig = new byte[length];
                asn1sig[0] = 48;
                asn1sig[1] = 44;
                asn1sig[1] = (byte)(asn1sig[1] + frst);
                asn1sig[1] = (byte)(asn1sig[1] + scnd);
                asn1sig[2] = 2;
                asn1sig[3] = 20;
                asn1sig[3] = (byte)(asn1sig[3] + frst);
                System.arraycopy(rs, 0, asn1sig, 4 + frst, 20);
                asn1sig[4 + asn1sig[3]] = 2;
                asn1sig[5 + asn1sig[3]] = 20;
                int n = 5 + asn1sig[3];
                asn1sig[n] = (byte)(asn1sig[n] + scnd);
                System.arraycopy(rs, 20, asn1sig, 6 + asn1sig[3] + scnd, 20);
                return signature.verify(asn1sig);
            }
            return false;
        }
        catch (NoSuchAlgorithmException nsae) {
            return false;
        }
        catch (SignatureException se) {
            return false;
        }
        catch (InvalidKeyException ike) {
            return false;
        }
    }

    public static boolean sshSignatureBlobVerify(byte[] data, byte[] sigBlob, PublicKey pubkey) {
        return CryptoHelper.sshSignatureBlobVerify(data, 0, data.length, sigBlob, pubkey);
    }

    public static byte[] decodeNetworkString(byte[] data, int offset) {
        int len = CryptoHelper.unpackInt(data, offset);
        if (len > data.length - offset - 4) {
            return null;
        }
        byte[] string = new byte[len];
        System.arraycopy(data, offset + 4, string, 0, len);
        return string;
    }

    public static byte[] encodeNetworkString(byte[] data) {
        byte[] ns = new byte[4 + data.length];
        CryptoHelper.packInt(data.length, ns, 0);
        System.arraycopy(data, 0, ns, 4, data.length);
        return ns;
    }

    private static void packInt(int value, byte[] data, int offset) {
        data[0] = (byte)(value >> 24 & 0xFF);
        data[1] = (byte)(value >> 16 & 0xFF);
        data[2] = (byte)(value >> 8 & 0xFF);
        data[3] = (byte)(value & 0xFF);
    }

    private static int unpackInt(byte[] data, int offset) {
        int value = 0;
        value |= data[offset] << 24 & 0xFF000000;
        value |= data[offset + 1] << 16 & 0xFF0000;
        value |= data[offset + 2] << 8 & 0xFF00;
        return value |= data[offset + 3] & 0xFF;
    }

    public static List<byte[]> SSSSSplit(byte[] data, int n, int k) {
        int i;
        if (n < 2 || n > 255 || k < 2 || k > n) {
            return null;
        }
        ArrayList<byte[]> secrets = new ArrayList<byte[]>();
        SSSS ss = new SSSS();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        OutputStream[] baos = new ByteArrayOutputStream[n];
        for (i = 0; i < n; ++i) {
            baos[i] = new ByteArrayOutputStream();
        }
        try {
            ss.encode(bais, baos, k);
        }
        catch (IOException ioe) {
            return null;
        }
        for (i = 0; i < n; ++i) {
            secrets.add(((ByteArrayOutputStream)baos[i]).toByteArray());
        }
        return secrets;
    }

    public static byte[] SSSSRecover(Collection<byte[]> secrets) {
        SSSS ss = new SSSS();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream[] bais = new ByteArrayInputStream[secrets.size()];
        int i = 0;
        for (byte[] secret : secrets) {
            bais[i] = new ByteArrayInputStream(secret);
            ++i;
        }
        try {
            ss.decode(baos, bais);
        }
        catch (SSSSDuplicateAbscissaException dpe) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
        return baos.toByteArray();
    }

    public static List<PGPPublicKey> PGPPublicKeysFromKeyRing(String keyring) throws IOException {
        Object o;
        PGPObjectFactory factory = new PGPObjectFactory(PGPUtil.getDecoderStream(new ByteArrayInputStream(keyring.getBytes("UTF-8"))));
        ArrayList<PGPPublicKey> pubkeys = new ArrayList<PGPPublicKey>();
        while (null != (o = factory.nextObject())) {
            if (!(o instanceof PGPKeyRing)) continue;
            PGPKeyRing ring = (PGPKeyRing)o;
            Iterator iter = ring.getPublicKeys();
            while (iter.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)iter.next();
                pubkeys.add(key);
            }
        }
        return pubkeys;
    }

    public static byte[] encryptPGP(byte[] data, PGPPublicKey key, boolean armored, String name, int compressionAlgorithm, int encAlgorithm) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream out = armored ? new ArmoredOutputStream(baos) : baos;
        BcPGPDataEncryptorBuilder dataEncryptor = new BcPGPDataEncryptorBuilder(encAlgorithm);
        dataEncryptor.setWithIntegrityPacket(true);
        dataEncryptor.setSecureRandom(CryptoHelper.getSecureRandom());
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(dataEncryptor);
        encryptedDataGenerator.addMethod(new BcPublicKeyKeyEncryptionMethodGenerator(key));
        try {
            OutputStream encout = encryptedDataGenerator.open(out, 1024L);
            PGPCompressedDataGenerator pgpcdg = new PGPCompressedDataGenerator(compressionAlgorithm);
            OutputStream compout = pgpcdg.open(encout);
            PGPLiteralDataGenerator pgpldg = new PGPLiteralDataGenerator(false);
            OutputStream ldout = pgpldg.open(compout, 'b', name, data.length, PGPLiteralData.NOW);
            ldout.write(data);
            ldout.close();
            compout.close();
            encout.close();
            out.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (PGPException pgpe) {
            throw new IOException(pgpe);
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        try {
            sr = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (NoSuchProviderException nspe) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (null == sr) {
            sr = new SecureRandom();
        }
    }

    public static final class SSSS {
        private SSSSPolynomialInterpolator interpolator;
        private SecureRandom prng;

        public SSSS() {
            this.interpolator = new SSSSLagrangePolynomialInterpolator();
            this.prng = sr;
        }

        public SSSS(SecureRandom rand) {
            this.interpolator = new SSSSLagrangePolynomialInterpolator();
            this.prng = rand;
        }

        public SSSS(SecureRandom rand, SSSSPolynomialInterpolator pi) {
            this.interpolator = pi;
            this.prng = rand;
        }

        public void decode(OutputStream result, InputStream[] keys) throws IOException, SSSSDuplicateAbscissaException {
            SSSSXY[] pGroup;
            do {
                if ((pGroup = this.readPoints(keys)) == null) continue;
                result.write(this.decodeByte(pGroup));
            } while (pGroup != null);
        }

        private int decodeByte(SSSSXY[] points) throws IOException, SSSSDuplicateAbscissaException {
            SSSSPolynomial fit = this.interpolator.interpolate(points);
            SSSSGF256Polynomial result = (SSSSGF256Polynomial)fit.f(new SSSSGF256Polynomial(0));
            return result.intValue();
        }

        private SSSSXY[] readPoints(InputStream[] keys) throws IOException {
            SSSSXY[] result = new SSSSXY[keys.length];
            for (int i = 0; i < result.length; ++i) {
                int yVal;
                int xVal;
                do {
                    if ((xVal = keys[i].read()) < 0) {
                        return null;
                    }
                    yVal = keys[i].read();
                    if (yVal >= 0) continue;
                    return null;
                } while (xVal == 0);
                result[i] = new SSSSXY(new SSSSGF256Polynomial(xVal), new SSSSGF256Polynomial(yVal));
            }
            return result;
        }

        public void encode(InputStream input, OutputStream[] keys, int keysNeeded) throws IOException {
            int v;
            if (keys.length < 2 || keys.length > 255 || keysNeeded < 2 || keysNeeded > keys.length) {
                throw new RuntimeException("Need to have at least 2 keys and at most 255 and more keys than number of needed keys.");
            }
            do {
                if ((v = input.read()) < 0) continue;
                this.encodeByte(v, keys, keysNeeded);
            } while (v >= 0);
        }

        private void encodeByte(int byteVal, OutputStream[] keys, int keysNeeded) throws IOException {
            boolean[] picked = new boolean[256];
            SSSSPolynomial rPoly = this.selectRandomPolynomial(keysNeeded - 1, new SSSSGF256Polynomial(byteVal));
            for (int i = 0; i < keys.length; ++i) {
                int xPick;
                do {
                    if ((xPick = this.getRandomByte()) != 0) continue;
                    keys[i].write(xPick);
                    keys[i].write(this.getRandomByte());
                } while (xPick == 0 || picked[xPick]);
                picked[xPick] = true;
                SSSSGF256Polynomial xVal = new SSSSGF256Polynomial(xPick);
                SSSSGF256Polynomial yVal = (SSSSGF256Polynomial)rPoly.f(xVal);
                keys[i].write(xVal.intValue());
                keys[i].write(yVal.intValue());
            }
        }

        private SSSSPolynomial selectRandomPolynomial(int degree, SSSSGF256Polynomial c0) {
            int cDegree;
            SSSSNumber[] coeff = new SSSSNumber[degree + 1];
            coeff[0] = c0;
            for (int i = 1; i < degree; ++i) {
                coeff[i] = new SSSSGF256Polynomial(this.getRandomByte());
            }
            while ((cDegree = this.getRandomByte()) == 0) {
            }
            coeff[degree] = new SSSSGF256Polynomial(cDegree);
            return new SSSSPolynomial(coeff);
        }

        private int getRandomByte() {
            byte[] v = new byte[1];
            this.prng.nextBytes(v);
            return v[0] & 0xFF;
        }
    }

    public static final class SSSSGF256Polynomial
    extends SSSSNumber {
        private short value;
        private static final int GF256_GENERATOR = 2;
        private static final int GF256_PRIME_POLYNOMIAL = 285;
        public static final short[] GF256_exptable = new short[256];
        public static final short[] GF256_logtable = new short[256];

        public SSSSGF256Polynomial(int v) {
            this.value = (short)v;
        }

        @Override
        public SSSSNumber add(SSSSNumber b) {
            if (b instanceof SSSSGF256Polynomial) {
                SSSSGF256Polynomial bPoly = (SSSSGF256Polynomial)b;
                return new SSSSGF256Polynomial(bPoly.value ^ this.value);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber sub(SSSSNumber b) {
            return this.add(b);
        }

        @Override
        public SSSSNumber mul(SSSSNumber b) {
            if (b instanceof SSSSGF256Polynomial) {
                SSSSGF256Polynomial bPoly = (SSSSGF256Polynomial)b;
                if (bPoly.value == 0 || this.value == 0) {
                    return this.zero();
                }
                int newPower = (this.log() + bPoly.log()) % 255;
                return new SSSSGF256Polynomial(GF256_exptable[newPower]);
            }
            throw new RuntimeException("Type mismatch.");
        }

        @Override
        public SSSSNumber div(SSSSNumber b) {
            if (b instanceof SSSSGF256Polynomial) {
                SSSSGF256Polynomial bPoly = (SSSSGF256Polynomial)b;
                if (bPoly.value == 0) {
                    throw new RuntimeException("Division by zero.");
                }
                if (this.value == 0) {
                    return this.zero();
                }
                int newPower = (this.log() - bPoly.log()) % 255;
                if (newPower < 0) {
                    newPower += 255;
                }
                return new SSSSGF256Polynomial(GF256_exptable[newPower]);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber neg() {
            return new SSSSGF256Polynomial(-this.value);
        }

        @Override
        public SSSSNumber zero() {
            return new SSSSGF256Polynomial(0);
        }

        @Override
        public SSSSNumber one() {
            return new SSSSGF256Polynomial(1);
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        private int log() {
            if (0 == this.value) {
                throw new RuntimeException("Cannot take log of 0");
            }
            return GF256_logtable[this.value];
        }

        public String toString() {
            return Short.toString(this.value);
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof SSSSGF256Polynomial) {
                SSSSGF256Polynomial oPoly = (SSSSGF256Polynomial)o;
                if (oPoly.value == this.value) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public SSSSGF256Polynomial clone() {
            return new SSSSGF256Polynomial(this.intValue());
        }

        static {
            SSSSGF256Polynomial.GF256_logtable[0] = 1;
            SSSSGF256Polynomial.GF256_exptable[0] = 1;
            for (int i = 1; i < 256; ++i) {
                int exp = GF256_exptable[i - 1] * 2;
                if (exp >= 256) {
                    exp ^= 0x11D;
                }
                SSSSGF256Polynomial.GF256_exptable[i] = (short)(exp &= 0xFF);
                SSSSGF256Polynomial.GF256_logtable[SSSSGF256Polynomial.GF256_exptable[i]] = (short)((short)i % 255);
            }
        }
    }

    private static class SSSSLagrangePolynomialInterpolator
    implements SSSSPolynomialInterpolator {
        private SSSSLagrangePolynomialInterpolator() {
        }

        @Override
        public SSSSPolynomial interpolate(SSSSXY[] points) throws SSSSDuplicateAbscissaException {
            SSSSNumber result = null;
            this.checkPointSeparation(points);
            for (int j = 0; j < points.length; ++j) {
                result = result != null ? result.add(this.Lj(points, j)) : this.Lj(points, j);
            }
            return (SSSSPolynomial)result;
        }

        private void checkPointSeparation(SSSSXY[] points) throws SSSSDuplicateAbscissaException {
            for (int i = 0; i < points.length - 1; ++i) {
                for (int j = i + 1; j < points.length; ++j) {
                    if (!points[i].getX().equals(points[j].getX())) continue;
                    throw new SSSSDuplicateAbscissaException();
                }
            }
        }

        private SSSSNumber Lj(SSSSXY[] points, int j) {
            SSSSNumber one = points[0].getX().one();
            SSSSNumber[] resultP = new SSSSNumber[]{points[j].getY()};
            SSSSNumber[] product = new SSSSNumber[2];
            SSSSNumber result = new SSSSPolynomial(resultP);
            for (int i = 0; i < points.length; ++i) {
                if (i == j) continue;
                SSSSNumber numerator = one;
                SSSSNumber denominator = points[j].getX().sub(points[i].getX());
                product[1] = numerator.div(denominator);
                numerator = points[i].getX();
                denominator = points[i].getX().sub(points[j].getX());
                product[0] = numerator.div(denominator);
                SSSSPolynomial poly = new SSSSPolynomial(product);
                result = ((SSSSNumber)result).mul(poly);
            }
            return result;
        }
    }

    private static interface SSSSPolynomialInterpolator {
        public SSSSPolynomial interpolate(SSSSXY[] var1) throws SSSSDuplicateAbscissaException;
    }

    private static class SSSSDuplicateAbscissaException
    extends Exception {
        public SSSSDuplicateAbscissaException() {
            super("Abscissa collision detected during interpolation");
        }
    }

    private static final class SSSSXY
    extends SSSSNumber {
        SSSSNumber x;
        SSSSNumber y;

        public SSSSXY(SSSSNumber x, SSSSNumber y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public SSSSNumber add(SSSSNumber b) {
            if (b instanceof SSSSXY) {
                SSSSXY bXY = (SSSSXY)b;
                return new SSSSXY(this.getX().add(bXY.getX()), this.getY().add(bXY.getY()));
            }
            throw new UnsupportedOperationException("Need to add an instance of SSSSXY.");
        }

        @Override
        public SSSSNumber sub(SSSSNumber b) {
            if (b instanceof SSSSXY) {
                SSSSXY bXY = (SSSSXY)b;
                return new SSSSXY(this.getX().sub(bXY.getX()), this.getY().sub(bXY.getY()));
            }
            throw new UnsupportedOperationException("Need to add an instance of SSSSXY.");
        }

        @Override
        public SSSSNumber mul(SSSSNumber b) {
            if (b instanceof SSSSXY) {
                SSSSXY bXY = (SSSSXY)b;
                return new SSSSXY(this.getX().mul(bXY.getX()), this.getY().mul(bXY.getY()));
            }
            return new SSSSXY(this.getX().mul(b), this.getY().mul(b));
        }

        @Override
        public SSSSNumber div(SSSSNumber b) {
            if (b instanceof SSSSXY) {
                SSSSXY bXY = (SSSSXY)b;
                return new SSSSXY(this.getX().div(bXY.getX()), this.getY().div(bXY.getY()));
            }
            return new SSSSXY(this.getX().div(b), this.getY().div(b));
        }

        @Override
        public SSSSNumber neg() {
            return new SSSSXY(this.getX().neg(), this.getY().neg());
        }

        @Override
        public SSSSNumber zero() {
            return new SSSSXY(this.getX().zero(), this.getY().zero());
        }

        @Override
        public SSSSNumber one() {
            return new SSSSXY(this.getX().one(), this.getY().one());
        }

        public SSSSNumber getX() {
            return this.x;
        }

        public SSSSNumber getY() {
            return this.y;
        }

        @Override
        public int intValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long longValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float floatValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double doubleValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SSSSXY clone() {
            return new SSSSXY(this.x, this.y);
        }
    }

    private static final class SSSSPolynomial
    extends SSSSNumber {
        SSSSNumber[] coefficients;

        public SSSSPolynomial(SSSSNumber[] c) {
            this.coefficients = new SSSSNumber[c.length];
            for (int i = 0; i < c.length; ++i) {
                if (null == c[i]) {
                    throw new RuntimeException("Null coefficient for degree " + i);
                }
                this.coefficients[i] = c[i].clone();
            }
        }

        public SSSSNumber f(SSSSNumber x) {
            SSSSNumber result = this.coefficients[this.coefficients.length - 1];
            for (int i = this.coefficients.length - 1; i > 0; --i) {
                result = result.mul(x);
                result = result.add(this.coefficients[i - 1]);
            }
            return result;
        }

        @Override
        public SSSSNumber add(SSSSNumber b) {
            SSSSNumber[] result;
            if (b instanceof SSSSPolynomial) {
                int i;
                SSSSPolynomial bPoly = (SSSSPolynomial)b;
                int degMin = Math.min(this.coefficients.length, bPoly.coefficients.length);
                int degMax = Math.max(this.coefficients.length, bPoly.coefficients.length);
                boolean bBigger = bPoly.coefficients.length > this.coefficients.length;
                result = new SSSSNumber[degMax];
                for (i = 0; i < degMin; ++i) {
                    result[i] = this.coefficients[i].add(bPoly.coefficients[i]);
                }
                for (i = degMin; i < degMax; ++i) {
                    result[i] = bBigger ? bPoly.coefficients[i] : this.coefficients[i];
                }
            } else {
                result = this.copy();
                result[0].add(b);
            }
            return new SSSSPolynomial(result);
        }

        @Override
        public SSSSNumber sub(SSSSNumber b) {
            SSSSNumber[] result;
            if (b instanceof SSSSPolynomial) {
                int i;
                SSSSPolynomial bPoly = (SSSSPolynomial)b;
                int degMin = Math.min(this.coefficients.length, bPoly.coefficients.length);
                int degMax = Math.max(this.coefficients.length, bPoly.coefficients.length);
                boolean bBigger = bPoly.coefficients.length > this.coefficients.length;
                result = new SSSSNumber[degMax];
                for (i = 0; i < degMin; ++i) {
                    result[i] = this.coefficients[i].sub(bPoly.coefficients[i]);
                }
                for (i = degMin; i < degMax; ++i) {
                    result[i] = bBigger ? bPoly.coefficients[i].neg() : this.coefficients[i];
                }
            } else {
                result = this.copy();
                result[0].add(b);
            }
            return new SSSSPolynomial(result);
        }

        @Override
        public SSSSNumber mul(SSSSNumber b) {
            SSSSNumber[] result;
            if (b instanceof SSSSPolynomial) {
                SSSSPolynomial bPoly = (SSSSPolynomial)b;
                result = new SSSSNumber[this.coefficients.length + bPoly.coefficients.length - 1];
                for (int i = 0; i < this.coefficients.length; ++i) {
                    for (int j = 0; j < bPoly.coefficients.length; ++j) {
                        SSSSNumber co = this.coefficients[i].mul(bPoly.coefficients[j]);
                        result[i + j] = result[i + j] == null ? co : result[i + j].add(co);
                    }
                }
            } else {
                result = this.copy();
                for (int i = 0; i < result.length; ++i) {
                    result[i] = result[i].mul(b);
                }
            }
            return new SSSSPolynomial(result);
        }

        @Override
        public SSSSNumber div(SSSSNumber b) {
            return null;
        }

        @Override
        public SSSSNumber neg() {
            SSSSNumber[] result = this.copy();
            for (int i = 0; i < result.length; ++i) {
                result[i] = result[i].neg();
            }
            return new SSSSPolynomial(result);
        }

        @Override
        public SSSSNumber zero() {
            return this.coefficients[0].zero();
        }

        @Override
        public SSSSNumber one() {
            return this.coefficients[0].one();
        }

        public int getDegree() {
            if (this.coefficients.length > 0) {
                return this.coefficients.length - 1;
            }
            return 0;
        }

        public SSSSNumber getCoefficient(int index) {
            return this.coefficients[index];
        }

        @Override
        public int intValue() {
            return this.coefficients[0].intValue();
        }

        @Override
        public long longValue() {
            return this.coefficients[0].longValue();
        }

        @Override
        public float floatValue() {
            return this.coefficients[0].floatValue();
        }

        @Override
        public double doubleValue() {
            return this.coefficients[0].doubleValue();
        }

        private SSSSNumber[] copy() {
            SSSSNumber[] result = new SSSSNumber[this.coefficients.length];
            System.arraycopy(this.coefficients, 0, result, 0, this.coefficients.length);
            return result;
        }

        private int degree(SSSSNumber[] coeff) {
            if (null == coeff) {
                return 0;
            }
            for (int i = coeff.length - 1; i >= 0; --i) {
                if (coeff[i].equals(coeff[i].zero())) continue;
                return i;
            }
            return 0;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (int i = this.getDegree(); i >= 0; --i) {
                result.append(this.getCoefficient(i));
                result.append("*x^");
                result.append(i);
                result.append(' ');
            }
            return result.toString();
        }

        @Override
        public SSSSPolynomial clone() {
            return new SSSSPolynomial(this.coefficients);
        }
    }

    private static final class SSSSDouble
    extends SSSSNumber {
        private double value;

        public SSSSDouble(double v) {
            this.value = v;
        }

        @Override
        public SSSSNumber add(SSSSNumber b) {
            if (b instanceof SSSSDouble) {
                SSSSDouble bDouble = (SSSSDouble)b;
                return new SSSSDouble(this.value + bDouble.value);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber sub(SSSSNumber b) {
            if (b instanceof SSSSDouble) {
                SSSSDouble bDouble = (SSSSDouble)b;
                return new SSSSDouble(this.value - bDouble.value);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber mul(SSSSNumber b) {
            if (b instanceof SSSSDouble) {
                SSSSDouble bDouble = (SSSSDouble)b;
                return new SSSSDouble(this.value * bDouble.value);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber div(SSSSNumber b) {
            if (b instanceof SSSSDouble) {
                SSSSDouble bDouble = (SSSSDouble)b;
                return new SSSSDouble(this.value / bDouble.value);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber neg() {
            return new SSSSDouble(-this.value);
        }

        @Override
        public SSSSNumber zero() {
            return new SSSSDouble(0.0);
        }

        @Override
        public SSSSNumber one() {
            return new SSSSDouble(1.0);
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public float floatValue() {
            return (float)this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof SSSSDouble) {
                return this.value == ((SSSSDouble)o).value;
            }
            return false;
        }

        public String toString() {
            return Double.toString(this.value);
        }

        @Override
        public SSSSDouble clone() {
            return new SSSSDouble(this.doubleValue());
        }
    }

    private static final class SSSSInt
    extends SSSSNumber {
        private int value;

        public SSSSInt(int v) {
            this.value = v;
        }

        @Override
        public SSSSNumber add(SSSSNumber b) {
            if (b instanceof SSSSInt) {
                SSSSInt bInt = (SSSSInt)b;
                return new SSSSInt(this.value + bInt.value);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber sub(SSSSNumber b) {
            if (b instanceof SSSSInt) {
                SSSSInt bInt = (SSSSInt)b;
                return new SSSSInt(this.value - bInt.value);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber mul(SSSSNumber b) {
            if (b instanceof SSSSInt) {
                SSSSInt bInt = (SSSSInt)b;
                return new SSSSInt(this.value * bInt.value);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber div(SSSSNumber b) {
            if (b instanceof SSSSInt) {
                SSSSInt bInt = (SSSSInt)b;
                return new SSSSInt(this.value / bInt.value);
            }
            throw new RuntimeException("Type mismatch");
        }

        @Override
        public SSSSNumber neg() {
            return new SSSSInt(-this.value);
        }

        @Override
        public SSSSNumber zero() {
            return new SSSSInt(0);
        }

        @Override
        public SSSSNumber one() {
            return new SSSSInt(1);
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof SSSSInt) {
                return this.value == ((SSSSInt)o).value;
            }
            return false;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        @Override
        public SSSSInt clone() {
            return new SSSSInt(this.intValue());
        }
    }

    private static abstract class SSSSNumber
    extends Number {
        private SSSSNumber() {
        }

        public abstract SSSSNumber add(SSSSNumber var1);

        public abstract SSSSNumber sub(SSSSNumber var1);

        public abstract SSSSNumber mul(SSSSNumber var1);

        public abstract SSSSNumber div(SSSSNumber var1);

        public abstract SSSSNumber neg();

        public abstract SSSSNumber zero();

        public abstract SSSSNumber one();

        public abstract SSSSNumber clone();
    }

    public static class SSHAgentClient {
        private static final int AGENT_FAILURE = 5;
        private static final int AGENT_SUCCESS = 6;
        private static final int AGENTC_REQUEST_IDENTITIES = 11;
        private static final int AGENT_IDENTITIES_ANSWER = 12;
        private static final int AGENTC_SIGN_REQUEST = 13;
        private static final int AGENT_SIGN_RESPONSE = 14;
        private static final int AGENTC_ADD_IDENTITY = 17;
        private static boolean hasJUDS = false;
        private UnixDomainSocketClient socket = null;
        private Socket sock = null;
        private InputStream in = null;
        private OutputStream out = null;
        private ByteArrayOutputStream buffer = null;

        public SSHAgentClient() throws IOException {
            this(System.getenv("SSH_AUTH_SOCK"));
        }

        public SSHAgentClient(String path) throws IOException {
            if (null != System.getProperty("juds.in") && null != System.getProperty("juds.out")) {
                this.in = new FileInputStream(System.getProperty("juds.in"));
                this.out = new FileOutputStream(System.getProperty("juds.out"));
            } else if (null != System.getProperty("juds.addr") && null != System.getProperty("juds.port")) {
                this.sock = new Socket();
                InetSocketAddress endpoint = new InetSocketAddress(System.getProperty("juds.addr"), (int)Integer.valueOf(System.getProperty("juds.port")));
                this.sock.connect(endpoint);
                this.in = this.sock.getInputStream();
                this.out = this.sock.getOutputStream();
            } else if (hasJUDS) {
                this.socket = new UnixDomainSocketClient(path, 1);
                this.in = this.socket.getInputStream();
                this.out = this.socket.getOutputStream();
            } else {
                throw new RuntimeException("No JUDS Support, use -Djuds.in=... -Djuds.out=... or -Djuds.addr=... -Djuds.port=...");
            }
            this.buffer = new ByteArrayOutputStream();
        }

        public void close() {
            if (null != this.sock) {
                try {
                    this.sock.close();
                }
                catch (IOException ioe) {}
            } else if (null != this.socket) {
                this.socket.close();
            } else {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void sendRequest(int type, byte[] data) throws IOException {
            byte[] packet = new byte[data.length + 4 + 1];
            CryptoHelper.packInt(data.length + 1, packet, 0);
            packet[4] = (byte)type;
            System.arraycopy(data, 0, packet, 5, data.length);
            this.out.write(packet);
            this.out.flush();
        }

        private Object awaitResponse(AgentCallback callback) throws IOException {
            int packetLen = -1;
            byte[] buf = new byte[128];
            while (true) {
                int len;
                if ((len = this.in.read(buf)) > 0) {
                    this.buffer.write(buf, 0, len);
                }
                if (this.buffer.size() <= 4) continue;
                if (packetLen < 0) {
                    packetLen = CryptoHelper.unpackInt(this.buffer.toByteArray(), 0);
                }
                if (this.buffer.size() >= 4 + packetLen) break;
            }
            byte[] inbuf = this.buffer.toByteArray();
            byte[] packet = new byte[packetLen];
            System.arraycopy(inbuf, 4, packet, 0, packetLen);
            this.buffer.reset();
            this.buffer.write(inbuf, 4 + packetLen, inbuf.length - packetLen - 4);
            byte respType = packet[0];
            if (5 == respType) {
                return callback.onFailure(packet);
            }
            if (6 == respType) {
                return callback.onSuccess(new byte[0]);
            }
            return callback.onSuccess(packet);
        }

        public boolean addIdentity(byte[] keyblob, String comment) throws IOException {
            ByteArrayOutputStream request = new ByteArrayOutputStream();
            request.write(keyblob);
            request.write(CryptoHelper.encodeNetworkString(comment.getBytes()));
            this.sendRequest(17, request.toByteArray());
            return (Boolean)this.awaitResponse(new AgentCallback(){

                @Override
                public Object onFailure(byte[] packet) {
                    return false;
                }

                @Override
                public Object onSuccess(byte[] packet) {
                    return true;
                }
            });
        }

        public byte[] sign(byte[] keyblob, byte[] data) throws IOException {
            ByteArrayOutputStream request = new ByteArrayOutputStream();
            request.write(CryptoHelper.encodeNetworkString(keyblob));
            request.write(CryptoHelper.encodeNetworkString(data));
            request.write(new byte[4]);
            this.sendRequest(13, request.toByteArray());
            return (byte[])this.awaitResponse(new AgentCallback(){

                @Override
                public Object onFailure(byte[] packet) {
                    return null;
                }

                @Override
                public Object onSuccess(byte[] packet) {
                    if (14 != packet[0]) {
                        return null;
                    }
                    byte[] signature = CryptoHelper.decodeNetworkString(packet, 1);
                    return signature;
                }
            });
        }

        public List<SSHKey> requestIdentities() throws IOException {
            this.sendRequest(11, new byte[0]);
            Object result = this.awaitResponse(new AgentCallback(){

                @Override
                public Object onFailure(byte[] packet) {
                    return null;
                }

                @Override
                public Object onSuccess(byte[] packet) {
                    if (12 != packet[0]) {
                        return null;
                    }
                    ArrayList<SSHKey> keys = new ArrayList<SSHKey>();
                    int offset = 1;
                    int numKeys = CryptoHelper.unpackInt(packet, offset);
                    offset += 4;
                    for (int i = 0; i < numKeys; ++i) {
                        SSHKey key = new SSHKey();
                        key.blob = CryptoHelper.decodeNetworkString(packet, offset);
                        byte[] comment = CryptoHelper.decodeNetworkString(packet, offset += 4 + key.blob.length);
                        key.comment = new String(comment);
                        offset += 4 + comment.length;
                        try {
                            key.fingerprint = new String(Hex.encode(CryptoHelper.sshKeyBlobFingerprint(key.blob)), "UTF-8");
                        }
                        catch (UnsupportedEncodingException uee) {
                            // empty catch block
                        }
                        keys.add(key);
                    }
                    return keys;
                }
            });
            return (List)result;
        }

        static {
            try {
                Class<?> c = Class.forName("com.etsy.net.UnixDomainSocket");
                hasJUDS = true;
            }
            catch (Throwable t) {
                hasJUDS = false;
            }
            finally {
                if (!hasJUDS) {
                    System.err.println("No JUDS support, please use -Djuds.in=... -Djuds.out=... or -Djuds.addr=... -Djuds.port=...");
                }
            }
        }

        public static class SSHKey {
            public byte[] blob;
            public String comment;
            public String fingerprint;

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.fingerprint);
                sb.append(" ");
                sb.append(this.comment);
                return sb.toString();
            }
        }

        private static interface AgentCallback {
            public Object onSuccess(byte[] var1);

            public Object onFailure(byte[] var1);
        }
    }
}

