/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss;

import com.geoxp.oss.CryptoHelper;
import com.geoxp.oss.OSSException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MasterSecretGenerator {
    private static final byte[] MASTER_SECRET_WRAPPING_KEY = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");

    public static Map<PGPPublicKey, byte[]> generate(byte[] secret, List<PGPPublicKey> keys, int k) throws OSSException {
        if (null == secret) {
            SecureRandom sr = CryptoHelper.getSecureRandom();
            secret = new byte[32];
            sr.nextBytes(secret);
        } else {
            if (null == (secret = CryptoHelper.unwrapAES(MASTER_SECRET_WRAPPING_KEY, secret))) {
                throw new OSSException("Invalid secret to split. The input was not generated by OSSGenMasterSecret/OSSSplit with k=1.");
            }
            if (secret.length != 32) {
                throw new OSSException("Invalid secret length, MUST be 32 bytes (256 bits).");
            }
        }
        byte[] wrappedsecret = CryptoHelper.wrapAES(MASTER_SECRET_WRAPPING_KEY, secret);
        return MasterSecretGenerator.generate(keys, k, wrappedsecret);
    }

    public static Map<PGPPublicKey, byte[]> generate(List<PGPPublicKey> keys, int k, byte[] wrappedsecret) throws OSSException {
        if (null == keys) {
            throw new OSSException("Missing public PGP Public Keys.");
        }
        HashSet<String> nonEncryptionFingerprints = new HashSet<String>();
        for (PGPPublicKey pGPPublicKey : keys) {
            if (pGPPublicKey.isEncryptionKey()) continue;
            nonEncryptionFingerprints.add(new String(Hex.encode(pGPPublicKey.getFingerprint())));
        }
        if (!nonEncryptionFingerprints.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("PGP Public Keys need to be encryption keys, the following keys were not:");
            for (String fpr : nonEncryptionFingerprints) {
                sb.append(" ");
                sb.append(fpr);
            }
            throw new OSSException(sb.toString());
        }
        if (k < 1 || k > keys.size()) {
            throw new OSSException("Invalid number of needed shares, was " + k + ", should have been in [1," + keys.size() + "]");
        }
        HashMap<PGPPublicKey, byte[]> perkeysecret = new HashMap<PGPPublicKey, byte[]>();
        if (k == 1) {
            for (PGPPublicKey key : keys) {
                try {
                    perkeysecret.put(key, CryptoHelper.encryptPGP(wrappedsecret, key, true, "", 1, 9));
                }
                catch (IOException ioe) {
                    throw new OSSException(ioe);
                }
            }
        } else {
            List<byte[]> list = CryptoHelper.SSSSSplit(wrappedsecret, keys.size(), k);
            for (int i = 0; i < keys.size(); ++i) {
                PGPPublicKey key = keys.get(i);
                byte[] share = list.get(i);
                try {
                    perkeysecret.put(key, CryptoHelper.encryptPGP(share, key, true, "", 1, 9));
                    continue;
                }
                catch (IOException ioe) {
                    throw new OSSException(ioe);
                }
            }
        }
        return perkeysecret;
    }

    public static byte[] getMasterSecretWrappingKey() {
        return MASTER_SECRET_WRAPPING_KEY;
    }
}

