/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.client;

import com.geoxp.oss.CryptoHelper;
import com.geoxp.oss.MasterSecretGenerator;
import com.geoxp.oss.OSSException;
import com.geoxp.oss.jarjar.com.google.gson.JsonElement;
import com.geoxp.oss.jarjar.com.google.gson.JsonObject;
import com.geoxp.oss.jarjar.com.google.gson.JsonParser;
import com.geoxp.oss.jarjar.org.apache.http.HttpEntity;
import com.geoxp.oss.jarjar.org.apache.http.HttpResponse;
import com.geoxp.oss.jarjar.org.apache.http.client.ClientProtocolException;
import com.geoxp.oss.jarjar.org.apache.http.client.HttpClient;
import com.geoxp.oss.jarjar.org.apache.http.client.methods.HttpGet;
import com.geoxp.oss.jarjar.org.apache.http.client.methods.HttpPost;
import com.geoxp.oss.jarjar.org.apache.http.client.utils.URIBuilder;
import com.geoxp.oss.jarjar.org.apache.http.entity.StringEntity;
import com.geoxp.oss.jarjar.org.apache.http.impl.client.DefaultHttpClient;
import com.geoxp.oss.jarjar.org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import com.geoxp.oss.jarjar.org.apache.http.util.EntityUtils;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.util.encoders.Base64;
import com.geoxp.oss.jarjar.org.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ProxySelector;
import java.net.URI;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSSClient {
    public static final String OSS_RSA = "oss.rsa";

    private static HttpClient newHttpClient() {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(httpclient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        httpclient.setRoutePlanner(routePlanner);
        return httpclient;
    }

    public static Map<String, String> genMasterSecret(byte[] secret, List<String> pubrings, List<String> pgpkeyids, int k) throws OSSException {
        try {
            ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>();
            for (String pubring : pubrings) {
                List<PGPPublicKey> pubkeys = CryptoHelper.PGPPublicKeysFromKeyRing(pubring);
                block3: for (PGPPublicKey key : pubkeys) {
                    String id = "000000000000000" + Long.toHexString(key.getKeyID()).toLowerCase();
                    id = id.substring(id.length() - 16);
                    for (String keyid : pgpkeyids) {
                        if (!id.endsWith(keyid.toLowerCase())) continue;
                        keys.add(key);
                        continue block3;
                    }
                }
            }
            if (keys.size() < pgpkeyids.size()) {
                throw new OSSException("Some keys not present in the provided key rings.");
            }
            Map<PGPPublicKey, byte[]> shares = MasterSecretGenerator.generate(secret, keys, k);
            HashMap<String, String> strshares = new HashMap<String, String>();
            for (Map.Entry<PGPPublicKey, byte[]> entry : shares.entrySet()) {
                String id = "000000000000000" + Long.toHexString(entry.getKey().getKeyID());
                id = id.substring(id.length() - 16);
                strshares.put(id, new String(entry.getValue(), "UTF-8"));
            }
            return strshares;
        }
        catch (Exception e) {
            throw new OSSException(e);
        }
    }

    public static void genSecret(String ossURL, String secretName, String sshKeyFingerprint) throws OSSException {
        CryptoHelper.SSHAgentClient agent = null;
        HttpClient httpclient = null;
        try {
            agent = new CryptoHelper.SSHAgentClient();
            List<CryptoHelper.SSHAgentClient.SSHKey> sshkeys = agent.requestIdentities();
            ArrayList<String> fingerprints = new ArrayList<String>();
            if (null == sshKeyFingerprint) {
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    fingerprints.add(key.fingerprint);
                }
            } else {
                fingerprints.add(sshKeyFingerprint.toLowerCase().replaceAll("[^0-9a-f]", ""));
            }
            int idx = 0;
            for (String fingerprint : fingerprints) {
                ++idx;
                byte[] keyblob = null;
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    if (!key.fingerprint.equals(fingerprint)) continue;
                    keyblob = key.blob;
                    break;
                }
                if (null == keyblob) {
                    throw new OSSException("SSH Key " + sshKeyFingerprint + " was not found by your SSH agent.");
                }
                ByteArrayOutputStream token = new ByteArrayOutputStream();
                byte[] tsdata = OSSClient.nowBytes();
                token.write(CryptoHelper.encodeNetworkString(tsdata));
                token.write(CryptoHelper.encodeNetworkString(secretName.getBytes("UTF-8")));
                token.write(CryptoHelper.encodeNetworkString(keyblob));
                byte[] sigblob = agent.sign(keyblob, token.toByteArray());
                token.write(CryptoHelper.encodeNetworkString(sigblob));
                String b64token = new String(Base64.encode(token.toByteArray()), "UTF-8");
                httpclient = OSSClient.newHttpClient();
                URIBuilder builder = new URIBuilder(ossURL + "/GenSecret");
                builder.addParameter("token", b64token);
                URI uri = builder.build();
                String qs = uri.getRawQuery();
                HttpPost post = new HttpPost(uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + uri.getPath());
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                post.setEntity(new StringEntity(qs));
                HttpResponse response = httpclient.execute(post);
                post.reset();
                if (200 != response.getStatusLine().getStatusCode()) {
                    if (idx != fingerprints.size()) continue;
                    throw new OSSException("None of the provided keys (" + idx + ") could be used to generate secret. Latest error message was: " + response.getStatusLine().getReasonPhrase());
                }
                return;
            }
        }
        catch (OSSException osse) {
            throw osse;
        }
        catch (Exception e) {
            throw new OSSException(e);
        }
        finally {
            if (null != httpclient) {
                httpclient.getConnectionManager().shutdown();
            }
            if (null != agent) {
                agent.close();
            }
        }
    }

    public static byte[] getSecret(String ossURL, String secretName, String sshKeyFingerprint) throws OSSException {
        HttpClient httpclient = null;
        CryptoHelper.SSHAgentClient agent = null;
        try {
            agent = new CryptoHelper.SSHAgentClient();
            List<CryptoHelper.SSHAgentClient.SSHKey> sshkeys = agent.requestIdentities();
            ArrayList<String> fingerprints = new ArrayList<String>();
            if (null == sshKeyFingerprint) {
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    fingerprints.add(key.fingerprint);
                }
            } else {
                fingerprints.add(sshKeyFingerprint.toLowerCase().replaceAll("[^0-9a-f]", ""));
            }
            int idx = 0;
            for (String fingerprint : fingerprints) {
                ++idx;
                byte[] keyblob = null;
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    if (!key.fingerprint.equals(fingerprint)) continue;
                    keyblob = key.blob;
                    break;
                }
                if (null == keyblob) {
                    throw new OSSException("SSH Key " + sshKeyFingerprint + " was not found by your SSH agent.");
                }
                RSAKeyPairGenerator rsagen = new RSAKeyPairGenerator();
                RSAKeyGenerationParameters params = new RSAKeyGenerationParameters(new BigInteger("65537"), CryptoHelper.getSecureRandom(), 4096, 64);
                rsagen.init(params);
                final AsymmetricCipherKeyPair keypair = rsagen.generateKeyPair();
                RSAPrivateKey rsapriv = new RSAPrivateKey(){

                    @Override
                    public BigInteger getModulus() {
                        return ((RSAKeyParameters)keypair.getPrivate()).getModulus();
                    }

                    @Override
                    public String getFormat() {
                        return "PKCS#8";
                    }

                    @Override
                    public byte[] getEncoded() {
                        return null;
                    }

                    @Override
                    public String getAlgorithm() {
                        return "RSA";
                    }

                    @Override
                    public BigInteger getPrivateExponent() {
                        return ((RSAKeyParameters)keypair.getPrivate()).getExponent();
                    }
                };
                RSAPublicKey rsapub = new RSAPublicKey(){

                    @Override
                    public BigInteger getModulus() {
                        return ((RSAKeyParameters)keypair.getPublic()).getModulus();
                    }

                    @Override
                    public String getFormat() {
                        return "PKCS#8";
                    }

                    @Override
                    public byte[] getEncoded() {
                        return null;
                    }

                    @Override
                    public String getAlgorithm() {
                        return "RSA";
                    }

                    @Override
                    public BigInteger getPublicExponent() {
                        return ((RSAKeyParameters)keypair.getPublic()).getExponent();
                    }
                };
                ByteArrayOutputStream token = new ByteArrayOutputStream();
                byte[] tsdata = OSSClient.nowBytes();
                token.write(CryptoHelper.encodeNetworkString(tsdata));
                ByteArrayOutputStream subtoken = new ByteArrayOutputStream();
                subtoken.write(CryptoHelper.encodeNetworkString(secretName.getBytes("UTF-8")));
                subtoken.write(CryptoHelper.encodeNetworkString(CryptoHelper.sshKeyBlobFromPublicKey(rsapub)));
                token.write(CryptoHelper.encodeNetworkString(subtoken.toByteArray()));
                token.write(CryptoHelper.encodeNetworkString(keyblob));
                byte[] sigblob = agent.sign(keyblob, token.toByteArray());
                token.write(CryptoHelper.encodeNetworkString(sigblob));
                String b64token = new String(Base64.encode(token.toByteArray()), "UTF-8");
                httpclient = OSSClient.newHttpClient();
                URIBuilder builder = new URIBuilder(ossURL + "/GetSecret");
                builder.addParameter("token", b64token);
                URI uri = builder.build();
                String qs = uri.getRawQuery();
                HttpPost post = new HttpPost(uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + uri.getPath());
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                post.setEntity(new StringEntity(qs));
                HttpResponse response = httpclient.execute(post);
                HttpEntity resEntity = response.getEntity();
                String content = EntityUtils.toString(resEntity, "UTF-8");
                post.reset();
                if (200 != response.getStatusLine().getStatusCode()) {
                    if (idx != fingerprints.size()) continue;
                    throw new OSSException("None of the provided keys (" + idx + ") could be used to retrieve secret. Latest error message was: " + response.getStatusLine().getReasonPhrase());
                }
                byte[] secretandsealedkey = Base64.decode(content);
                byte[] encryptedsecret = CryptoHelper.decodeNetworkString(secretandsealedkey, 0);
                byte[] sealedkey = CryptoHelper.decodeNetworkString(secretandsealedkey, 4 + encryptedsecret.length);
                byte[] wrappingkey = CryptoHelper.decryptRSA(rsapriv, sealedkey);
                byte[] byArray = CryptoHelper.unwrapAES(wrappingkey, encryptedsecret);
                return byArray;
            }
        }
        catch (OSSException osse) {
            throw osse;
        }
        catch (Exception e) {
            throw new OSSException(e);
        }
        finally {
            if (null != httpclient) {
                httpclient.getConnectionManager().shutdown();
            }
            if (null != agent) {
                agent.close();
            }
        }
        return null;
    }

    public static boolean init(String ossURL, byte[] secret, String sshKeyFingerprint) throws OSSException {
        CryptoHelper.SSHAgentClient agent = null;
        HttpClient httpclient = OSSClient.newHttpClient();
        try {
            agent = new CryptoHelper.SSHAgentClient();
            List<CryptoHelper.SSHAgentClient.SSHKey> sshkeys = agent.requestIdentities();
            ArrayList<String> fingerprints = new ArrayList<String>();
            if (null == sshKeyFingerprint) {
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    fingerprints.add(key.fingerprint);
                }
            } else {
                fingerprints.add(sshKeyFingerprint.toLowerCase().replaceAll("[^0-9a-f]", ""));
            }
            int idx = 0;
            for (String fingerprint : fingerprints) {
                ++idx;
                byte[] keyblob = null;
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    if (!key.fingerprint.equals(fingerprint)) continue;
                    keyblob = key.blob;
                    break;
                }
                if (null == keyblob) {
                    throw new OSSException("SSH Key " + sshKeyFingerprint + " was not found by your SSH agent.");
                }
                RSAPublicKey pubkey = OSSClient.getOSSRSA(ossURL);
                ByteArrayOutputStream token = new ByteArrayOutputStream();
                byte[] tsdata = OSSClient.nowBytes();
                token.write(CryptoHelper.encodeNetworkString(tsdata));
                token.write(CryptoHelper.encodeNetworkString(secret));
                token.write(CryptoHelper.encodeNetworkString(keyblob));
                byte[] sigblob = agent.sign(keyblob, token.toByteArray());
                token.write(CryptoHelper.encodeNetworkString(sigblob));
                byte[] aeskey = new byte[32];
                CryptoHelper.getSecureRandom().nextBytes(aeskey);
                byte[] wrappedtoken = CryptoHelper.wrapAES(aeskey, token.toByteArray());
                byte[] sealedaeskey = CryptoHelper.encryptRSA(pubkey, aeskey);
                token.reset();
                token.write(CryptoHelper.encodeNetworkString(wrappedtoken));
                token.write(CryptoHelper.encodeNetworkString(sealedaeskey));
                String b64token = new String(Base64.encode(token.toByteArray()), "UTF-8");
                URIBuilder builder = new URIBuilder(ossURL + "/Init");
                builder.addParameter("token", b64token);
                URI uri = builder.build();
                String qs = uri.getRawQuery();
                HttpPost post = new HttpPost(uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + uri.getPath());
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                post.setEntity(new StringEntity(qs));
                httpclient = OSSClient.newHttpClient();
                HttpResponse response = httpclient.execute(post);
                HttpEntity resEntity = response.getEntity();
                String content = EntityUtils.toString(resEntity, "UTF-8");
                post.reset();
                if (202 == response.getStatusLine().getStatusCode()) {
                    boolean bl = false;
                    return bl;
                }
                if (200 != response.getStatusLine().getStatusCode()) {
                    if (idx != fingerprints.size()) continue;
                    throw new OSSException("None of the provided keys (" + idx + ") could be used to initialize this Open Secret Server. Latest error message was: " + response.getStatusLine().getReasonPhrase());
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (OSSException osse) {
            throw osse;
        }
        catch (Exception e) {
            throw new OSSException(e);
        }
        finally {
            if (null != httpclient) {
                httpclient.getConnectionManager().shutdown();
            }
            if (null != agent) {
                agent.close();
            }
        }
        return false;
    }

    public static void putSecret(String ossURL, String secretname, byte[] secret, String sshKeyFingerprint) throws OSSException {
        CryptoHelper.SSHAgentClient agent = null;
        HttpClient httpclient = null;
        try {
            agent = new CryptoHelper.SSHAgentClient();
            List<CryptoHelper.SSHAgentClient.SSHKey> sshkeys = agent.requestIdentities();
            ArrayList<String> fingerprints = new ArrayList<String>();
            if (null == sshKeyFingerprint) {
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    fingerprints.add(key.fingerprint);
                }
            } else {
                fingerprints.add(sshKeyFingerprint.toLowerCase().replaceAll("[^0-9a-f]", ""));
            }
            int idx = 0;
            for (String fingerprint : fingerprints) {
                ++idx;
                byte[] keyblob = null;
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    if (!key.fingerprint.equals(fingerprint)) continue;
                    keyblob = key.blob;
                    break;
                }
                if (null == keyblob) {
                    throw new OSSException("SSH Key " + sshKeyFingerprint + " was not found by your SSH agent.");
                }
                RSAPublicKey pubkey = OSSClient.getOSSRSA(ossURL);
                ByteArrayOutputStream token = new ByteArrayOutputStream();
                byte[] tsdata = OSSClient.nowBytes();
                token.write(CryptoHelper.encodeNetworkString(tsdata));
                ByteArrayOutputStream subtoken = new ByteArrayOutputStream();
                subtoken.write(CryptoHelper.encodeNetworkString(secretname.getBytes("UTF-8")));
                subtoken.write(CryptoHelper.encodeNetworkString(secret));
                token.write(CryptoHelper.encodeNetworkString(subtoken.toByteArray()));
                token.write(CryptoHelper.encodeNetworkString(keyblob));
                byte[] sigblob = agent.sign(keyblob, token.toByteArray());
                token.write(CryptoHelper.encodeNetworkString(sigblob));
                byte[] aeskey = new byte[32];
                CryptoHelper.getSecureRandom().nextBytes(aeskey);
                byte[] wrappedtoken = CryptoHelper.wrapAES(aeskey, token.toByteArray());
                byte[] sealedaeskey = CryptoHelper.encryptRSA(pubkey, aeskey);
                token.reset();
                token.write(CryptoHelper.encodeNetworkString(wrappedtoken));
                token.write(CryptoHelper.encodeNetworkString(sealedaeskey));
                String b64token = new String(Base64.encode(token.toByteArray()), "UTF-8");
                URIBuilder builder = new URIBuilder(ossURL + "/PutSecret");
                builder.addParameter("token", b64token);
                URI uri = builder.build();
                String qs = uri.getRawQuery();
                HttpPost post = new HttpPost(uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + uri.getPath());
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                post.setEntity(new StringEntity(qs));
                httpclient = OSSClient.newHttpClient();
                HttpResponse response = httpclient.execute(post);
                HttpEntity resEntity = response.getEntity();
                String content = EntityUtils.toString(resEntity, "UTF-8");
                post.reset();
                if (200 != response.getStatusLine().getStatusCode()) {
                    if (idx != fingerprints.size()) continue;
                    throw new OSSException("None of the provided keys (" + idx + ") could be used to store the secret. Latest error message was: " + response.getStatusLine().getReasonPhrase());
                }
                return;
            }
        }
        catch (OSSException osse) {
            throw osse;
        }
        catch (Exception e) {
            throw new OSSException(e);
        }
        finally {
            if (null != httpclient) {
                httpclient.getConnectionManager().shutdown();
            }
            if (null != agent) {
                agent.close();
            }
        }
    }

    public static void addACL(String ossURL, String sshKeyFingerprint, String secretname, List<String> keyfpr) throws OSSException {
        OSSClient.changeACL(false, ossURL, sshKeyFingerprint, secretname, keyfpr);
    }

    public static void removeACL(String ossURL, String sshKeyFingerprint, String secretname, List<String> keyfpr) throws OSSException {
        OSSClient.changeACL(true, ossURL, sshKeyFingerprint, secretname, keyfpr);
    }

    private static void changeACL(boolean remove, String ossURL, String sshKeyFingerprint, String secretname, List<String> keyfpr) throws OSSException {
        CryptoHelper.SSHAgentClient agent = null;
        HttpClient httpclient = null;
        try {
            agent = new CryptoHelper.SSHAgentClient();
            List<CryptoHelper.SSHAgentClient.SSHKey> sshkeys = agent.requestIdentities();
            ArrayList<String> fingerprints = new ArrayList<String>();
            if (null == sshKeyFingerprint) {
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    fingerprints.add(key.fingerprint);
                }
            } else {
                fingerprints.add(sshKeyFingerprint.toLowerCase().replaceAll("[^0-9a-f]", ""));
            }
            int idx = 0;
            for (String fingerprint : fingerprints) {
                ++idx;
                byte[] keyblob = null;
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    if (!key.fingerprint.equals(fingerprint)) continue;
                    keyblob = key.blob;
                    break;
                }
                if (null == keyblob) {
                    throw new OSSException("SSH Key " + sshKeyFingerprint + " was not found by your SSH agent.");
                }
                RSAPublicKey pubkey = OSSClient.getOSSRSA(ossURL);
                ByteArrayOutputStream token = new ByteArrayOutputStream();
                byte[] tsdata = OSSClient.nowBytes();
                token.write(CryptoHelper.encodeNetworkString(tsdata));
                ByteArrayOutputStream subtoken = new ByteArrayOutputStream();
                subtoken.write(CryptoHelper.encodeNetworkString(secretname.getBytes("UTF-8")));
                for (String fpr : keyfpr) {
                    subtoken.write(CryptoHelper.encodeNetworkString(fpr.toLowerCase().replaceAll("[^a-f0-9]", "").getBytes("UTF-8")));
                }
                token.write(CryptoHelper.encodeNetworkString(subtoken.toByteArray()));
                token.write(CryptoHelper.encodeNetworkString(keyblob));
                byte[] sigblob = agent.sign(keyblob, token.toByteArray());
                token.write(CryptoHelper.encodeNetworkString(sigblob));
                byte[] aeskey = new byte[32];
                CryptoHelper.getSecureRandom().nextBytes(aeskey);
                byte[] wrappedtoken = CryptoHelper.wrapAES(aeskey, token.toByteArray());
                byte[] sealedaeskey = CryptoHelper.encryptRSA(pubkey, aeskey);
                token.reset();
                token.write(CryptoHelper.encodeNetworkString(wrappedtoken));
                token.write(CryptoHelper.encodeNetworkString(sealedaeskey));
                String b64token = new String(Base64.encode(token.toByteArray()), "UTF-8");
                URIBuilder builder = new URIBuilder(ossURL + (remove ? "/RemoveACL" : "/AddACL"));
                builder.addParameter("token", b64token);
                URI uri = builder.build();
                String qs = uri.getRawQuery();
                HttpPost post = new HttpPost(uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + uri.getPath());
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                post.setEntity(new StringEntity(qs));
                httpclient = OSSClient.newHttpClient();
                HttpResponse response = httpclient.execute(post);
                HttpEntity resEntity = response.getEntity();
                String content = EntityUtils.toString(resEntity, "UTF-8");
                post.reset();
                if (200 != response.getStatusLine().getStatusCode()) {
                    if (idx != fingerprints.size()) continue;
                    throw new OSSException("None of the provided keys (" + idx + ") could be used to modify ACL. Latest error message was: " + response.getStatusLine().getReasonPhrase());
                }
                return;
            }
        }
        catch (OSSException osse) {
            throw osse;
        }
        catch (Exception e) {
            throw new OSSException(e);
        }
        finally {
            if (null != httpclient) {
                httpclient.getConnectionManager().shutdown();
            }
            if (null != agent) {
                agent.close();
            }
        }
    }

    public static List<String> getACL(String ossURL, String sshKeyFingerprint, String secretName) throws OSSException {
        CryptoHelper.SSHAgentClient agent = null;
        HttpClient httpclient = null;
        try {
            agent = new CryptoHelper.SSHAgentClient();
            List<CryptoHelper.SSHAgentClient.SSHKey> sshkeys = agent.requestIdentities();
            ArrayList<String> fingerprints = new ArrayList<String>();
            if (null == sshKeyFingerprint) {
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    fingerprints.add(key.fingerprint);
                }
            } else {
                fingerprints.add(sshKeyFingerprint.toLowerCase().replaceAll("[^0-9a-f]", ""));
            }
            int idx = 0;
            for (String fingerprint : fingerprints) {
                byte[] f;
                ++idx;
                byte[] keyblob = null;
                for (CryptoHelper.SSHAgentClient.SSHKey key : sshkeys) {
                    if (!key.fingerprint.equals(fingerprint)) continue;
                    keyblob = key.blob;
                    break;
                }
                if (null == keyblob) {
                    throw new OSSException("SSH Key " + sshKeyFingerprint + " was not found by your SSH agent.");
                }
                RSAKeyPairGenerator rsagen = new RSAKeyPairGenerator();
                RSAKeyGenerationParameters params = new RSAKeyGenerationParameters(new BigInteger("65537"), CryptoHelper.getSecureRandom(), 4096, 64);
                rsagen.init(params);
                final AsymmetricCipherKeyPair keypair = rsagen.generateKeyPair();
                RSAPrivateKey rsapriv = new RSAPrivateKey(){

                    @Override
                    public BigInteger getModulus() {
                        return ((RSAKeyParameters)keypair.getPrivate()).getModulus();
                    }

                    @Override
                    public String getFormat() {
                        return "PKCS#8";
                    }

                    @Override
                    public byte[] getEncoded() {
                        return null;
                    }

                    @Override
                    public String getAlgorithm() {
                        return "RSA";
                    }

                    @Override
                    public BigInteger getPrivateExponent() {
                        return ((RSAKeyParameters)keypair.getPrivate()).getExponent();
                    }
                };
                RSAPublicKey rsapub = new RSAPublicKey(){

                    @Override
                    public BigInteger getModulus() {
                        return ((RSAKeyParameters)keypair.getPublic()).getModulus();
                    }

                    @Override
                    public String getFormat() {
                        return "PKCS#8";
                    }

                    @Override
                    public byte[] getEncoded() {
                        return null;
                    }

                    @Override
                    public String getAlgorithm() {
                        return "RSA";
                    }

                    @Override
                    public BigInteger getPublicExponent() {
                        return ((RSAKeyParameters)keypair.getPublic()).getExponent();
                    }
                };
                ByteArrayOutputStream token = new ByteArrayOutputStream();
                byte[] tsdata = OSSClient.nowBytes();
                token.write(CryptoHelper.encodeNetworkString(tsdata));
                ByteArrayOutputStream subtoken = new ByteArrayOutputStream();
                subtoken.write(CryptoHelper.encodeNetworkString(secretName.getBytes("UTF-8")));
                subtoken.write(CryptoHelper.encodeNetworkString(CryptoHelper.sshKeyBlobFromPublicKey(rsapub)));
                token.write(CryptoHelper.encodeNetworkString(subtoken.toByteArray()));
                token.write(CryptoHelper.encodeNetworkString(keyblob));
                byte[] sigblob = agent.sign(keyblob, token.toByteArray());
                token.write(CryptoHelper.encodeNetworkString(sigblob));
                String b64token = new String(Base64.encode(token.toByteArray()), "UTF-8");
                httpclient = OSSClient.newHttpClient();
                URIBuilder builder = new URIBuilder(ossURL + "/GetACL");
                builder.addParameter("token", b64token);
                URI uri = builder.build();
                String qs = uri.getRawQuery();
                HttpPost post = new HttpPost(uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + uri.getPath());
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                post.setEntity(new StringEntity(qs));
                HttpResponse response = httpclient.execute(post);
                HttpEntity resEntity = response.getEntity();
                String content = EntityUtils.toString(resEntity, "UTF-8");
                post.reset();
                if (200 != response.getStatusLine().getStatusCode()) {
                    if (idx != fingerprints.size()) continue;
                    throw new OSSException("None of the provided keys (" + idx + ") could be used to retrieve ACLs. Latest error message was: " + response.getStatusLine().getReasonPhrase());
                }
                byte[] fprandsealedkey = Base64.decode(content);
                byte[] encryptedfpr = CryptoHelper.decodeNetworkString(fprandsealedkey, 0);
                byte[] sealedkey = CryptoHelper.decodeNetworkString(fprandsealedkey, 4 + encryptedfpr.length);
                byte[] wrappingkey = CryptoHelper.decryptRSA(rsapriv, sealedkey);
                byte[] fpr = CryptoHelper.unwrapAES(wrappingkey, encryptedfpr);
                ArrayList<String> res = new ArrayList<String>();
                for (int offset = 0; offset < fpr.length && null != (f = CryptoHelper.decodeNetworkString(fpr, offset)); offset += 4 + f.length) {
                    if (0 >= f.length) continue;
                    res.add(new String(Hex.encode(f), "UTF-8").replaceAll("([0-9a-f]{2})", "$1:"));
                }
                ArrayList<String> arrayList = res;
                return arrayList;
            }
        }
        catch (OSSException osse) {
            throw osse;
        }
        catch (Exception e) {
            throw new OSSException(e);
        }
        finally {
            if (null != httpclient) {
                httpclient.getConnectionManager().shutdown();
            }
            if (null != agent) {
                agent.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPublicKey getOSSRSA(String ossURL) {
        if (null != System.getProperty(OSS_RSA)) {
            final String[] tokens = System.getProperty(OSS_RSA).split(":");
            RSAPublicKey pubkey = new RSAPublicKey(){

                @Override
                public BigInteger getModulus() {
                    return new BigInteger(tokens[0]);
                }

                @Override
                public String getFormat() {
                    return "PKCS#8";
                }

                @Override
                public byte[] getEncoded() {
                    return null;
                }

                @Override
                public String getAlgorithm() {
                    return "RSA";
                }

                @Override
                public BigInteger getPublicExponent() {
                    return new BigInteger(tokens[1]);
                }
            };
            return pubkey;
        }
        System.err.println("Unsecure OSS Instance RSA public key retrieval, you're not protected from Man-In-The-Middle type attacks.");
        HttpClient httpclient = OSSClient.newHttpClient();
        try {
            RSAPublicKey pubkey;
            String getrsauri = ossURL + "/GetOSSRSA";
            HttpGet get = new HttpGet(getrsauri);
            HttpResponse response = httpclient.execute(get);
            HttpEntity resEntity = response.getEntity();
            String content = EntityUtils.toString(resEntity, "UTF-8");
            get.reset();
            JsonParser parser = new JsonParser();
            JsonElement elt = parser.parse(content);
            final JsonObject rsa = elt.getAsJsonObject();
            RSAPublicKey rSAPublicKey = pubkey = new RSAPublicKey(){

                @Override
                public BigInteger getModulus() {
                    return new BigInteger(rsa.get("modulus").getAsString());
                }

                @Override
                public String getFormat() {
                    return "PKCS#8";
                }

                @Override
                public byte[] getEncoded() {
                    return null;
                }

                @Override
                public String getAlgorithm() {
                    return "RSA";
                }

                @Override
                public BigInteger getPublicExponent() {
                    return new BigInteger(rsa.get("exponent").getAsString());
                }
            };
            return rSAPublicKey;
        }
        catch (ClientProtocolException cpe) {
            RSAPublicKey rSAPublicKey = null;
            return rSAPublicKey;
        }
        catch (IOException ioe) {
            RSAPublicKey rSAPublicKey = null;
            return rSAPublicKey;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    private static byte[] nowBytes() {
        byte[] tsdata = new byte[8];
        long ts = System.currentTimeMillis();
        tsdata[0] = (byte)(ts >> 56 & 0xFFL);
        tsdata[1] = (byte)(ts >> 48 & 0xFFL);
        tsdata[2] = (byte)(ts >> 40 & 0xFFL);
        tsdata[3] = (byte)(ts >> 32 & 0xFFL);
        tsdata[4] = (byte)(ts >> 24 & 0xFFL);
        tsdata[5] = (byte)(ts >> 16 & 0xFFL);
        tsdata[6] = (byte)(ts >> 8 & 0xFFL);
        tsdata[7] = (byte)(ts & 0xFFL);
        return tsdata;
    }
}

