/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.client;

import com.geoxp.oss.client.OSSClient;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

public class OSSSplitMasterSecret {
    public static void main(String[] args) throws Exception {
        int len;
        if (3 != args.length) {
            System.err.println("Usage: OSSSplitMasterSecret PATH_TO_PUBRINGS PGP_KEY_IDS K\nSecret to split (from previous OSSGenMasterSecret/OSSSplit with k=1) to be fed as stdin.");
            System.exit(1);
        }
        String[] keyids = args[1].split(",");
        ArrayList<String> pgpkeyids = new ArrayList<String>();
        for (String keyid : keyids) {
            pgpkeyids.add(keyid);
        }
        String[] pubrings = args[0].split(",");
        ArrayList<String> pgppubrings = new ArrayList<String>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        for (String pubring : pubrings) {
            int len2;
            FileInputStream is = new FileInputStream(pubring);
            baos.reset();
            while ((len2 = ((InputStream)is).read(buf)) >= 0) {
                baos.write(buf, 0, len2);
            }
            ((InputStream)is).close();
            baos.close();
            pgppubrings.add(new String(baos.toByteArray(), "UTF-8"));
        }
        ByteArrayOutputStream secret = new ByteArrayOutputStream();
        while ((len = System.in.read(buf)) >= 0) {
            secret.write(buf, 0, len);
        }
        secret.close();
        Map<String, String> shares = OSSClient.genMasterSecret(secret.toByteArray(), pgppubrings, pgpkeyids, Integer.valueOf(args[2]));
        for (Map.Entry<String, String> entry : shares.entrySet()) {
            System.out.println();
            System.out.println("[" + entry.getKey() + "]");
            System.out.println();
            System.out.println(entry.getValue());
        }
    }
}

