/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.http.impl.conn;

import com.geoxp.oss.jarjar.org.apache.commons.logging.Log;
import com.geoxp.oss.jarjar.org.apache.commons.logging.LogFactory;
import com.geoxp.oss.jarjar.org.apache.http.HttpException;
import com.geoxp.oss.jarjar.org.apache.http.HttpMessage;
import com.geoxp.oss.jarjar.org.apache.http.HttpResponseFactory;
import com.geoxp.oss.jarjar.org.apache.http.NoHttpResponseException;
import com.geoxp.oss.jarjar.org.apache.http.ProtocolException;
import com.geoxp.oss.jarjar.org.apache.http.StatusLine;
import com.geoxp.oss.jarjar.org.apache.http.annotation.ThreadSafe;
import com.geoxp.oss.jarjar.org.apache.http.impl.io.AbstractMessageParser;
import com.geoxp.oss.jarjar.org.apache.http.io.SessionInputBuffer;
import com.geoxp.oss.jarjar.org.apache.http.message.LineParser;
import com.geoxp.oss.jarjar.org.apache.http.message.ParserCursor;
import com.geoxp.oss.jarjar.org.apache.http.params.HttpParams;
import com.geoxp.oss.jarjar.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultResponseParser
extends AbstractMessageParser<HttpMessage> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;
    private final int maxGarbageLines;

    public DefaultResponseParser(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, parser, params);
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseFactory = responseFactory;
        this.lineBuf = new CharArrayBuffer(128);
        this.maxGarbageLines = this.getMaxGarbageLines(params);
    }

    protected int getMaxGarbageLines(HttpParams params) {
        return params.getIntParameter("http.connection.max-status-line-garbage", Integer.MAX_VALUE);
    }

    @Override
    protected HttpMessage parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException {
        int count = 0;
        ParserCursor cursor = null;
        while (true) {
            this.lineBuf.clear();
            int i = sessionBuffer.readLine(this.lineBuf);
            if (i == -1 && count == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            cursor = new ParserCursor(0, this.lineBuf.length());
            if (this.lineParser.hasProtocolVersion(this.lineBuf, cursor)) break;
            if (i == -1 || count >= this.maxGarbageLines) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Garbage in response: " + this.lineBuf.toString());
            }
            ++count;
        }
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

