/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.http.protocol;

import com.geoxp.oss.jarjar.org.apache.http.HttpEntity;
import com.geoxp.oss.jarjar.org.apache.http.HttpEntityEnclosingRequest;
import com.geoxp.oss.jarjar.org.apache.http.HttpException;
import com.geoxp.oss.jarjar.org.apache.http.HttpRequest;
import com.geoxp.oss.jarjar.org.apache.http.HttpRequestInterceptor;
import com.geoxp.oss.jarjar.org.apache.http.HttpVersion;
import com.geoxp.oss.jarjar.org.apache.http.ProtocolVersion;
import com.geoxp.oss.jarjar.org.apache.http.annotation.Immutable;
import com.geoxp.oss.jarjar.org.apache.http.params.HttpProtocolParams;
import com.geoxp.oss.jarjar.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntity entity;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null && entity.getContentLength() != 0L) {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (HttpProtocolParams.useExpectContinue(request.getParams()) && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

