/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum;

import com.geoxp.oss.jarjar.org.apache.zookeeper.server.Request;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.RequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.Learner;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.QuorumPacket;
import java.io.Flushable;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SendAckRequestProcessor
implements RequestProcessor,
Flushable {
    private static final Logger LOG = Logger.getLogger(SendAckRequestProcessor.class);
    Learner learner;

    SendAckRequestProcessor(Learner peer) {
        this.learner = peer;
    }

    public void processRequest(Request si) {
        if (si.type != 9) {
            QuorumPacket qp = new QuorumPacket(3, si.hdr.getZxid(), null, null);
            try {
                this.learner.writePacket(qp, false);
            }
            catch (IOException e) {
                LOG.warn((Object)"Closing connection to leader, exception during packet send", (Throwable)e);
                try {
                    if (!this.learner.sock.isClosed()) {
                        this.learner.sock.close();
                    }
                }
                catch (IOException e1) {
                    LOG.debug((Object)"Ignoring error closing the connection", (Throwable)e1);
                }
            }
        }
    }

    public void flush() throws IOException {
        try {
            this.learner.writePacket(null, true);
        }
        catch (IOException e) {
            LOG.warn((Object)"Closing connection to leader, exception during packet send", (Throwable)e);
            try {
                if (!this.learner.sock.isClosed()) {
                    this.learner.sock.close();
                }
            }
            catch (IOException e1) {
                LOG.debug((Object)"Ignoring error closing the connection", (Throwable)e1);
            }
        }
    }

    public void shutdown() {
    }
}

