/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.bcpg;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGInputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGObject;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class MPInteger
extends BCPGObject {
    BigInteger value = null;

    public MPInteger(BCPGInputStream bCPGInputStream) throws IOException {
        int n = bCPGInputStream.read() << 8 | bCPGInputStream.read();
        byte[] byArray = new byte[(n + 7) / 8];
        bCPGInputStream.readFully(byArray);
        this.value = new BigInteger(1, byArray);
    }

    public MPInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0) {
            throw new IllegalArgumentException("value must not be null, or negative");
        }
        this.value = bigInteger;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        int n = this.value.bitLength();
        bCPGOutputStream.write(n >> 8);
        bCPGOutputStream.write(n);
        byte[] byArray = this.value.toByteArray();
        if (byArray[0] == 0) {
            bCPGOutputStream.write(byArray, 1, byArray.length - 1);
        } else {
            bCPGOutputStream.write(byArray, 0, byArray.length);
        }
    }
}

