/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cert;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1OctetString;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.Extension;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.GeneralName;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.GeneralNames;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.cert.X509CertificateHolder;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.DigestCalculator;
import java.io.IOException;
import java.io.OutputStream;

public class X509ExtensionUtils {
    private DigestCalculator calculator;

    public X509ExtensionUtils(DigestCalculator digestCalculator) {
        this.calculator = digestCalculator;
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(X509CertificateHolder x509CertificateHolder) {
        if (x509CertificateHolder.getVersionNumber() != 3) {
            GeneralName generalName = new GeneralName(x509CertificateHolder.getIssuer());
            SubjectPublicKeyInfo subjectPublicKeyInfo = x509CertificateHolder.getSubjectPublicKeyInfo();
            return new AuthorityKeyIdentifier(this.calculateIdentifier(subjectPublicKeyInfo), new GeneralNames(generalName), x509CertificateHolder.getSerialNumber());
        }
        GeneralName generalName = new GeneralName(x509CertificateHolder.getIssuer());
        Extension extension = x509CertificateHolder.getExtension(Extension.subjectKeyIdentifier);
        if (extension != null) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(extension.getParsedValue());
            return new AuthorityKeyIdentifier(aSN1OctetString.getOctets(), new GeneralNames(generalName), x509CertificateHolder.getSerialNumber());
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = x509CertificateHolder.getSubjectPublicKeyInfo();
        return new AuthorityKeyIdentifier(this.calculateIdentifier(subjectPublicKeyInfo), new GeneralNames(generalName), x509CertificateHolder.getSerialNumber());
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new AuthorityKeyIdentifier(this.calculateIdentifier(subjectPublicKeyInfo));
    }

    public SubjectKeyIdentifier createSubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new SubjectKeyIdentifier(this.calculateIdentifier(subjectPublicKeyInfo));
    }

    public SubjectKeyIdentifier createTruncatedSubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        byte[] byArray = this.calculateIdentifier(subjectPublicKeyInfo);
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, byArray.length - 8, byArray2, 0, byArray2.length);
        byArray2[0] = (byte)(byArray2[0] & 0xF);
        byArray2[0] = (byte)(byArray2[0] | 0x40);
        return new SubjectKeyIdentifier(byArray2);
    }

    private byte[] calculateIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        byte[] byArray = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        OutputStream outputStream = this.calculator.getOutputStream();
        try {
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.calculator.getDigest();
    }
}

