/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cms;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.KEKIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.AuthAttributesProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSEnvelopedHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSException;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSSecureReadable;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSTypedStream;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSUtils;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.KEKRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.KEKRecipientId;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.Recipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.RecipientInformation;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.RecipientOperator;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JceKEKAuthenticatedRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JceKEKEnvelopedRecipient;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JceKEKRecipient;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.SecretKey;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        try {
            JceKEKRecipient jceKEKRecipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JceKEKEnvelopedRecipient((SecretKey)key) : new JceKEKAuthenticatedRecipient((SecretKey)key);
            if (provider != null) {
                jceKEKRecipient.setProvider(provider);
            }
            return this.getContentStream(jceKEKRecipient);
        }
        catch (IOException iOException) {
            throw new CMSException("encoding error: " + iOException.getMessage(), iOException);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

