/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cms;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Encodable;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1EncodableVector;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Sequence;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.DERNull;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.DEROctetString;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.OriginatorPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.RecipientInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSException;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.RecipientInfoGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.GenericKey;
import java.io.IOException;

public abstract class KeyAgreeRecipientInfoGenerator
implements RecipientInfoGenerator {
    private ASN1ObjectIdentifier keyAgreementOID;
    private ASN1ObjectIdentifier keyEncryptionOID;
    private SubjectPublicKeyInfo originatorKeyInfo;

    protected KeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
        this.originatorKeyInfo = subjectPublicKeyInfo;
        this.keyAgreementOID = aSN1ObjectIdentifier;
        this.keyEncryptionOID = aSN1ObjectIdentifier2;
    }

    public RecipientInfo generate(GenericKey genericKey) throws CMSException {
        OriginatorIdentifierOrKey originatorIdentifierOrKey = new OriginatorIdentifierOrKey(this.createOriginatorPublicKey(this.originatorKeyInfo));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.keyEncryptionOID);
        aSN1EncodableVector.add(DERNull.INSTANCE);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.keyEncryptionOID, (ASN1Encodable)DERNull.INSTANCE);
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(this.keyAgreementOID, (ASN1Encodable)algorithmIdentifier);
        ASN1Sequence aSN1Sequence = this.generateRecipientEncryptedKeys(algorithmIdentifier2, algorithmIdentifier, genericKey);
        ASN1Encodable aSN1Encodable = this.getUserKeyingMaterial(algorithmIdentifier2);
        if (aSN1Encodable != null) {
            try {
                return new RecipientInfo(new KeyAgreeRecipientInfo(originatorIdentifierOrKey, new DEROctetString(aSN1Encodable), algorithmIdentifier2, aSN1Sequence));
            }
            catch (IOException iOException) {
                throw new CMSException("unable to encode userKeyingMaterial: " + iOException.getMessage(), iOException);
            }
        }
        return new RecipientInfo(new KeyAgreeRecipientInfo(originatorIdentifierOrKey, null, algorithmIdentifier2, aSN1Sequence));
    }

    protected OriginatorPublicKey createOriginatorPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new OriginatorPublicKey(new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithmId().getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE), subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }

    protected abstract ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier var1, AlgorithmIdentifier var2, GenericKey var3) throws CMSException;

    protected abstract ASN1Encodable getUserKeyingMaterial(AlgorithmIdentifier var1) throws CMSException;
}

