/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cms;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.cert.X509CertificateHolder;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.ContentVerifier;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.ContentVerifierProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.DigestCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.DigestCalculatorProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.OperatorCreationException;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;

public class SignerInformationVerifier {
    private ContentVerifierProvider verifierProvider;
    private DigestCalculatorProvider digestProvider;
    private SignatureAlgorithmIdentifierFinder sigAlgorithmFinder;
    private CMSSignatureAlgorithmNameGenerator sigNameGenerator;

    public SignerInformationVerifier(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, ContentVerifierProvider contentVerifierProvider, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigNameGenerator = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgorithmFinder = signatureAlgorithmIdentifierFinder;
        this.verifierProvider = contentVerifierProvider;
        this.digestProvider = digestCalculatorProvider;
    }

    public boolean hasAssociatedCertificate() {
        return this.verifierProvider.hasAssociatedCertificate();
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return this.verifierProvider.getAssociatedCertificate();
    }

    public ContentVerifier getContentVerifier(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) throws OperatorCreationException {
        String string = this.sigNameGenerator.getSignatureName(algorithmIdentifier2, algorithmIdentifier);
        return this.verifierProvider.get(this.sigAlgorithmFinder.find(string));
    }

    public DigestCalculator getDigestCalculator(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        return this.digestProvider.get(algorithmIdentifier);
    }
}

