/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.BlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.MD5Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA1Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA256Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA384Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.AESFastEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.DESedeEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.modes.CBCBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsBlockCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsCipher;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsCipherFactory;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsClientContext;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsFatalAlert;
import java.io.IOException;

public class DefaultTlsCipherFactory
implements TlsCipherFactory {
    public TlsCipher createCipher(TlsClientContext tlsClientContext, int n, int n2) throws IOException {
        switch (n) {
            case 7: {
                return this.createDESedeCipher(tlsClientContext, 24, n2);
            }
            case 8: {
                return this.createAESCipher(tlsClientContext, 16, n2);
            }
            case 9: {
                return this.createAESCipher(tlsClientContext, 32, n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsCipher createAESCipher(TlsClientContext tlsClientContext, int n, int n2) throws IOException {
        return new TlsBlockCipher(tlsClientContext, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createDigest(n2), this.createDigest(n2), n);
    }

    protected TlsCipher createDESedeCipher(TlsClientContext tlsClientContext, int n, int n2) throws IOException {
        return new TlsBlockCipher(tlsClientContext, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createDigest(n2), this.createDigest(n2), n);
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected Digest createDigest(int n) throws IOException {
        switch (n) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA256Digest();
            }
            case 4: {
                return new SHA384Digest();
            }
        }
        throw new TlsFatalAlert(80);
    }
}

