/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls;

import com.geoxp.oss.jarjar.org.bouncycastle.crypto.CryptoException;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.Signer;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.NullDigest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.signers.GenericSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.CombinedHash;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.tls.TlsSigner;
import java.security.SecureRandom;

class TlsRSASigner
implements TlsSigner {
    TlsRSASigner() {
    }

    public byte[] calculateRawSignature(SecureRandom secureRandom, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        GenericSigner genericSigner = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new NullDigest());
        genericSigner.init(true, new ParametersWithRandom(asymmetricKeyParameter, secureRandom));
        genericSigner.update(byArray, 0, byArray.length);
        return genericSigner.generateSignature();
    }

    public Signer createVerifyer(AsymmetricKeyParameter asymmetricKeyParameter) {
        GenericSigner genericSigner = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new CombinedHash());
        genericSigner.init(false, asymmetricKeyParameter);
        return genericSigner;
    }

    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof RSAKeyParameters && !asymmetricKeyParameter.isPrivate();
    }
}

