/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.digest;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.CipherKeyGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.macs.HMac;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.jce.provider.JCEMac;

public class RIPEMD160 {

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD160Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new RIPEMD160Digest((RIPEMD160Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new RIPEMD160Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD160", 160, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD160.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.RIPEMD160", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd160, "RIPEMD160");
            this.addHMACAlgorithm(configurableProvider, "RIPEMD160", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "RIPEMD160", IANAObjectIdentifiers.hmacRIPEMD160);
        }
    }
}

